/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Data;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class PalettePanel
extends Canvas
implements MouseListener,
ActionListener,
MouseMotionListener {
    int SQUAREW = 1;
    int SQUAREH = 1;
    static int PAVEW = 16;
    static int PAVEH = 16;
    static Point paveloc = null;
    static Point oldloc = null;
    static boolean cursorDrawn = false;
    static Color selectedColor = Color.black;
    static int selectedInt = -16777216;
    static int selectedIndex = 0;
    static Color penColor = Color.black;
    static int penInt = -16777216;
    static int penIndex = 0;
    static Color transparentColor = Color.white;
    static int transparentInt = -1;
    static int transparentIndex = 15;
    static Color replaceColor = Color.black;
    static Color[] palColors = new Color[256];
    PopupMenu mousemenu = new PopupMenu();
    public static String message = "OK";
    transient ActionListener actionListener;

    public PalettePanel() {
        this.add(this.mousemenu);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        oldloc = paveloc = new Point(0, 0);
        cursorDrawn = false;
    }

    public static Rectangle align(int x, int y, int w, int h) {
        w = (w - 4) / PAVEW;
        h = (h - 4) / PAVEH;
        w = w * PAVEW + 4 + 6;
        h = h * PAVEH + 4 + 6;
        return new Rectangle(x, y, w, h);
    }

    public void magnifyFactor() {
        Dimension size = this.getSize();
        this.SQUAREW = size.width / PAVEW;
        this.SQUAREH = size.height / PAVEH;
    }

    public void changeColor(int r, int g, int b) {
        Color color;
        PalettePanel.palColors[PalettePanel.selectedIndex] = color = new Color(r, g, b);
        this.display(selectedIndex);
    }

    public static void setColors(Color[] couleurs) {
        int i;
        int l = couleurs.length;
        for (i = 0; i < l; ++i) {
            PalettePanel.palColors[i] = couleurs[i];
        }
        while (i < 256) {
            PalettePanel.palColors[i++] = Color.black;
        }
    }

    public static int colorToInt(Color col) {
        if (col == null) {
            return 0;
        }
        return 0xFF000000 | col.getRed() << 16 | col.getGreen() << 8 | col.getBlue();
    }

    public int getRGB(int index) {
        Color col = palColors[index];
        return 0xFF000000 | col.getRed() << 16 | col.getGreen() << 8 | col.getBlue();
    }

    public static Color intToColor(int i) {
        int alpha = i >> 24 & 0xFF;
        int red = i >> 16 & 0xFF;
        int green = i >> 8 & 0xFF;
        int blue = i & 0xFF;
        return new Color(red, green, blue);
    }

    public static int searchIndex(Color col) {
        return PalettePanel.searchIndex(PalettePanel.colorToInt(col));
    }

    public static int searchIndex(int intColor) {
        for (int index = 0; index < 256; ++index) {
            if (intColor != PalettePanel.colorToInt(palColors[index])) continue;
            return index;
        }
        return -1;
    }

    public void updateCursor() {
        int x;
        this.unCursor();
        int y = penIndex / PAVEW;
        PalettePanel.paveloc.x = x = penIndex - y * PAVEW;
        PalettePanel.paveloc.y = y;
        this.cursor();
    }

    public static void makeIndex() {
        selectedIndex = PalettePanel.paveloc.y * PAVEW + PalettePanel.paveloc.x;
    }

    public void select(int no) {
        this.unCursor();
        PalettePanel.paveloc.y = no / PAVEW;
        PalettePanel.paveloc.x = no - PalettePanel.paveloc.y * PAVEW;
        this.pickColor();
        this.cursor();
    }

    public static void setCurrent() {
        selectedInt = PalettePanel.colorToInt(selectedColor);
        selectedIndex = PalettePanel.searchIndex(selectedInt);
    }

    public static void setCurrent(int no) {
        try {
            selectedColor = palColors[no];
            selectedInt = PalettePanel.colorToInt(selectedColor);
            selectedIndex = no;
        }
        catch (ArrayIndexOutOfBoundsException a) {
            a.printStackTrace();
        }
    }

    public void setPen(Color color) {
        selectedColor = color;
        selectedInt = PalettePanel.colorToInt(color);
        selectedIndex = PalettePanel.searchIndex(selectedInt);
        PalettePanel.setPen();
        this.updateCursor();
    }

    public static void setPen() {
        penColor = selectedColor;
        penInt = PalettePanel.colorToInt(penColor);
        penIndex = PalettePanel.searchIndex(penInt);
    }

    public static void setTransparent() {
        PalettePanel.setTransparent(selectedColor);
    }

    public static void setTransparent(int c) {
        transparentColor = palColors[c];
        transparentInt = PalettePanel.colorToInt(transparentColor);
        transparentIndex = c;
    }

    public static void setTransparent(Color color) {
        transparentColor = color;
        transparentInt = PalettePanel.colorToInt(transparentColor);
        transparentIndex = PalettePanel.searchIndex(transparentInt);
    }

    public static void setReplace(Color color) {
        replaceColor = color;
    }

    public static void reverse() {
        for (int i = 0; i < palColors.length; ++i) {
            Color c = palColors[i];
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            PalettePanel.palColors[i] = new Color(b, g, r);
        }
    }

    public static void lighten() {
        for (int i = 0; i < palColors.length; ++i) {
            Color c = palColors[i];
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            PalettePanel.palColors[i] = new Color(Math.min(r * 2, 255), Math.min(g * 2, 255), Math.min(b * 2, 255));
        }
    }

    public static void darken() {
        for (int i = 0; i < palColors.length; ++i) {
            Color c = palColors[i];
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            PalettePanel.palColors[i] = new Color(r / 2, g / 2, b / 2);
        }
    }

    public void display(int no) {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.magnifyFactor();
            int hs = PAVEW * this.SQUAREH;
            int ws = PAVEH * this.SQUAREW;
            int y = no / PAVEW;
            int x = no - y * PAVEW;
            g.setColor(palColors[no]);
            g.fillRect(x * this.SQUAREW + 1, y * this.SQUAREH + 1, this.SQUAREW - 1, this.SQUAREH - 1);
        }
    }

    public void display() {
        Graphics g = this.getGraphics();
        this.magnifyFactor();
        int hs = PAVEW * this.SQUAREH;
        int ws = PAVEH * this.SQUAREW;
        if (g == null) {
            System.out.println("No graphic context, enable to display palette");
            return;
        }
        int idx = 0;
        for (int y = 1; y < hs; y += this.SQUAREH) {
            for (int x = 1; x < ws; x += this.SQUAREW) {
                if (idx >= 256) continue;
                try {
                    g.setColor(palColors[idx++]);
                    g.fillRect(x, y, this.SQUAREW - 1, this.SQUAREH - 1);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException a) {
                    System.out.println("PalettePanel - Out of bounds index=" + (idx - 1));
                    continue;
                }
                catch (NullPointerException n) {
                    // empty catch block
                }
            }
        }
    }

    public static Color getColor(int no) {
        return palColors[no];
    }

    public ColorModel getColorModel() {
        byte[] a = new byte[256];
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            a[i] = -1;
            r[i] = (byte)palColors[i].getRed();
            g[i] = (byte)palColors[i].getGreen();
            b[i] = (byte)palColors[i].getBlue();
        }
        IndexColorModel colorModel = new IndexColorModel(8, r.length, r, g, b);
        return colorModel;
    }

    public void moveCursor(int x, int y) {
        PalettePanel.paveloc.x = x / this.SQUAREW;
        PalettePanel.paveloc.y = y / this.SQUAREH;
    }

    public void drawCursor(Color color) {
        int i = PalettePanel.oldloc.x;
        int j = PalettePanel.oldloc.y;
        int x = i * this.SQUAREW;
        int y = j * this.SQUAREH;
        Graphics g = this.getGraphics();
        g.setColor(color);
        g.drawRect(x, y, this.SQUAREW, this.SQUAREH);
    }

    public void cursor() {
        oldloc = paveloc;
        this.drawCursor(Color.white);
        cursorDrawn = true;
    }

    public void unCursor() {
        if (cursorDrawn) {
            this.drawCursor(Color.black);
        }
        cursorDrawn = false;
    }

    public Color pickColor() {
        int i = PalettePanel.paveloc.x;
        int j = PalettePanel.paveloc.y;
        if (i >= PAVEW || j >= PAVEH) {
            System.out.println("PickColor error: x " + i + " y " + j + " (Max " + PAVEW + "x" + PAVEH + ")");
        } else {
            PalettePanel.setCurrent(j * PAVEW + i);
        }
        return selectedColor;
    }

    public void paint(Graphics g) {
        this.unCursor();
        this.display();
        this.cursor();
    }

    public static boolean load(String path, String name) {
        int size = Data.getSize(path);
        boolean result = true;
        switch (size) {
            case 1024: {
                int[] buffer = Data.iLoad(path);
                for (int i = 0; i < 256; ++i) {
                    PalettePanel.palColors[i] = PalettePanel.intToColor(buffer[i]);
                }
                break;
            }
            case 768: {
                byte[] buffer = Data.bLoad(path);
                for (int i = 0; i < 256; ++i) {
                    int j = i * 3;
                    byte r = buffer[j];
                    byte g = buffer[j + 1];
                    byte b = buffer[j + 2];
                    PalettePanel.palColors[i] = new Color(r, g, b);
                }
                break;
            }
            default: {
                message = "Unknow palette format " + name;
                result = false;
            }
        }
        return result;
    }

    public static void save(String path, String name) {
        int[] buffer = new int[256];
        for (int i = 0; i < 256; ++i) {
            buffer[i] = PalettePanel.colorToInt(palColors[i]);
        }
        Data.iSave(path, buffer);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        e.consume();
        this.unCursor();
        this.moveCursor(e.getX(), e.getY());
        this.pickColor();
        this.cursor();
        this.sendAction("set");
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    void sendAction(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }
}

