/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Archiver;
import ae.DBPanel;
import ae.DCheckbox;
import ae.DialogCYN;
import ae.DialogMessage;
import ae.DirManager;
import ae.Directory;
import ae.PanelGenerator;
import ae.Path;
import ae.Preferences;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.io.File;

public class PanelArchive
extends PanelGenerator {
    DCheckbox checkRecurse;
    DCheckbox checkInclude;

    public PanelArchive(Frame f) {
        super(f);
        this.setTitle("ARCHIVER");
        this.setAction("Make an archive of selected items");
        DBPanel options = new DBPanel(1);
        options.setLabel("Options");
        this.add((Component)options, "Center");
        this.checkRecurse = new DCheckbox("Recurse sub-directories", Preferences.ArcRecurse);
        this.checkRecurse.setBounds(32, 32, 200, 24);
        this.checkRecurse.addItemListener(this);
        options.add(this.checkRecurse);
        this.checkInclude = new DCheckbox("Include full paths", Preferences.ArcInclude);
        this.checkInclude.setBounds(32, 64, 200, 24);
        this.checkInclude.addItemListener(this);
        options.add(this.checkInclude);
        this.htmlName = "";
    }

    public void init(DirManager src, DirManager tgt, boolean b) {
        super.init(src, tgt, b);
        switch (this.Mode) {
            case 1: {
                this.setAction("Archive the selected file");
                break;
            }
            case 3: {
                this.setAction("Archive content of the selected folder");
                break;
            }
            case 2: {
                this.setAction("Archive the tagged list");
                break;
            }
        }
    }

    public boolean archive(DirManager source) {
        String path = this.getDir();
        String name = this.getFilename();
        String origine = this.getSource();
        Archiver.setMessage("Error");
        if (this.Mode == 0) {
            this.dispTip("Nothing to do! Select files/dir in first panel, please...");
            return false;
        }
        if (name == null || name.length() == 0) {
            this.dispTip("Give a name to the archive, please!");
            return false;
        }
        if (Path.hasExtension(name)) {
            if (Directory.isGZip(name) && this.Mode != 1) {
                this.dispTip("GZip require a single file");
                return false;
            }
            if (!Directory.isArchive(name)) {
                this.dispTip("Give a valid archive extension or none (default is zip)");
                return false;
            }
        } else {
            name = name + ".zip";
        }
        this.setFilename(name);
        String archive = Path.merge(path, name);
        boolean replacing = new File(path, name).exists();
        if (replacing) {
            DialogCYN cd = new DialogCYN(this.frame, "Erasing the current " + name.toUpperCase() + " archive, continue?");
            cd.setVisible(true);
            if (cd.answer != 1) {
                return false;
            }
        }
        boolean result = false;
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (this.Mode == 1) {
            this.message("Archiving " + origine + " into " + archive);
            result = Archiver.archiveAnyFile(origine, archive);
            if (result) {
                this.message("Archive completed");
            } else {
                this.message(Archiver.getMessage());
            }
            this.setCursor(cursor);
            return true;
        }
        String[] fics = source.getSelectedItems();
        String srcpath = null;
        String srcdir = source.getDir();
        if (this.Mode == 3) {
            String fic = fics[0];
            this.message("Archiving " + fic + "'s content into " + archive);
            if (Preferences.ArcInclude) {
                srcpath = srcdir;
            } else {
                srcpath = Path.merge(srcdir, fic);
                fics = new File(srcdir, fic).list();
            }
        }
        if (this.Mode == 2) {
            this.message("Archiving " + origine + " into " + archive);
            srcpath = srcdir;
        }
        if (fics.length > 0) {
            int fr = Archiver.archive(srcpath, fics, archive);
            this.message("Archived " + fr + " files");
            if (Archiver.error) {
                new DialogMessage(this.frame, "Error in archiving").setVisible(true);
            }
        } else {
            this.dispTip("Nothing to do");
        }
        this.setCursor(cursor);
        return true;
    }

    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (object == this.checkRecurse) {
            Preferences.ArcRecurse = this.checkRecurse.getState();
        } else if (object == this.checkInclude) {
            Preferences.ArcInclude = this.checkInclude.getState();
        }
    }
}

