/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DButton;
import ae.DLabel;
import ae.DirManager;
import ae.EmptyPanel;
import ae.Messages;
import ae.OS;
import ae.Path;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;

public class PanelGenerator
extends Panel
implements ActionListener,
ItemListener,
Messages,
KeyListener {
    final short NONE = 0;
    final short SINGLE = 1;
    final short TAGGED = (short)2;
    final short FOLDER = (short)3;
    Frame frame;
    TextField fieldDir;
    TextField fieldName;
    DButton buttonMake;
    DButton buttonCancel;
    DLabel labelTitle;
    DLabel labelSource;
    Label labelName;
    Label labelPath;
    public String htmlFile = null;
    public String htmlName = "generated.htm";
    public String htmlDir = "";
    int Mode = 0;
    public String message = "";
    ActionListener actionListener = null;
    public int action = 0;

    public PanelGenerator(Frame f) {
        this.setVisible(false);
        this.setLayout(new BorderLayout());
        this.frame = f;
        int fieldSize = 24;
        if (!OS.isWindows()) {
            fieldSize = 30;
        }
        EmptyPanel panelFields = new EmptyPanel();
        panelFields.setBounds(0, 0, 450, 270);
        this.add((Component)panelFields, "North");
        Font font = new Font("Dialog", 1, 16);
        this.labelTitle = new DLabel();
        this.labelTitle.setBounds(64, 16, 320, 32);
        this.labelTitle.setFont(new Font("SansSerif", 1, 24));
        this.labelTitle.setTextColor(f.getBackground().darker());
        panelFields.add(this.labelTitle);
        this.labelSource = new DLabel();
        this.labelSource.setBounds(16, 60, 420, 24);
        this.labelSource.setFont(font);
        panelFields.add(this.labelSource);
        this.labelPath = new Label("Path");
        this.labelPath.setBounds(16, 92, 128, 20);
        panelFields.add(this.labelPath);
        this.fieldDir = new TextField();
        this.fieldDir.setBounds(16, 115, 360, fieldSize);
        this.fieldDir.addKeyListener(this);
        panelFields.add(this.fieldDir);
        this.labelName = new Label("Name");
        this.labelName.setBounds(16, 148, 128, 20);
        panelFields.add(this.labelName);
        this.fieldName = new TextField();
        this.fieldName.setBounds(16, 171, 256, fieldSize);
        this.fieldName.addKeyListener(this);
        panelFields.add(this.fieldName);
        this.buttonCancel = new DButton("Cancel", true);
        this.buttonCancel.setBounds(100, 216, 100, 32);
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.setTip("Return to the target panel");
        panelFields.add(this.buttonCancel);
        this.buttonMake = new DButton("Make", true);
        this.buttonMake.setBounds(220, 216, 100, 32);
        this.buttonMake.addActionListener(this);
        panelFields.add(this.buttonMake);
    }

    public void setAction(String action) {
        this.buttonMake.setTip(action);
    }

    public void setTitle(String title) {
        this.labelTitle.setText(title);
    }

    public void setMakeEnabled(boolean f) {
        this.buttonMake.setEnabled(f);
    }

    public void setSource(String p) {
        this.labelSource.setText(p);
    }

    public String getSource() {
        return this.labelSource.getText();
    }

    public void setDir(String p) {
        this.fieldDir.setText(p);
        this.htmlDir = p;
    }

    public String getDir(String d) {
        if (this.htmlDir == null || this.htmlDir == "") {
            return d;
        }
        return this.getDir();
    }

    public String getDir() {
        return this.htmlDir;
    }

    public void makeFile() {
        this.htmlFile = Path.merge(this.htmlDir, this.htmlName);
    }

    public String getFile() {
        return this.htmlFile;
    }

    public void setFilename(String name) {
        this.htmlName = name;
        this.fieldName.setText(name);
    }

    public String getFilename() {
        return this.fieldName.getText();
    }

    public void init(DirManager source, DirManager target, boolean selectall) {
        String origin = null;
        String fic = null;
        String dir = source.getDir();
        int[] se = source.getSelectedIndexes();
        this.Mode = 0;
        this.buttonMake.setEnabled(true);
        switch (se.length) {
            case 1: {
                fic = source.getSelected();
                origin = Path.merge(dir, fic);
                File f = new File(dir, fic);
                if (f.isDirectory()) {
                    this.Mode = 3;
                    break;
                }
                this.Mode = 1;
                break;
            }
            case 0: {
                if (selectall) {
                    source.selectAll();
                } else {
                    this.buttonMake.setEnabled(false);
                    origin = "Select some file please";
                    this.dispTip(origin);
                    break;
                }
            }
            default: {
                this.Mode = 2;
                origin = dir + File.separator + "[TAGGED LIST]";
            }
        }
        this.setSource(origin);
        this.setDir(source.getDir());
        this.setFilename(this.htmlName);
        this.makeFile();
    }

    public void message(String s) {
        this.message = s;
        this.sourceActionEvent(0);
    }

    public void dispTip(String s) {
        this.message = s;
        this.sourceActionEvent(1);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.buttonMake) {
            this.htmlDir = this.fieldDir.getText();
            this.htmlName = this.fieldName.getText();
            this.makeFile();
            this.sourceActionEvent(10);
            return;
        }
        if (object == this.buttonCancel) {
            this.sourceActionEvent(11);
            return;
        }
    }

    protected void sourceActionEvent(int a) {
        if (this.actionListener == null) {
            return;
        }
        this.action = a;
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, null));
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void itemStateChanged(ItemEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        char newc;
        if (event.isControlDown() || event.isAltDown()) {
            return;
        }
        char c = event.getKeyChar();
        if (c != (newc = new Character(c).charValue())) {
            event.consume();
        }
        event.setKeyChar(newc);
    }
}

