/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DBPanel;
import ae.DCheckbox;
import ae.DirManager;
import ae.PanelGenerator;
import ae.Path;
import ae.Preferences;
import ae.TSpinner;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

public class PanelThumbnail
extends PanelGenerator {
    TSpinner spinnerW;
    TSpinner spinnerH;
    DCheckbox checkBorder;
    DCheckbox checkName;
    DCheckbox checkSize;
    DCheckbox checkType;
    String graph = ".png.bmp.gif.jpg.";

    public PanelThumbnail(Frame f) {
        super(f);
        this.setTitle("THUMBNAIL");
        this.setAction("Make a thumbnail of selected files");
        DBPanel options = new DBPanel(1);
        options.setLabel("Options");
        this.add((Component)options, "Center");
        Label sl1 = new Label("Image width");
        sl1.setBounds(24, 22, 92, 20);
        options.add(sl1);
        this.spinnerW = new TSpinner(Preferences.ThumbWidth, 16, 256);
        this.spinnerW.setBounds(118, 22, 72, 20);
        this.spinnerW.addActionListener(this);
        options.add(this.spinnerW);
        Label sl2 = new Label("Cell width");
        sl2.setBounds(220, 22, 74, 20);
        options.add(sl2);
        this.spinnerH = new TSpinner(Preferences.ThumbCell, 16, 256);
        this.spinnerH.setBounds(304, 22, 72, 20);
        this.spinnerH.addActionListener(this);
        options.add(this.spinnerH);
        this.checkName = new DCheckbox("Display the names", Preferences.ThumbName);
        this.checkName.setBounds(20, 64, 156, 22);
        this.checkName.addItemListener(this);
        options.add(this.checkName);
        this.checkBorder = new DCheckbox("Draw a border", Preferences.ThumbBorder);
        this.checkBorder.setBounds(212, 64, 132, 22);
        this.checkBorder.addItemListener(this);
        options.add(this.checkBorder);
        this.checkSize = new DCheckbox("Display the sizes", Preferences.ThumbSize);
        this.checkSize.setBounds(20, 96, 140, 22);
        this.checkSize.addItemListener(this);
        options.add(this.checkSize);
        this.checkType = new DCheckbox("Display the types", Preferences.ThumbType);
        this.checkType.setBounds(212, 96, 140, 22);
        this.checkType.addItemListener(this);
        options.add(this.checkType);
    }

    public void select(DirManager source) {
        if (source.isSelected()) {
            return;
        }
        int number = 0;
        String[] list = source.getFiles();
        for (int i = 0; i < list.length; ++i) {
            String fic = list[i];
            if (fic == null) continue;
            String ext = Path.getExtension(fic).toLowerCase();
            if (!DirManager.inside(this.graph, ext)) continue;
            source.selectCtrl(fic);
            ++number;
        }
        this.dispTip(number + " graphic files with valid format");
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.spinnerW) {
            Preferences.ThumbWidth = this.spinnerW.current;
        } else if (object == this.spinnerH) {
            Preferences.ThumbCell = this.spinnerH.current;
        } else {
            super.actionPerformed(event);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (object == this.checkBorder) {
            Preferences.ThumbBorder = this.checkBorder.getState();
        } else if (object == this.checkName) {
            Preferences.ThumbName = this.checkName.getState();
        } else if (object == this.checkSize) {
            Preferences.ThumbSize = this.checkSize.getState();
        } else if (object == this.checkType) {
            Preferences.ThumbType = this.checkType.getState();
        }
    }
}

