/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.OS;
import java.io.File;

public final class Path {
    public static String ADir;
    public static String Drive;
    public static String Dir;
    public static String Filename;
    public static String Node;
    public static String Extension;

    public static String getCurDir() {
        return System.getProperty("user.dir");
    }

    public static String getUserDir() {
        return Path.getCurDir();
    }

    public static String getCurPath() {
        return Path.getCurDir();
    }

    public static String getSysPath() {
        return Path.getCurDir();
    }

    public static String getCurDrive() {
        if (!OS.isWindows()) {
            return "/";
        }
        return Path.splitDrive(System.getProperty("user.dir"));
    }

    public static boolean hasExtension(String fname) {
        return fname.indexOf(46) != -1;
    }

    public static String getExtension(String path) {
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return path.substring(pos + 1);
    }

    public static String changeExt(String path, String ext) {
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return path + "." + ext;
        }
        return path.substring(0, pos + 1) + ext;
    }

    public static String removeExt(String path) {
        int pos = path.lastIndexOf(46);
        if (pos != -1) {
            path = path.substring(0, pos);
        }
        return path;
    }

    public static boolean isDrive(String sa) {
        if (!OS.isWindows()) {
            return false;
        }
        if (sa == null) {
            return false;
        }
        if (sa.length() == 0) {
            return false;
        }
        if (sa.endsWith(File.separator)) {
            sa = Path.noSuffixed(sa);
        }
        return sa.charAt(1) == ':' && sa.length() == 2;
    }

    public static boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    public static String merge(String path, String nom) {
        if (nom == null) {
            return path;
        }
        if (path == null) {
            path = "";
        }
        if (path.length() == 0) {
            return nom;
        }
        if (path.endsWith(File.separator)) {
            return path + nom;
        }
        return path + File.separator + nom;
    }

    public static String pastePath(String p, String suf) {
        return Path.merge(p, suf);
    }

    public static String merge(String drive, String dir, String nom) {
        if (nom == null) {
            nom = "";
        }
        if (dir == null) {
            dir = "";
        }
        if (drive == null) {
            drive = "";
        }
        if (!drive.endsWith(File.separator)) {
            drive = drive + File.separator;
        }
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return drive + dir + nom;
    }

    public static String splitDrive(String path) {
        if (!OS.isWindows()) {
            return "/";
        }
        int sep = path.indexOf(":");
        if (sep > 0) {
            return path.substring(0, sep + 1);
        }
        return "";
    }

    public static int getUnit(String path) {
        if (!OS.isWindows()) {
            return 0;
        }
        String drive = Path.splitDrive(path).toLowerCase();
        char cdrive = drive.charAt(0);
        return cdrive - 97;
    }

    public static String splitFile(String path) {
        return Path.getFile(path);
    }

    public static String getFile(String path) {
        int dio;
        File f = new File(path);
        if (f.isDirectory()) {
            return "";
        }
        int fio = path.lastIndexOf(File.separator) + 1;
        int aio = path.lastIndexOf(47) + 1;
        int n = fio = (fio = Math.max(fio, aio)) > (dio = path.lastIndexOf(":") + 1) ? fio : dio;
        if (fio > 0) {
            return path.substring(fio);
        }
        return path;
    }

    public static String splitLast(String path) {
        int dio;
        int fio = path.lastIndexOf(File.separator) + 1;
        fio = fio > (dio = path.lastIndexOf(":") + 1) ? fio : dio;
        String last = fio > 0 ? path.substring(fio) : path;
        if (last.equals(File.separator)) {
            last = "";
        }
        return last;
    }

    public static void split(String fullpath) {
        int lio;
        int len = fullpath.length();
        int sep = fullpath.indexOf(":");
        if (sep > 0) {
            Drive = OS.isWindows() ? fullpath.substring(0, ++sep) : "/";
        } else {
            sep = 0;
            Drive = OS.isWindows() ? "" : "/";
        }
        if (fullpath.charAt(sep) == File.separatorChar) {
            ++sep;
        }
        if ((lio = fullpath.lastIndexOf(File.separatorChar)) > sep) {
            Dir = fullpath.substring(sep, lio);
            Filename = fullpath.substring(lio + 1, len);
        } else {
            Dir = "";
            Filename = fullpath.substring(sep, len);
        }
        lio = Filename.indexOf(46);
        if (lio == -1) {
            Node = Filename;
            Extension = "";
        } else {
            Node = Filename.substring(0, lio);
            Extension = Filename.substring(lio + 1);
        }
        ADir = Drive + File.separator + Dir;
    }

    public static String splitNode(String path) {
        return Path.getNode(path);
    }

    public static String getNode(String Filename) {
        int dio;
        int sio = Filename.lastIndexOf(File.separatorChar);
        if (sio != -1) {
            Filename = Filename.substring(sio + 1);
        }
        if ((dio = Filename.lastIndexOf(46)) != -1) {
            Filename = Filename.substring(0, dio);
        }
        return Filename;
    }

    public static String splitRelativePath(String path) {
        return Path.getRelativePath(path);
    }

    public static String getRelativePath(String path) {
        int dio = path.lastIndexOf(":");
        dio = dio > 0 ? ++dio : 0;
        if (path.charAt(dio) == File.separatorChar) {
            ++dio;
        }
        return path.substring(dio);
    }

    public static String splitPath(String fullpath) {
        return Path.getPath(fullpath);
    }

    public static String getPath(String fullpath) {
        File f;
        if (fullpath.endsWith(File.separator)) {
            return Path.noSuffixed(fullpath);
        }
        int dio = fullpath.lastIndexOf(File.separator);
        int aio = fullpath.lastIndexOf(42);
        if (aio == -1 && (f = new File(fullpath)).isDirectory()) {
            return fullpath;
        }
        if (dio > 0) {
            return fullpath.substring(0, dio);
        }
        dio = fullpath.indexOf(":");
        if (dio > 0) {
            return fullpath.substring(0, dio + 1);
        }
        if (OS.isWindows()) {
            return "";
        }
        return "/";
    }

    public static String makeWinRoot(String nom) {
        if (OS.isWindows() && nom.endsWith(":")) {
            nom = nom + File.separator;
        }
        return nom;
    }

    public static String makeJavaRoot(String nom) {
        if (nom.endsWith(File.separator)) {
            if (nom == "/") {
                return "/";
            }
            return nom.substring(0, nom.length() - 1);
        }
        return nom;
    }

    public static String noSuffixed(String nom) {
        if (nom == "/") {
            return nom;
        }
        if (!nom.endsWith(File.separator)) {
            return nom;
        }
        return nom.substring(0, nom.length() - 1);
    }

    public static String suffixed(String nom) {
        if (nom.endsWith(File.separator)) {
            return nom;
        }
        return nom + File.separator;
    }

    public static String setCanonical(String origin) {
        int l = origin.length();
        char[] buf = new char[l];
        origin.getChars(0, l, buf, 0);
        for (int i = 0; i < l; ++i) {
            char c = buf[i];
            if (c != '\\' && c != '/') continue;
            buf[i] = c = File.separatorChar;
        }
        if (OS.isWindows()) {
            while (buf[l - 1] == File.separatorChar) {
                --l;
            }
        }
        return new String(buf, 0, l);
    }

    public static boolean isValidDrive(String str) {
        if (str == "/") {
            return true;
        }
        if (!OS.isWindows()) {
            return true;
        }
        if (str.charAt(1) != ':') {
            return false;
        }
        if (str.length() > 2) {
            return false;
        }
        return Character.isLetter(str.charAt(0));
    }

    public static boolean equals(String src, String dst) {
        if (OS.isWindows()) {
            return src.equalsIgnoreCase(dst);
        }
        return src.equals(dst);
    }

    public static boolean sameVersion(String src, String dst) {
        File s = new File(src);
        File d = new File(dst);
        return s.length() == d.length() && s.lastModified() == d.lastModified();
    }

    public static boolean newVersion(String src, String dst) {
        File s = new File(src);
        File d = new File(dst);
        return s.lastModified() > d.lastModified();
    }
}

