/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.PaletteGreen;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;

public class Plasma
extends Canvas {
    PlasmaThread thrPlasma;
    Image imagePlasma;
    Image imageOffScreen;
    int width = 420;
    int height = 300;
    private static final int TILEX = 1;
    private static final int TILEY = 1;
    private int[] destPixels;
    private int countPixels;
    PaletteGreen palette = new PaletteGreen();
    boolean initOk = false;
    private boolean isRunning = false;

    void debug(String s) {
        System.out.println(s);
    }

    public void plasmaInit() {
        Dimension dim = this.getSize();
        this.init(dim.width, dim.height);
    }

    public void init(int w, int h) {
        if (this.initOk) {
            return;
        }
        this.width = w / 1;
        this.height = h / 1;
        this.drawBackground();
        this.initOk = true;
    }

    private void drawBackground() {
        this.countPixels = this.width * this.height;
        this.destPixels = new int[this.countPixels];
        for (int i = 0; i < this.countPixels; ++i) {
            this.destPixels[i] = 0;
        }
        this.destPixels[0] = 128;
        this.destPixels[this.width - 1] = 128;
        this.destPixels[this.width * (this.height - 1)] = 128;
        this.destPixels[this.width * (this.height - 1) + this.width - 1] = 128;
        this.calcPoints(0, 0, this.width - 1, this.height - 1, this.destPixels[0], this.destPixels[this.width - 1], this.destPixels[this.width * (this.height - 1)], this.destPixels[this.height * this.width - 1]);
    }

    private void calcPoints(int x1, int y1, int x4, int y4, int l1, int l2, int l3, int l4) {
        int m5;
        int m4;
        int m3;
        int m2;
        int m1;
        if (x1 + 1 >= x4 && y1 + 1 >= y4) {
            return;
        }
        int w1 = x4 - x1 >> 1;
        int h1 = y4 - y1 >> 1;
        if (this.destPixels[x1 + w1 + this.width * y1] == 0) {
            this.destPixels[x1 + w1 + this.width * y1] = m1 = this.deviate(l1, l2, w1);
        } else {
            m1 = this.destPixels[x1 + w1 + this.width * y1];
        }
        if (this.destPixels[x1 + this.width * (y1 + h1)] == 0) {
            this.destPixels[x1 + this.width * (y1 + h1)] = m2 = this.deviate(l1, l3, h1);
        } else {
            m2 = this.destPixels[x1 + this.width * (y1 + h1)];
        }
        if (this.destPixels[x4 + this.width * (y1 + h1)] == 0) {
            this.destPixels[x4 + this.width * (y1 + h1)] = m3 = this.deviate(l2, l4, h1);
        } else {
            m3 = this.destPixels[x4 + this.width * (y1 + h1)];
        }
        if (this.destPixels[x1 + w1 + this.width * y4] == 0) {
            this.destPixels[x1 + w1 + this.width * y4] = m4 = this.deviate(l3, l4, w1);
        } else {
            m4 = this.destPixels[x1 + w1 + this.width * y4];
        }
        if (this.destPixels[x1 + w1 + this.width * (y1 + h1)] == 0) {
            this.destPixels[x1 + w1 + this.width * (y1 + h1)] = m5 = this.deviate(m1, m4, h1);
        } else {
            m5 = this.destPixels[x1 + w1 + this.width * y4];
        }
        this.calcPoints(x1, y1, x1 + w1, y1 + h1, l1, m1, m2, m5);
        this.calcPoints(x1 + w1, y1, x4, y1 + h1, m1, l2, m5, m3);
        this.calcPoints(x1, y1 + h1, x1 + w1, y4, m2, m5, l3, m4);
        this.calcPoints(x1 + w1, y1 + h1, x4, y4, m5, m3, m4, l4);
    }

    private int deviate(int l1, int l2, int dist) {
        int diff = Math.abs(l2 - l1);
        int avg = (l1 + l2) / 2;
        int offset = -dist * avg / 255;
        diff = (int)((double)dist * Math.random()) + offset;
        int l3 = avg + diff;
        if (l3 < 0) {
            l3 = -l3;
        } else if (l3 > 255) {
            l3 = 510 - l3;
        }
        return l3;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        try {
            this.makeScreen();
            if (this.imageOffScreen == null || this.palette == null) {
                return;
            }
            for (int i = 0; i < 1; ++i) {
                for (int j = 0; j < 1; ++j) {
                    g.drawImage(this.imageOffScreen, i * this.width, j * this.height, this);
                }
            }
            this.palette.rotate(4);
            this.palette.setColorModel();
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            System.out.println("InterruptedException: " + e);
            this.isRunning = false;
        }
    }

    void makePlasma() {
        try {
            this.imagePlasma = this.createImage(new MemoryImageSource(this.width, this.height, this.palette.getColorModel(), this.destPixels, 0, this.width));
            MediaTracker o = new MediaTracker(this);
            try {
                o.addImage(this.imagePlasma, 0);
                o.waitForAll();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.out.println(e);
            this.isRunning = false;
        }
    }

    void makeScreen() {
        try {
            this.imageOffScreen = this.createImage(this.width, this.height);
            Graphics g = this.imageOffScreen.getGraphics();
            this.makePlasma();
            g.drawImage(this.imagePlasma, 0, 0, this);
        }
        catch (Exception e) {
            System.out.println(e);
            this.isRunning = false;
        }
    }

    public void start() {
        if (this.thrPlasma == null) {
            this.isRunning = true;
            this.thrPlasma = new PlasmaThread();
            this.thrPlasma.start();
        }
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
        if (this.thrPlasma != null) {
            this.thrPlasma.interrupt();
            this.thrPlasma = null;
        }
    }

    class PlasmaThread
    extends Thread {
        PlasmaThread() {
        }

        public void run() {
            Plasma.this.plasmaInit();
            Plasma.this.isRunning = true;
            while (Plasma.this.isRunning) {
                Plasma.this.repaint();
            }
        }
    }
}

