/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Orient;
import ae.Plane;
import ae.Texture;
import ae.Vertex;
import ae.Virtual3d;
import java.awt.Color;

public class Polygon3d {
    int[] spx = new int[16];
    int[] spy = new int[16];
    Vertex[] p = new Vertex[16];
    Vertex normal = new Vertex();
    Vertex middle = new Vertex();
    double lightprop;
    int vertcount;
    Color col;
    double minz;
    double maxz;
    Texture texture;

    public Polygon3d() {
    }

    public Polygon3d(Polygon3d poly) {
        for (int i = 0; i < this.spx.length; ++i) {
            this.spx[i] = poly.spx[i];
            this.spy[i] = poly.spy[i];
            if (poly.p[i] == null) continue;
            this.p[i] = new Vertex(poly.p[i]);
        }
        this.middle = new Vertex(poly.middle);
        this.normal = new Vertex(poly.normal);
        this.lightprop = poly.lightprop;
        this.vertcount = poly.vertcount;
        this.col = new Color(poly.col.getRed(), poly.col.getGreen(), poly.col.getBlue());
        this.minz = poly.minz;
        this.maxz = poly.maxz;
        this.texture = poly.texture;
    }

    public boolean clipback(Plane clip) {
        boolean oldin;
        Vertex temp = new Vertex();
        Polygon3d newv = new Polygon3d(this);
        boolean clipback = false;
        int i = 0;
        int newi = 0;
        double olddist = this.p[i].dotproduct(clip.normal);
        boolean bl = oldin = olddist >= clip.dist;
        while (i < this.vertcount) {
            double newdist;
            boolean newin;
            if (oldin) {
                newv.p[newi++] = new Vertex(this.p[i % this.vertcount]);
                clipback = true;
            }
            boolean bl2 = newin = (newdist = this.p[++i % this.vertcount].dotproduct(clip.normal)) >= clip.dist;
            if (newin != oldin) {
                double r = (clip.dist - olddist) / (newdist - olddist);
                temp.x = this.p[i - 1].x + r * (this.p[i % this.vertcount].x - this.p[i - 1].x);
                temp.y = this.p[i - 1].y + r * (this.p[i % this.vertcount].y - this.p[i - 1].y);
                temp.z = this.p[i - 1].z + r * (this.p[i % this.vertcount].z - this.p[i - 1].z);
                temp.u = this.p[i - 1].u + (double)((int)(r * (this.p[i % this.vertcount].u - this.p[i - 1].u)));
                temp.v = this.p[i - 1].v + (double)((int)(r * (this.p[i % this.vertcount].v - this.p[i - 1].v)));
                newv.p[newi++] = new Vertex(temp);
                clipback = true;
            }
            oldin = newin;
            olddist = newdist;
        }
        newv.vertcount = newi;
        for (i = 0; i < this.spx.length; ++i) {
            this.spx[i] = newv.spx[i];
            this.spy[i] = newv.spy[i];
            if (i >= newv.vertcount) continue;
            this.p[i] = new Vertex(newv.p[i]);
        }
        this.normal = newv.normal;
        this.lightprop = newv.lightprop;
        this.vertcount = newv.vertcount;
        this.col = new Color(newv.col.getRed(), newv.col.getGreen(), newv.col.getBlue());
        double mx = 0.0;
        double my = 0.0;
        for (i = 0; i < newi; ++i) {
            if (newv.p[i].z < newv.minz) {
                newv.minz = newv.p[i].z;
            }
            if (newv.p[i].z > newv.maxz) {
                newv.maxz = newv.p[i].z;
            }
            mx += newv.p[i].x;
            my += newv.p[i].y;
        }
        newv.middle = new Vertex(mx / (double)newv.vertcount, my / (double)newv.vertcount, (this.minz + this.maxz) / 2.0);
        this.minz = newv.minz;
        this.maxz = newv.maxz;
        this.middle = newv.middle;
        return clipback;
    }

    public void rotate(int a, int b, int c) {
        this.rotate(new Orient(a, b, c));
    }

    public void rotate(Orient o1) {
        for (int j = 0; j < this.vertcount; ++j) {
            this.p[j].rotate(o1);
        }
        this.normal.rotate(o1);
    }

    public void translate(Vertex disp1) {
        for (int j = 0; j < this.vertcount; ++j) {
            this.p[j].x += disp1.x;
            this.p[j].y += disp1.y;
            this.p[j].z += disp1.z;
        }
    }

    public void paint(Virtual3d g3d) {
        g3d.fillPoly(this.p, this.vertcount, this.normal, this.texture);
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.vertcount; ++i) {
            s = s + this.p[i];
        }
        return s;
    }
}

