/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.PaletteShaded;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class Raw {
    short width;
    short height;
    byte bottomToTop;
    byte compression;
    byte colorModel;
    byte palette;
    byte transparent;
    byte version = 0;
    int[] code;
    static final byte BTRUE = 1;
    static final byte BFALSE = 0;
    static final byte UNCOMPRESSED = 0;
    static final byte RLE = 1;
    static final byte DIRECT = 0;
    static final byte INDEXED = 1;

    public Raw() {
        this.bottomToTop = 0;
        this.palette = 0;
        this.compression = 0;
        this.colorModel = 1;
        this.transparent = 0;
    }

    public Raw(int[] code, int width, int height) {
        this();
        this.width = (short)width;
        this.height = (short)height;
        this.code = code;
    }

    public Raw(byte[] data) {
        this.width = (short)(Raw.unsigned(data[0]) * 256 + Raw.unsigned(data[1]));
        this.height = (short)(Raw.unsigned(data[2]) * 256 + Raw.unsigned(data[3]));
        this.bottomToTop = data[4];
        this.compression = data[5];
        this.colorModel = data[6];
        this.palette = data[7];
        this.transparent = data[8];
        this.version = data[9];
        int size = this.width * this.height;
        this.code = new int[size];
        int i = 0;
        int j = 10;
        while (i < size) {
            int c;
            if (this.colorModel == 0) {
                c = Raw.unsigned(data[j]) << 24 | (Raw.unsigned(data[j + 1]) << 16) + (Raw.unsigned(data[j + 2]) << 8) + Raw.unsigned(data[j + 3]);
                j += 4;
            } else {
                c = Raw.unsigned(data[j++]);
            }
            this.code[i++] = c;
        }
    }

    public int getPalette() {
        return Raw.unsigned(this.palette);
    }

    public int getModel() {
        return Raw.unsigned(this.colorModel);
    }

    public int getTransparent() {
        return Raw.unsigned(this.transparent);
    }

    public int getCompression() {
        return Raw.unsigned(this.compression);
    }

    public boolean isInversed() {
        return this.bottomToTop == 1;
    }

    public boolean isIndexed() {
        return this.colorModel == 1;
    }

    public int[] UnRLE() {
        int[] buffer = this.code;
        return buffer;
    }

    public int[] getPixels() {
        switch (this.compression) {
            case 1: {
                return this.UnRLE();
            }
        }
        return this.code;
    }

    public byte[] getBytes() {
        int codesize = this.width * this.height;
        if (this.colorModel == 0) {
            codesize *= 4;
        }
        System.out.println("getBytes enter - code size " + codesize);
        byte[] buffer = new byte[codesize + 10];
        try {
            buffer[0] = Raw.signed(this.width / 256);
            buffer[1] = Raw.signed(this.width - buffer[1] * 256);
            buffer[2] = Raw.signed(this.height / 256);
            buffer[3] = Raw.signed(this.height - buffer[3] * 256);
            buffer[4] = this.bottomToTop;
            buffer[5] = this.compression;
            buffer[6] = this.colorModel;
            buffer[7] = this.palette;
            buffer[8] = this.transparent;
            buffer[9] = this.version;
            int[] intbuffer = this.bottomToTop == 1 ? Raw.invert(this.code, this.width, this.height) : this.code;
            if (this.colorModel == 1) {
                for (int i = 0; i < codesize; ++i) {
                    buffer[10 + i] = Raw.signed(intbuffer[i]);
                }
            } else {
                int j = 10;
                for (int i = 0; i < codesize; ++i) {
                    int color = intbuffer[i];
                    buffer[j++] = Raw.signed(color >> 24 & 0xFF);
                    buffer[j++] = Raw.signed(color >> 16 & 0xFF);
                    buffer[j++] = Raw.signed(color >> 8 & 0xFF);
                    buffer[j++] = Raw.signed(color & 0xFF);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            a.printStackTrace();
        }
        return buffer;
    }

    static int unsigned(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    static byte signed(int i) {
        return i < 128 ? (byte)i : (byte)(i - 256);
    }

    static int[] invert(int[] data, int w, int h) {
        int[] dest = new int[w * h];
        int h2 = h - 1;
        for (int j = 0; j < h; ++j) {
            int sptr = j * w + 6;
            int dptr = (h2 - j) * w;
            for (int i = 0; i < w; ++i) {
                dest[dptr + i] = data[sptr + i];
            }
        }
        return dest;
    }

    public Image getImage() {
        MemoryImageSource mis;
        if (this.colorModel == 1) {
            ColorModel cm = new PaletteShaded().getColorModel();
            mis = new MemoryImageSource((int)this.width, (int)this.height, cm, this.getPixels(), 0, (int)this.width);
        } else {
            mis = new MemoryImageSource(this.width, this.height, this.getPixels(), 0, this.width);
        }
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public static Image getImage(byte[] rawImage) {
        int size = rawImage.length;
        byte[] code = new byte[size];
        System.arraycopy(rawImage, 10, code, 0, size - 10);
        int width = rawImage[0] + rawImage[1] * 256;
        int height = rawImage[2] + rawImage[3] * 256;
        PaletteShaded pal = new PaletteShaded();
        pal.setTransparent(Raw.unsigned(rawImage[8]));
        ColorModel cm = pal.getColorModel();
        MemoryImageSource mis = new MemoryImageSource(width, height, cm, code, 0, width);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public int size() {
        return this.code.length + 10;
    }

    void load(String path) {
        try {
            DataInputStream p = new DataInputStream(new FileInputStream(path));
            this.width = p.readShort();
            this.height = p.readShort();
            this.bottomToTop = p.readByte();
            this.compression = p.readByte();
            this.colorModel = p.readByte();
            this.palette = p.readByte();
            this.transparent = p.readByte();
            this.version = p.readByte();
            int size = this.width * this.height;
            this.code = new int[size];
            for (int i = 0; i < size; ++i) {
                this.code[i] = this.colorModel == 0 ? p.readInt() : Raw.unsigned(p.readByte());
            }
            if (this.bottomToTop == 1) {
                this.code = Raw.invert(this.code, this.width, this.height);
            }
            p.close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

