/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.PalettePanel;
import ae.Raw;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class RawEdit
extends Raw {
    public RawEdit() {
    }

    public RawEdit(int[] code, int width, int height) {
        super(code, width, height);
    }

    public RawEdit(Image image) {
        this();
        this.capture(image);
    }

    public void setInversed(boolean d) {
        this.bottomToTop = d ? (byte)1 : 0;
    }

    public void setIndexed(boolean m) {
        this.colorModel = m ? (byte)1 : 0;
    }

    public void setCompression(int compressMode) {
        if (compressMode != 1) {
            compressMode = 0;
        }
        this.compression = RawEdit.signed(compressMode);
    }

    public void setPalette(int n) {
        this.palette = RawEdit.signed(n);
    }

    public void setTransparent(int t) {
        this.transparent = RawEdit.signed(t);
    }

    public static int[] RLECompress(int[] code) {
        int[] buffer = new int[code.length];
        if (buffer.length > code.length) {
            return null;
        }
        return buffer;
    }

    public int RLE(int[] rawImage) {
        int[] buffer = RawEdit.RLECompress(rawImage);
        if (buffer == null) {
            this.code = rawImage;
            this.setCompression(0);
            return 0;
        }
        this.code = buffer;
        this.setCompression(1);
        return this.code.length;
    }

    Raw getRaw() {
        return new Raw(this.code, this.width, this.height);
    }

    public int[] getPixels() {
        switch (this.compression) {
            case 1: {
                return this.UnRLE();
            }
        }
        return this.code;
    }

    void capture(Image image) {
        this.capture(image, new PalettePanel());
    }

    void capture(Image image, PalettePanel panel) {
        this.width = (short)image.getWidth(null);
        this.height = (short)image.getHeight(null);
        this.code = new int[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, (int)this.width, (int)this.height, this.code, 0, (int)this.width);
        pg.setColorModel(panel.getColorModel());
        try {
            pg.grabPixels();
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("Icon capture aborted or errored");
            return;
        }
        int counter = 0;
        if (this.colorModel == 1) {
            for (int i = 0; i < this.code.length; ++i) {
                int k = this.code[i];
                int l = RawEdit.unsigned(this.transparent);
                int or = k >> 16 & 0xFF;
                int og = k >> 8 & 0xFF;
                int ob = k & 0xFF;
                int oprox = 765;
                for (int j = 0; j < 256; ++j) {
                    int rgb = panel.getRGB(j);
                    if (k == rgb) {
                        l = j;
                        ++counter;
                        continue;
                    }
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    int nprox = Math.abs(r - or) + Math.abs(g - og) + Math.abs(b - ob);
                    if (nprox >= oprox) continue;
                    oprox = nprox;
                    l = j;
                }
                this.code[i] = l;
            }
        }
    }

    boolean save(String path) {
        try {
            DataOutputStream p = new DataOutputStream(new FileOutputStream(path));
            byte[] buffer = this.getBytes();
            int size = buffer.length;
            for (int i = 0; i < size; ++i) {
                p.writeByte(buffer[i]);
            }
            p.flush();
            p.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String toString() {
        String codehead;
        String c;
        String s = "";
        s = s + "Width: " + this.width + "\n";
        s = s + "Height: " + this.height + "\n";
        String direction = this.bottomToTop == 1 ? "Bottom to top" : "Top to bottom";
        s = s + "Direction: " + direction + "\n";
        switch (this.compression) {
            case 0: {
                c = "None";
                break;
            }
            case 1: {
                c = "Run-Length Encoding";
                break;
            }
            default: {
                c = "unknow";
            }
        }
        s = s + "Compression: " + c + "\n";
        if (this.colorModel == 1) {
            c = "Indexed";
            codehead = "(decimal)";
        } else {
            c = "Direct Alpha-RGB";
            codehead = "(hexadecimal)";
        }
        s = s + "Color model: " + c + "\n";
        s = s + "Palette #" + this.palette + "\n";
        s = s + "Version: " + this.version + "\n";
        s = s + "Code " + codehead + ":" + "\n";
        int j = 0;
        for (int i = 0; i < this.code.length; ++i) {
            s = this.colorModel == 1 ? s + this.code[i] + " " : s + Integer.toHexString(this.code[i]) + " ";
            if (++j != 10) continue;
            j = 0;
            s = s + "\n";
        }
        return s;
    }
}

