/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DDialog;
import ae.ImageViewer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class ScaleDialog
extends DDialog
implements ActionListener,
AdjustmentListener {
    Panel panelScroll;
    ImageViewer canvas;
    Scrollbar hBar;
    Scrollbar vBar;
    Panel viewport;
    Panel panelControl;
    Button buttonOk;
    Button buttonCancel;
    Label labelWidth;
    Label labelHeight;
    int iWidth = 0;
    int iHeight = 0;
    Image image = null;
    Image model = null;
    boolean accept = false;

    public ScaleDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.setSize(this.insets().left + this.insets().right + 450, this.insets().top + this.insets().bottom + 320);
        this.setFont(new Font("Dialog", 0, 14));
        this.panelScroll = new Panel(new BorderLayout());
        this.add((Component)this.panelScroll, "Center");
        this.vBar = new Scrollbar(1, 0, 1, 1, 97);
        this.vBar.addAdjustmentListener(this);
        this.panelScroll.add((Component)this.vBar, "East");
        this.hBar = new Scrollbar(0, 0, 1, 1, 129);
        this.hBar.addAdjustmentListener(this);
        this.panelScroll.add((Component)this.hBar, "South");
        this.viewport = new Panel(new GridLayout());
        this.viewport.setBackground(Color.white);
        this.panelScroll.add((Component)this.viewport, "Center");
        this.canvas = new ImageViewer();
        this.canvas.setBackground(Color.white);
        this.viewport.add(this.canvas);
        this.panelControl = new Panel();
        this.panelControl.setLayout(null);
        this.panelControl.setBounds(this.insets().left + 334, this.insets().top + 0, 116, 320);
        this.add((Component)this.panelControl, "East");
        this.buttonOk = new Button();
        this.buttonOk.setActionCommand("button");
        this.buttonOk.setLabel("OK");
        this.buttonOk.setBounds(8, 204, 100, 30);
        this.buttonOk.addActionListener(this);
        this.panelControl.add(this.buttonOk);
        this.buttonCancel = new Button();
        this.buttonCancel.setActionCommand("button");
        this.buttonCancel.setLabel("Cancel");
        this.buttonCancel.setBounds(8, 264, 100, 30);
        this.buttonCancel.addActionListener(this);
        this.panelControl.add(this.buttonCancel);
        this.labelWidth = new Label();
        this.labelWidth.setBounds(16, 36, 96, 24);
        this.panelControl.add(this.labelWidth);
        this.labelHeight = new Label();
        this.labelHeight.setBounds(16, 68, 96, 24);
        this.panelControl.add(this.labelHeight);
        this.setTitle("Scale");
    }

    public ScaleDialog(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public ScaleDialog(Frame parent) {
        this(parent, true);
    }

    void setWidth() {
        this.labelWidth.setText("Width " + this.iWidth);
    }

    void setHeight() {
        this.labelHeight.setText("Height " + this.iHeight);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.iWidth = this.image.getWidth(null);
        this.iHeight = this.image.getHeight(null);
        this.setWidth();
        this.setHeight();
        this.hBar.setValue(this.iWidth);
        this.vBar.setValue(this.iHeight);
        this.canvas.setImage(this.image);
        this.canvas.repaint();
    }

    public void setImage(Image image) {
        this.image = image;
        this.model = image;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Image getImage() {
        this.image = this.model.getScaledInstance(this.iWidth, this.iHeight, 1);
        return this.image;
    }

    public void resize() {
        this.getImage();
        this.repaint();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.buttonCancel) {
            this.image = this.model;
            this.accept = false;
            this.setVisible(false);
        } else if (object == this.buttonOk) {
            this.accept = true;
            this.setVisible(false);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        Object object = event.getSource();
        if (object == this.hBar) {
            this.iWidth = this.hBar.getValue();
            this.resize();
        } else if (object == this.vBar) {
            this.iHeight = this.vBar.getValue();
            this.resize();
        } else {
            return;
        }
    }
}

