/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.SliderTick;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class Slider
extends Canvas {
    public static final int TICK_NONE = 0;
    public static final int TICK_LEFT = 1;
    public static final int TICK_RIGHT = 2;
    public static final int TICK_BOTTOM = 1;
    public static final int TICK_TOP = 2;
    public static final int TICK_BOTH = 3;
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LOWERED = 1;
    public static final int BORDER_RAISED = 2;
    Color background = Color.lightGray;
    protected int width;
    protected int height;
    protected boolean forceCallDoReshape = false;
    protected int style = 0;
    protected int freq = 1;
    protected int min = 0;
    protected int max = 255;
    protected int prevPos = 0;
    protected int curPos = 0;
    protected ActionListener actionListener = null;
    protected String actionCommand = "Slider Moved";
    protected transient SliderTick[] tick = null;
    protected static final int BORDER_X = 12;
    protected static final int BORDER_Y = 8;
    public int borderStyle = 0;
    protected int tickWidth = 1;
    protected int tickStep = 5;
    String slidername;
    boolean notified = false;

    protected Slider() {
    }

    public void setTickStyle(int style) {
        this.style = style;
        this.forceCallDoReshape = true;
    }

    public int getTickStyle() {
        return this.style;
    }

    public void setBorderStyle(int s) {
        switch (s) {
            case 0: 
            case 1: 
            case 2: {
                this.borderStyle = s;
                break;
            }
        }
    }

    public void setMinValue(int min) {
        if (min < 0) {
            min = 0;
        }
        this.min = min;
        this.forceCallDoReshape = true;
        this.repaint();
    }

    public int getMinValue() {
        return this.min;
    }

    public void setMaxValue(int max) {
        if (max < 0) {
            max = 0;
        }
        this.max = max;
        this.forceCallDoReshape = true;
        this.repaint();
    }

    public int getMaxValue() {
        return this.max;
    }

    public void setTickFreq(int freq) {
        if (this.freq != freq) {
            if (freq > this.max) {
                freq = this.max;
            }
            if (freq < this.min) {
                freq = this.min;
            }
            int pos = this.curPos * this.freq + this.min;
            this.freq = freq;
            this.doMove((pos - this.min) / this.freq, false);
            this.forceCallDoReshape = true;
            this.repaint();
        }
    }

    public int getTickFreq() {
        return this.freq;
    }

    public void setValue(int pos) {
        if (pos < this.getMinValue()) {
            pos = this.getMinValue();
        } else if (pos > this.getMaxValue()) {
            pos = this.getMaxValue();
        }
        this.doMove((pos - this.min) / this.freq, false);
        this.forceCallDoReshape = true;
        this.repaint();
    }

    public int getValue() {
        return this.curPos * this.freq + this.min;
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected abstract void do_reshape(int var1, int var2);

    protected void doMove(int pos, boolean forcePost) {
        if (this.tick == null) {
            this.prevPos = this.curPos = pos;
            return;
        }
        if (pos >= this.tick.length) {
            pos = this.tick.length - 1;
        }
        if (pos != this.curPos || forcePost) {
            this.prevPos = this.curPos;
            this.curPos = pos;
            Graphics g = this.getGraphics();
            if (g != null) {
                this.paint(g);
                g.dispose();
            }
            g = null;
            this.sourceActionEvent();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        boolean callDoReshape = false;
        Dimension currentSize = this.getSize();
        if (this.width != currentSize.width) {
            this.width = currentSize.width;
            callDoReshape = true;
        }
        if (this.height != currentSize.height) {
            this.height = currentSize.height;
            callDoReshape = true;
        }
        if (this.forceCallDoReshape || callDoReshape) {
            this.do_reshape(this.width, this.height);
            this.forceCallDoReshape = false;
        }
    }

    protected void moveThumb(int i, boolean forcePost) {
        if (this.tick.length > 1) {
            int dist = this.tick[1].x - this.tick[0].x;
            if (dist == 0) {
                return;
            }
            int newPos = (i - this.tick[0].x) / dist;
            if (newPos < 0) {
                newPos = 0;
            }
            if ((i - this.tick[0].x) % dist > dist / 2) {
                ++newPos;
            }
            this.doMove(newPos, forcePost);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void setBackground(Color b) {
        this.background = b;
    }

    public Color getBackground() {
        return this.background;
    }

    public void addNotify() {
        super.addNotify();
        this.notified = true;
    }
}

