/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DirButton;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SpinButtonPanel
extends Panel
implements ActionListener {
    protected double widthHeightRatio = 1.25;
    protected DirButton incButton = new DirButton(2);
    protected DirButton decButton = new DirButton(3);
    protected ActionListener actionListener = null;

    public SpinButtonPanel() {
        this.incButton.setBevelHeight(1);
        this.incButton.setShowFocus(false);
        this.decButton.setBevelHeight(1);
        this.decButton.setShowFocus(false);
        this.add(this.incButton);
        this.add(this.decButton);
        this.setDelay(250);
        this.setNotifyWhilePressed(true);
        this.incButton.addActionListener(this);
        this.decButton.addActionListener(this);
    }

    public void setNotifyWhilePressed(boolean f) {
        this.incButton.setNotifyWhilePressed(f);
        this.decButton.setNotifyWhilePressed(f);
    }

    public boolean isNotifyWhilePressed() {
        return this.incButton.isNotifyWhilePressed();
    }

    public void setDelay(int d) {
        this.incButton.setNotifyDelay(d);
        this.decButton.setNotifyDelay(d);
    }

    public int getDelay() {
        return this.incButton.getNotifyDelay();
    }

    public void setLayout(LayoutManager l) {
    }

    public synchronized void setEnabled(boolean flag) {
        if (this.isEnabled() != flag) {
            super.setEnabled(flag);
            this.incButton.setEnabled(flag);
            this.decButton.setEnabled(flag);
        }
    }

    public synchronized void setUpButtonEnabled(boolean flag) {
        this.incButton.setEnabled(flag);
    }

    public boolean isUpButtonEnabled() {
        return this.incButton.isEnabled();
    }

    public synchronized void setDownButtonEnabled(boolean flag) {
        this.decButton.setEnabled(flag);
    }

    public boolean isDownButtonEnabled() {
        return this.decButton.isEnabled();
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void setBounds(int x, int y, int width, int height) {
        int halfHeight = height / 2;
        int calcWidth = (int)((double)halfHeight * this.widthHeightRatio);
        this.incButton.setBounds(0, 0, calcWidth, halfHeight);
        this.decButton.setBounds(0, halfHeight, calcWidth, halfHeight);
        super.setBounds(x, y, width, height);
    }

    public Dimension getPreferredSize() {
        int height = this.getSize().height;
        return new Dimension((int)((double)(height / 2) * this.widthHeightRatio), height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.incButton) {
            this.sourceActionEvent("Increment");
        } else if (source == this.decButton) {
            this.sourceActionEvent("Decrement");
        }
    }

    protected void sourceActionEvent(String actionCommand) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, actionCommand));
        }
    }
}

