/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class Spinner
extends Component {
    protected int value;
    protected int minValue = Integer.MIN_VALUE;
    protected int maxValue = Integer.MAX_VALUE;
    protected ActionListener actionListener;
    protected Polygon upArrow = new Polygon();
    protected Polygon dnArrow = new Polygon();
    protected Polygon upPressedArrow = new Polygon();
    protected Polygon dnPressedArrow = new Polygon();
    protected boolean upPressed;
    protected boolean dnPressed;
    protected boolean rollsOver = false;
    protected long oldMouseClickTime;
    private String actionCommand = "which?";
    private static long DELAY_PERIOD = 150L;
    public boolean Changed = false;

    public Spinner() {
        this.enableEvents(16L);
    }

    public Spinner(int v) {
        this();
        this.value = v;
    }

    public Spinner(int v, int mi, int mx) {
        this();
        this.value = v;
        this.minValue = mi;
        this.maxValue = mx;
    }

    public void addNotify() {
        super.addNotify();
        this.setSize(this.adjustSize(this.getGraphics()));
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.getSize().width != 0 && this.getSize().height != 0) {
            return this.getSize();
        }
        return this.adjustSize(this.getGraphics());
    }

    public synchronized void setValue(int newValue) {
        this.value = newValue;
        this.repaint();
    }

    public synchronized void setLimits(int minimum, int maximum) {
        this.minValue = minimum;
        this.maxValue = maximum;
    }

    public int getValue() {
        return this.value;
    }

    public synchronized void setMinValue(int value) {
        this.minValue = value;
        this.setValue(this.minValue);
    }

    public int getMinValue() {
        return this.minValue;
    }

    public synchronized void setMaxValue(int value) {
        this.maxValue = value;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setRollsOver(boolean state) {
        this.rollsOver = state;
    }

    public boolean getRollsOver() {
        return this.rollsOver;
    }

    public void setActionCommand(String newActionCommand) {
        this.actionCommand = newActionCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, al);
    }

    protected Dimension adjustSize(Graphics g) {
        int h = 24;
        int w = 48;
        int m = 12;
        this.upArrow.addPoint(32, 10);
        this.upArrow.addPoint(46, 10);
        this.upArrow.addPoint(39, 3);
        this.dnArrow.addPoint(39, 19);
        this.dnArrow.addPoint(33, 13);
        this.dnArrow.addPoint(45, 13);
        this.upPressedArrow.addPoint(39, 5);
        this.upPressedArrow.addPoint(34, 11);
        this.upPressedArrow.addPoint(44, 11);
        this.dnPressedArrow.addPoint(39, 20);
        this.dnPressedArrow.addPoint(34, 14);
        this.dnPressedArrow.addPoint(44, 14);
        return new Dimension(48, 24);
    }

    public void paint(Graphics g) {
        Dimension mySize = this.getSize();
        int bw = mySize.width;
        int bh = mySize.height;
        Color borderlight = this.getBackground().brighter();
        Color borderdark = this.getBackground().darker();
        g.setColor(borderlight);
        g.drawLine(0, 0, bw - 1, 0);
        g.drawLine(0, 0, 0, bh);
        g.setColor(borderdark);
        g.drawLine(2, bh - 2, bw, bh - 2);
        g.drawLine(1, bh - 1, bw, bh - 1);
        g.drawLine(bw, 0, bw, bh);
        g.drawLine(bw - 1, 1, bw - 1, bh);
        Rectangle rect = new Rectangle(5, 4, bw - 23, bh - 9);
        int rx = rect.x;
        int ry = rect.y;
        int rw = rect.width;
        int rh = rect.height;
        int rr = rx + rw - 1;
        int rb = ry + rh - 1;
        if (this.isEnabled()) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.gray);
        }
        g.fillRect(rx - 1, ry - 1, rw + 2, rh + 2);
        if (!this.upPressed) {
            g.fillPolygon(this.upArrow);
        } else {
            g.fillPolygon(this.upPressedArrow);
        }
        if (!this.dnPressed) {
            g.fillPolygon(this.dnArrow);
        } else {
            g.fillPolygon(this.dnPressedArrow);
        }
        g.setColor(borderlight);
        g.drawLine(rx, rb + 1, rr + 1, rb + 1);
        g.drawLine(rr + 1, ry + 1, rr + 1, rb + 1);
        g.setFont(new Font("Dialog", 1, 14));
        FontMetrics fm = g.getFontMetrics();
        int textwidth = fm.stringWidth("" + this.value);
        int y = ry + fm.getHeight() / 2 + 4;
        int x = rx + (rw - textwidth) / 2 + 1;
        g.setColor(Color.green.darker());
        g.drawString("" + this.value, x, y);
    }

    private void notifyListeners() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    public void increment() {
        if (this.value < this.maxValue) {
            ++this.value;
            this.notifyListeners();
        } else if (this.rollsOver) {
            this.value = this.minValue;
            this.notifyListeners();
        }
    }

    public void decrement() {
        if (this.value > this.minValue) {
            --this.value;
            this.notifyListeners();
        } else if (this.rollsOver) {
            this.value = this.maxValue;
            this.notifyListeners();
        }
    }

    public void spin() {
        new SpinThread().start();
    }

    public void processMouseEvent(MouseEvent evt) {
        if (this.isEnabled()) {
            switch (evt.getID()) {
                case 501: {
                    long newMouseClickTime = System.currentTimeMillis();
                    if (newMouseClickTime - this.oldMouseClickTime > DELAY_PERIOD) {
                        if (this.upArrow.contains(new Point(evt.getX(), evt.getY()))) {
                            this.upPressed = true;
                            this.spin();
                        } else if (this.dnArrow.contains(new Point(evt.getX(), evt.getY()))) {
                            this.dnPressed = true;
                            this.spin();
                        }
                    }
                    this.oldMouseClickTime = newMouseClickTime;
                    break;
                }
                case 502: {
                    if (this.upPressed) {
                        this.upPressed = false;
                    } else if (this.dnPressed) {
                        this.dnPressed = false;
                    }
                    this.repaint();
                }
            }
        }
        super.processMouseEvent(evt);
    }

    public class SpinThread
    extends Thread {
        public SpinThread() {
            this.setPriority(1);
        }

        public void run() {
            try {
                if (Spinner.this.upPressed) {
                    Spinner.this.increment();
                }
                if (Spinner.this.dnPressed) {
                    Spinner.this.decrement();
                }
                Spinner.this.repaint();
                Thread.sleep(1250L);
                while (Spinner.this.upPressed || Spinner.this.dnPressed) {
                    if (Spinner.this.upPressed) {
                        Spinner.this.increment();
                    }
                    if (Spinner.this.dnPressed) {
                        Spinner.this.decrement();
                    }
                    Spinner.this.repaint();
                    Thread.sleep(400L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

