/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class SprFile {
    String name = null;
    int SPRMAX;
    int[] SPVECTOR;
    byte[] SPCODE;
    static String[] MESSAGE = new String[]{"", "File no found", "Enable to save"};

    public SprFile() {
    }

    public SprFile(String n) {
        this.name = n;
    }

    public int GETSPADR(int no) {
        if (no >= this.SPVECTOR.length) {
            no = 1;
        }
        try {
            return this.SPVECTOR[no];
        }
        catch (NullPointerException n) {
            System.out.println(no + " out of bound, SPVECTOR (" + this.SPVECTOR.length + ")");
            return 0;
        }
    }

    int getCode(int n) {
        int adr = this.GETSPADR(n);
        return this.SPCODE[adr + 4];
    }

    int getMax() {
        return this.SPVECTOR[0];
    }

    String changExt(String name, String ext) {
        int i = name.lastIndexOf(".");
        if (i > 0) {
            return name.substring(0, i) + ext;
        }
        return name + ext;
    }

    static void dispError(String name, int mess) {
        if (mess == 0) {
            System.out.println(name);
        } else {
            System.out.println(MESSAGE[mess] + " " + name);
            System.exit(0);
        }
    }

    static int intConvert(int origin) {
        int un = origin >> 24;
        int deux = origin >> 16 & 0xFF;
        int trois = origin >> 8 & 0xFF;
        int quatre = origin & 0xFF;
        return (quatre << 24) + (trois << 16) + (deux << 8) + un;
    }

    int load(String path) {
        int toload = 0;
        int loaded = 0;
        try {
            DataInputStream fiS = new DataInputStream(new FileInputStream(path));
            int available = fiS.available();
            System.out.println("available= " + available);
            try {
                toload = SprFile.intConvert(fiS.readInt());
                System.out.println("size to load= " + toload);
                this.SPVECTOR = new int[toload + 2];
                this.SPVECTOR[0] = toload;
            }
            catch (IOException e) {
                // empty catch block
            }
            for (int i = 0; i <= toload; ++i) {
                try {
                    this.SPVECTOR[i + 1] = SprFile.intConvert(fiS.readInt());
                    System.out.println(this.SPVECTOR[i + 1]);
                    ++loaded;
                    continue;
                }
                catch (IOException ef) {
                    SprFile.dispError("Error in vector", 0);
                }
            }
            available = fiS.available();
            this.SPCODE = new byte[available];
            int notAtEnd = 1;
            while (notAtEnd > 0) {
                notAtEnd = fiS.read(this.SPCODE);
            }
            fiS.close();
        }
        catch (IOException e) {
            SprFile.dispError(path, 1);
        }
        System.out.println("loaded " + loaded);
        System.out.println("SPVECTOR len (6x4=24)" + this.SPVECTOR.length);
        System.out.println("SPCODE len " + this.SPCODE.length);
        this.SPRMAX = loaded;
        return loaded;
    }

    int load() {
        return this.load(this.name);
    }

    void debug(String s) {
        System.out.println(s);
    }

    public Dimension spSize(int ns) {
        int p = this.GETSPADR(ns);
        int mode = this.getCode(ns);
        int h = this.SPCODE[p] + this.SPCODE[p + 1] * 256;
        int w = this.SPCODE[p + 2] + this.SPCODE[p + 3] * 256;
        switch (mode) {
            case 0: 
            case 2: 
            case 3: 
            case 6: {
                w *= 8;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
        }
        return new Dimension(w, h);
    }
}

