/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.ColorList;
import ae.StyleList;
import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;

public class Style {
    public String sBackground;
    public String sForeground;
    public String sFont;
    public String sStyle;
    public String sSize;
    public Font font;
    public Color background;
    public Color foreground;
    ColorList colorlist = new ColorList();

    public Style() {
    }

    public Style(String bg, String fg, String f, int st, int si) {
        this.set(bg, fg, f, st, si);
        this.init();
    }

    public void set(String bg, String fg, String f, int st, int si) {
        this.sBackground = bg;
        this.sForeground = fg;
        this.sFont = f;
        this.sStyle = new Integer(st).toString();
        this.sSize = new Integer(si).toString();
    }

    public void init() {
        this.makeFont();
        this.makeColors();
    }

    public void makeFont() {
        this.font = new Font(this.sFont, StyleList.getStyle(this.sStyle), new Integer(this.sSize));
    }

    public void makeColors() {
        this.makeColors(true);
    }

    public void makeColors(boolean diff) {
        this.background = ColorList.getColor(this.sBackground);
        this.foreground = ColorList.getColor(this.sForeground);
        if (diff && this.background.equals(this.foreground)) {
            System.out.println("Style error bg = fg");
            this.background = Color.lightGray;
            this.foreground = Color.black;
        }
    }

    public void tokenize(String source) {
        StringTokenizer st = new StringTokenizer(source, ",");
        try {
            this.sBackground = st.nextToken();
            this.sForeground = st.nextToken();
            this.sFont = st.nextToken();
            this.sStyle = st.nextToken();
            this.sSize = st.nextToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyInto(Style clone) {
        clone.sBackground = this.sBackground;
        clone.sForeground = this.sForeground;
        clone.sFont = this.sFont;
        clone.sStyle = this.sStyle;
        clone.sSize = this.sSize;
    }

    public String getString() {
        return this.sBackground + "," + this.sForeground + "," + this.sFont + "," + this.sStyle + "," + this.sSize;
    }

    public String toString() {
        return this.font.toString() + "," + this.background.toString() + "," + this.foreground.toString() + ",";
    }
}

