/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.ColorList;
import ae.DLabel;
import ae.Preferences;
import ae.Style;
import ae.StyleList;
import ae.VectorBoolean;
import java.awt.AWTEventMulticaster;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class StylePanel
extends Panel
implements ItemListener {
    public static final int DISPLAY_TEXT = 0;
    public static final int DISPLAY_DIR = 1;
    public static final int DISPLAY_TREE = 2;
    public static final int DISPLAY_MESSAGE = 3;
    List panelList;
    Label labelDisplay;
    Choice choiceWorkFont;
    Label labelDisplayFont;
    Choice choiceWorkSize;
    Label labelDisplaySize;
    Choice choiceWorkBg;
    Label labelDisplayBg;
    Choice choiceWorkFg;
    Label labelDisplayFg;
    Choice choiceWorkStyle;
    Label labelDisplayStyle;
    DLabel labelFontTest;
    Style WorkStyle = new Style();
    Vector styles = new Vector();
    VectorBoolean masks = new VectorBoolean();
    int maxItems;
    int lmargin = 48;
    int tmargin = 32;
    ActionListener actionListener = null;

    public StylePanel(int l, int t) {
        this.setLayout(null);
        this.setVisible(false);
        this.lmargin = l;
        this.tmargin = t;
        this.labelFontTest = new DLabel("Your setting", 1, 1);
        this.labelFontTest.setBounds(this.lmargin + 16, this.tmargin + 16, 524, 32);
        this.add(this.labelFontTest);
        this.panelList = new List(12);
        this.panelList.setBounds(this.lmargin + 16, this.tmargin + 70, 112, 216);
        this.panelList.addItemListener(this);
        this.add(this.panelList);
        this.choiceWorkFont = new Choice();
        this.choiceWorkFont.setBounds(this.lmargin + 352, this.tmargin + 70, 192, 24);
        this.choiceWorkFont.addItemListener(this);
        this.add(this.choiceWorkFont);
        this.labelDisplayFont = new Label("Font", 2);
        this.labelDisplayFont.setBounds(this.lmargin + 282, this.tmargin + 70, 60, 22);
        this.add(this.labelDisplayFont);
        this.choiceWorkStyle = new Choice();
        this.choiceWorkStyle.setBounds(this.lmargin + 352, this.tmargin + 120, 100, 24);
        this.choiceWorkStyle.addItemListener(this);
        this.add(this.choiceWorkStyle);
        this.labelDisplayStyle = new Label("Style", 2);
        this.labelDisplayStyle.setBounds(this.lmargin + 282, this.tmargin + 121, 60, 22);
        this.add(this.labelDisplayStyle);
        this.choiceWorkSize = new Choice();
        this.choiceWorkSize.setBounds(this.lmargin + 352, this.tmargin + 168, 56, 24);
        this.choiceWorkSize.addItem("8");
        this.choiceWorkSize.addItem("9");
        this.choiceWorkSize.addItem("10");
        this.choiceWorkSize.addItem("11");
        this.choiceWorkSize.addItem("12");
        this.choiceWorkSize.addItem("13");
        this.choiceWorkSize.addItem("14");
        this.choiceWorkSize.addItem("15");
        this.choiceWorkSize.addItem("16");
        this.choiceWorkSize.addItem("17");
        this.choiceWorkSize.addItem("18");
        this.choiceWorkSize.addItem("20");
        this.choiceWorkSize.addItem("24");
        this.choiceWorkSize.addItem("32");
        this.choiceWorkSize.addItemListener(this);
        this.add(this.choiceWorkSize);
        this.labelDisplaySize = new Label("Size", 2);
        this.labelDisplaySize.setBounds(this.lmargin + 282, this.tmargin + 169, 60, 24);
        this.add(this.labelDisplaySize);
        this.choiceWorkBg = new Choice();
        this.choiceWorkBg.setBounds(this.lmargin + 352, this.tmargin + 212, 100, 24);
        this.choiceWorkBg.addItemListener(this);
        this.add(this.choiceWorkBg);
        this.labelDisplayBg = new Label("Background", 2);
        this.labelDisplayBg.setBounds(this.lmargin + 252, this.tmargin + 213, 88, 22);
        this.add(this.labelDisplayBg);
        this.choiceWorkFg = new Choice();
        this.choiceWorkFg.setBounds(this.lmargin + 352, this.tmargin + 264, 100, 24);
        this.choiceWorkFg.addItemListener(this);
        this.add(this.choiceWorkFg);
        this.labelDisplayFg = new Label("Foreground", 2);
        this.labelDisplayFg.setBounds(this.lmargin + 252, this.tmargin + 265, 88, 22);
        this.add(this.labelDisplayFg);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames();
        for (int i = 0; i < fonts.length; ++i) {
            if (fonts[i].equalsIgnoreCase("ZapfDingBats")) continue;
            this.choiceWorkFont.addItem(fonts[i]);
        }
        StyleList.fill(this.choiceWorkStyle);
        ColorList.fillChoice(this.choiceWorkBg);
        ColorList.fillChoice(this.choiceWorkFg);
        this.maxItems = 0;
    }

    public void addNotify() {
        super.addNotify();
        Container parent = this.getParent();
        Color PrgColor = parent.getBackground();
        this.panelList.setBackground(PrgColor);
        this.choiceWorkFont.setBackground(PrgColor);
        this.choiceWorkSize.setBackground(PrgColor);
        this.choiceWorkStyle.setBackground(PrgColor);
        this.choiceWorkBg.setBackground(PrgColor);
        this.choiceWorkFg.setBackground(PrgColor);
    }

    public void addItem(Style style, String name, boolean mask) {
        this.panelList.add(name);
        this.styles.addElement(style);
        this.masks.addElement(mask);
        ++this.maxItems;
    }

    public void addItem(Style style, String name) {
        this.addItem(style, name, true);
    }

    public void setCurrentStyle(int no) {
        try {
            this.panelList.select(no);
        }
        catch (IllegalArgumentException i) {
            System.out.println("StylePanel " + no + " out of " + this.panelList.getItemCount());
        }
        this.copyWork();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.setFontTest(true);
        }
    }

    void setFontTest(boolean diff) {
        this.WorkStyle.makeColors(diff);
        this.WorkStyle.makeFont();
        this.labelFontTest.setStyle(this.WorkStyle);
        this.labelFontTest.repaint();
    }

    void copyWork() {
        this.WorkStyle = (Style)this.styles.elementAt(Preferences.CurrentStyle);
        boolean mask = this.masks.elementAt(Preferences.CurrentStyle);
        try {
            this.choiceWorkSize.select(this.WorkStyle.sSize);
            this.choiceWorkFont.select(this.WorkStyle.sFont);
            this.choiceWorkStyle.select(this.WorkStyle.sStyle);
            this.choiceWorkBg.select(this.WorkStyle.sBackground);
            this.choiceWorkFg.select(this.WorkStyle.sForeground);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("StylePanel error in choice");
        }
        this.choiceWorkSize.setEnabled(mask);
        this.choiceWorkFont.setEnabled(mask);
        this.choiceWorkStyle.setEnabled(mask);
        this.choiceWorkFg.setEnabled(mask);
        this.WorkStyle.makeFont();
        this.setFontTest(true);
    }

    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (object == this.panelList) {
            Preferences.CurrentStyle = this.panelList.getSelectedIndex();
            this.copyWork();
            return;
        }
        String strevent = (String)event.getItem();
        if (object == this.choiceWorkFont) {
            this.WorkStyle.sFont = strevent;
        } else if (object == this.choiceWorkStyle) {
            this.WorkStyle.sStyle = strevent;
        } else if (object == this.choiceWorkSize) {
            this.WorkStyle.sSize = strevent;
        } else if (object == this.choiceWorkBg) {
            this.WorkStyle.sBackground = strevent;
        } else if (object == this.choiceWorkFg) {
            this.WorkStyle.sForeground = strevent;
        } else {
            return;
        }
        this.styles.setElementAt(this.WorkStyle, Preferences.CurrentStyle);
        this.setFontTest(false);
        this.sourceActionEvent(Preferences.CurrentStyle);
    }

    protected void sourceActionEvent(int action) {
        if (this.actionListener == null) {
            return;
        }
        String actionCommand = new Integer(action).toString();
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, actionCommand));
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }
}

