/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.ColorUtils;
import ae.DButtonBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;

public class TButton
extends DButtonBase
implements Serializable {
    protected Color textColor = null;
    protected Color disabledTextColor = null;
    Image icon;

    public TButton() {
        this("");
    }

    public TButton(String lab) {
        this.label = lab;
        this.textColor = Color.black;
        this.disabledTextColor = ColorUtils.lighten(this.textColor, 0.5);
    }

    public TButton(Image icon, String lab) {
        this(lab);
        this.icon = icon;
    }

    public Dimension getPreferredSize() {
        Dimension defaultSize = super.getPreferredSize();
        return new Dimension(defaultSize.width + 5, defaultSize.height + 5);
    }

    public Dimension getMinimumSize() {
        Dimension defaultSize = super.getPreferredSize();
        return new Dimension(defaultSize.width + 3, defaultSize.height + 3);
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        Graphics g = this.buttonImage.getGraphics();
        Dimension s = this.getSize();
        int w = s.width;
        int h = s.height;
        g.setFont(super.getFont());
        FontMetrics fm = g.getFontMetrics();
        int lh = fm.getHeight() + 4;
        int lw = fm.stringWidth(this.label) + 6;
        int xLab = (w - lw) / 2 + 3;
        int yLab = (h - lh) / 2 + 18;
        if (this.icon != null) {
            int iWidth = this.icon.getWidth(this);
            int iHeight = h - 8;
            xLab = h + (w - h - lw) / 2;
            g.drawImage(this.icon, 4, (h - iHeight) / 2, iWidth, iHeight, this);
        }
        if (this.isEnabled()) {
            g.setColor(this.textColor);
        } else {
            g.setColor(this.disabledTextColor);
        }
        g.drawString(this.label, xLab, yLab);
        if (g != null) {
            g.dispose();
        }
    }

    protected boolean isValidBevelSize(int i) {
        Dimension s = this.getSize();
        int temp = i * 2 + 4;
        return i >= 0 && s.width >= temp && s.height >= temp;
    }
}

