/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.SpinButtonPanel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class TSpinner
extends Panel
implements ActionListener {
    protected int min;
    protected int max;
    protected int current;
    protected String text;
    protected TextField textField;
    protected int increment;
    protected ActionListener actionListener = null;
    protected SpinButtonPanel buttonPanel;
    protected int gap = 2;
    boolean editable;
    boolean wrappable;
    int previous = 0;

    public TSpinner() {
        super.setLayout(null);
        this.buttonPanel = new SpinButtonPanel();
        this.add(this.buttonPanel);
        this.textField = new TextField("0", 1);
        this.textField.setBackground(Color.white);
        this.add(this.textField);
        this.increment = 1;
        this.min = 0;
        this.max = 0;
        this.current = 0;
        this.setEditable(true);
        this.setWrappable(false);
        this.previous = 0;
        this.buttonPanel.addActionListener(this);
        this.textField.addActionListener(this);
    }

    public TSpinner(int current, int min, int max) {
        this();
        this.setMin(min);
        this.setMax(max);
        this.setCurrent(current);
        this.previous = current;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.buttonPanel.setBounds(w - 20, 0, 20, 20);
        this.textField.setBounds(0, 0, w - 20, 20);
    }

    public void setEditable(boolean f) {
        this.editable = f;
        this.textField.setEditable(f);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setWrappable(boolean f) {
        this.wrappable = f;
        this.updateButtonStatus();
    }

    public boolean isWrappable() {
        return this.wrappable;
    }

    public void setMin(int i) {
        this.min = i;
        this.setCurrent(this.current);
        this.updateButtonStatus();
    }

    public int getMin() {
        return this.min;
    }

    public void setMax(int i) {
        this.max = i;
        this.setCurrent(this.current);
        this.updateButtonStatus();
    }

    public int getMax() {
        return this.max;
    }

    public void setCurrent(int i) {
        this.current = i;
        if (this.current < this.min) {
            this.current = this.min;
        }
        if (this.current > this.max) {
            this.current = this.max;
        }
        this.setText(this.current);
        this.updateButtonStatus();
    }

    public int getCurrent() {
        return this.current;
    }

    public void setNotifyWhilePressed(boolean f) {
        this.buttonPanel.setNotifyWhilePressed(f);
    }

    public boolean isNotifyWhilePressed() {
        return this.buttonPanel.isNotifyWhilePressed();
    }

    public void setDelay(int d) {
        this.buttonPanel.setDelay(d);
    }

    public int getDelay() {
        return this.buttonPanel.getDelay();
    }

    public void setLayout(LayoutManager lm) {
    }

    public Dimension getPreferredSize() {
        int width = 50;
        int height = 20;
        Dimension t = this.textField.getPreferredSize();
        Dimension b = this.buttonPanel.getPreferredSize();
        int macTextAdjustment = 0;
        int macPosAdjustment = 0;
        width = b.width + t.width + this.gap + macPosAdjustment;
        height = t.height + macTextAdjustment;
        return new Dimension(width, height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected boolean isValidCurrent(int i) {
        return i <= this.max && i >= this.min;
    }

    protected boolean isValidMax(int i) {
        return i >= this.min;
    }

    protected boolean isValidMin(int i) {
        return i <= this.max;
    }

    protected void sourceActionEvent(String s) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, s));
        }
    }

    protected void scrollUp() {
        int i = this.current + this.increment;
        if (i > this.max) {
            i = this.wrappable ? this.min : this.max;
        }
        this.setCurrent(i);
    }

    protected void scrollDown() {
        int i = this.current - this.increment;
        if (i < this.min) {
            i = this.wrappable ? this.max : this.min;
        }
        this.setCurrent(i);
    }

    public void setText(int val) {
        this.textField.setText(Integer.toString(val));
    }

    public String getText() {
        return this.textField.getText();
    }

    public boolean isModified() {
        boolean test = this.previous != this.current;
        this.previous = this.current;
        return test;
    }

    protected void updateButtonStatus() {
        if (this.buttonPanel != null) {
            if (this.wrappable) {
                this.buttonPanel.setUpButtonEnabled(true);
                this.buttonPanel.setDownButtonEnabled(true);
            } else if (this.current == this.max && this.current == this.min) {
                this.buttonPanel.setUpButtonEnabled(false);
                this.buttonPanel.setDownButtonEnabled(false);
            } else if (this.current == this.max) {
                this.buttonPanel.setUpButtonEnabled(false);
                this.buttonPanel.setDownButtonEnabled(true);
            } else if (this.current == this.min) {
                this.buttonPanel.setUpButtonEnabled(true);
                this.buttonPanel.setDownButtonEnabled(false);
            } else {
                this.buttonPanel.setUpButtonEnabled(true);
                this.buttonPanel.setDownButtonEnabled(true);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Increment")) {
            this.scrollUp();
            this.sourceActionEvent("ScrollUp");
        } else if (actionCommand.equals("Decrement")) {
            this.scrollDown();
            this.sourceActionEvent("ScrollDown");
        } else {
            this.setCurrent(new Integer(this.textField.getText()));
            this.sourceActionEvent("Enter");
            return;
        }
    }
}

