/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.ColorUtils;
import ae.DirButton;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;

public class TabPanel
extends Panel {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int ROUNDED = 0;
    public static final int CUTTED = 1;
    public static final int SLANTED = 2;
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public int bevel = 1;
    Vector vPanels;
    String[] labels = null;
    private Vector vEnabled;
    protected Vector vPolys;
    protected int curIndex = -1;
    protected transient boolean suppressRepaints = false;
    protected int firstVisibleTab = 0;
    protected DirButton dbLeft;
    protected DirButton dbRight;
    protected Polygon nullPoly;
    protected Vector vLabels;
    protected Color borderDarkerColor = null;
    protected Color borderLightColor = null;
    protected Color borderDarkColor = null;
    protected Color disabledTextColor = null;
    protected Color cachedForeground = null;
    protected Color cachedBackground = null;
    private int TF_LEFT = 0;
    private int TF_RIGHT = 0;
    private int TF_TOP = 24;
    private int TF_BOTTOM = -2;
    private int TF_BTN_HEIGHT = 20;
    private Font fReg;
    private Font fSel;
    private Component userPanel = null;
    private int iTabsPosition = 0;
    private int iTabsStyle = 0;
    private transient int osAdjustment;
    private int lastWidth = -1;
    private Insets btpInsets;
    private Mouse mouse = null;
    private Action action = null;
    Font tabRegFont = new Font("Dialog", 0, 14);
    Font tabSelFont = new Font("Dialog", 1, 14);
    public int previousIndex = 0;
    int marginl = 3;
    int margint = 3;
    int marginr = 6;
    int marginb = 5;

    public TabPanel(int tabsPosition, int tabsStyle) {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.btpInsets = new Insets(0, 0, 0, 0);
        this.setTabsInfo(tabsPosition, tabsStyle);
        this.fReg = this.tabRegFont;
        this.fSel = this.tabSelFont;
        this.osAdjustment = System.getProperty("os.name").startsWith("S") ? -1 : 0;
        super.setLayout(null);
        this.dbLeft = new DirButton(0);
        this.dbRight = new DirButton(1);
        this.dbLeft.setShowFocus(false);
        this.dbRight.setShowFocus(false);
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.nullPoly = new Polygon();
        this.nullPoly.addPoint(0, 0);
        this.nullPoly.addPoint(1, 1);
        this.nullPoly.addPoint(0, 0);
        this.cachedForeground = this.getForeground();
        this.cachedBackground = this.getBackground();
        this.vPanels = new Vector();
    }

    public TabPanel() {
        this(0, 0);
    }

    public void setBevel(int s) {
        this.bevel = s;
    }

    public void setBackground(Color b) {
        super.setBackground(b);
        if (this.dbLeft != null) {
            this.dbLeft.setBackground(b);
        }
        if (this.dbRight != null) {
            this.dbRight.setBackground(b);
        }
    }

    public void setTabFonts(Font reg, Font sel) {
        this.tabRegFont = reg;
        this.tabSelFont = sel;
    }

    public void setTabsPosition(int tabsPosition) {
        if (this.iTabsPosition != tabsPosition) {
            this.setTabsInfo(tabsPosition, this.iTabsStyle);
        }
    }

    public int getTabsPosition() {
        return this.iTabsPosition;
    }

    public void setTabsStyle(int tabsStyle) {
        if (this.iTabsStyle != tabsStyle) {
            this.setTabsInfo(this.iTabsPosition, tabsStyle);
        }
    }

    public int getTabsStyle() {
        return this.iTabsStyle;
    }

    public void setTabsInfo(int tabsPosition, int tabsStyle) {
        this.iTabsPosition = tabsPosition;
        this.iTabsStyle = tabsStyle;
        this.TF_BTN_HEIGHT = this.iTabsStyle == 2 && tabsPosition == 1 ? 17 : 20;
        this.triggerRepaint();
    }

    public boolean setSuppressRepaints(boolean b) {
        boolean wasSuppressingRepaints = this.suppressRepaints;
        this.suppressRepaints = b;
        return wasSuppressingRepaints;
    }

    protected void triggerRepaint() {
        if (!this.suppressRepaints) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTab(String sLabel, boolean bEnabled, int index) {
        boolean wasSuppressingRepaints = this.setSuppressRepaints(true);
        try {
            this.setLabel(sLabel, index);
            this.setEnabled(bEnabled, index);
        }
        finally {
            this.setSuppressRepaints(wasSuppressingRepaints);
        }
        this.triggerRepaint();
    }

    public synchronized void setLabel(String sLabel, int index) {
        try {
            this.vLabels.setElementAt(sLabel, index);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public synchronized String getLabel(int index) {
        try {
            return (String)this.vLabels.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public void setPanelLabels(String[] sLabels) {
        this.labels = sLabels;
        this.updatePanelLabels();
    }

    public String[] getPanelLabels() {
        return this.labels;
    }

    public synchronized void setEnabled(boolean bEnabled, int index) {
        if (index < 0 || index >= this.vLabels.size()) {
            return;
        }
        if (index == this.curIndex && !bEnabled) {
            return;
        }
        try {
            Boolean newValue = new Boolean(bEnabled);
            this.vEnabled.setElementAt(newValue, index);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean isEnabled(int index) {
        try {
            Boolean bool = (Boolean)this.vEnabled.elementAt(index);
            if (bool.booleanValue()) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public synchronized int getPanelIndex(Component panel) {
        return this.vPanels.indexOf(panel);
    }

    public void setPanel(int index) {
        if (index == this.curIndex) {
            return;
        }
        this.select(index);
    }

    public synchronized void select(int index) {
        if (this.isEnabled(index)) {
            try {
                Component p = (Component)this.vPanels.elementAt(index);
                this.setCurrentTab(index);
                this.showPanel(p);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTab(int index) {
        if (index == this.curIndex) {
            return;
        }
        if (this.isEnabled(index)) {
            this.previousIndex = this.curIndex;
            this.curIndex = index;
        }
    }

    public void showPanel(Component p) {
        if (this.userPanel != null) {
            this.userPanel.setVisible(false);
        }
        this.userPanel = p;
        if (this.userPanel != null) {
            int x;
            Component[] comps = this.getComponents();
            int l = comps.length;
            for (x = 0; x < l && comps[x] != this.userPanel; ++x) {
            }
            if (x == l) {
                super.add(this.userPanel, -1);
            }
            this.userPanel.setVisible(true);
            this.userPanel.requestFocus();
            this.validate();
            this.triggerRepaint();
        }
    }

    public void backTab() {
        this.setCurrentTab(this.previousIndex);
    }

    public int getCurrentTab() {
        return this.curIndex;
    }

    public int getTab() {
        return this.curIndex;
    }

    public int addTab(String sLabel, boolean bEnabled) {
        return this.addTab(sLabel, bEnabled, -1);
    }

    public int addTab(String sLabel, boolean bEnabled, int pos) {
        int index;
        if (pos == -1) {
            this.vLabels.addElement(sLabel);
            this.vEnabled.addElement(new Boolean(bEnabled));
            index = this.vLabels.size() - 1;
        } else {
            this.vLabels.insertElementAt(sLabel, pos);
            this.vEnabled.insertElementAt(new Boolean(bEnabled), pos);
            index = pos;
        }
        if (this.curIndex == -1 && bEnabled) {
            this.setCurrentTab(index);
        }
        return index;
    }

    public synchronized void insertTab(String sLabel, boolean bEnabled, int index) {
        if (index == this.curIndex && !bEnabled) {
            return;
        }
        try {
            this.vLabels.insertElementAt(sLabel, index);
            this.vEnabled.insertElementAt(new Boolean(bEnabled), index);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public int addTabPanel(String sLabel, boolean bEnabled, Component panel) {
        return this.addTabPanel(sLabel, bEnabled, panel, -1);
    }

    public int addTabPanel(String sLabel, boolean bEnabled, Component panel, int pos) {
        if (pos == -1) {
            this.vPanels.addElement(panel);
        } else {
            this.vPanels.insertElementAt(panel, pos);
        }
        return this.addTab(sLabel, bEnabled, pos);
    }

    public synchronized void insertTabPanel(String sLabel, boolean bEnabled, Component panel, int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return;
        }
        if (index == this.getCurrentTab() && !bEnabled) {
            return;
        }
        try {
            this.vPanels.insertElementAt(panel, index);
            this.insertTab(sLabel, bEnabled, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public synchronized Component add(String name, Component comp) {
        this.addTabPanel(name, true, comp);
        return comp;
    }

    public Component add(Component comp) {
        this.addTabPanel(this.createDefaultLabel(this.vPanels.size()), true, comp);
        return comp;
    }

    public synchronized Component add(Component comp, int pos) {
        this.add(this.createDefaultLabel(this.vPanels.size()), comp, pos);
        return comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Component add(String lab, Component comp, int pos) {
        boolean wasSuppressingRepaints = this.setSuppressRepaints(true);
        try {
            int newIndex = this.addTabPanel(lab, true, comp, pos);
            if (newIndex == this.curIndex) {
                this.select(newIndex);
            }
            this.updatePanelLabels();
        }
        finally {
            this.setSuppressRepaints(wasSuppressingRepaints);
        }
        this.triggerRepaint();
        return comp;
    }

    public void setPanelLabel(String newLabel, int labelIndex) {
        if (labelIndex >= 0 && labelIndex < this.labels.length && this.labels[labelIndex] != newLabel) {
            this.labels[labelIndex] = newLabel;
            this.updatePanelLabels();
        }
    }

    public String getPanelLabel(int labelIndex) {
        if (labelIndex >= 0 && labelIndex < this.labels.length) {
            return this.labels[labelIndex];
        }
        return null;
    }

    public synchronized void setTabPanel(String sLabel, boolean bEnabled, Component panel, int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return;
        }
        if (index == this.getCurrentTab() && !bEnabled) {
            return;
        }
        try {
            this.vPanels.setElementAt(panel, index);
            this.setTab(sLabel, bEnabled, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public synchronized Component getTabPanel(int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return null;
        }
        Component p = null;
        try {
            p = (Component)this.vPanels.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return p;
    }

    public synchronized void remove(Component comp) {
        int i = this.getPanelIndex(comp);
        if (this.countTabs() == 1) {
            this.removeAllTabPanels();
        } else {
            if (i == 0) {
                this.select(1);
            } else {
                this.select(i - 1);
            }
            this.removeTabPanel(i);
        }
    }

    public void removeTab(int index) {
        if (index == this.curIndex) {
            return;
        }
        try {
            this.vLabels.removeElementAt(index);
            this.vEnabled.removeElementAt(index);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void removeAllTabs() {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.curIndex = -1;
        this.firstVisibleTab = 0;
        this.lastWidth = -1;
        this.removeAll();
        this.triggerRepaint();
    }

    public synchronized void removeTabPanel(int index) {
        if (index < 0 || index >= this.vPanels.size() || index == this.curIndex) {
            return;
        }
        try {
            Component p = (Component)this.vPanels.elementAt(index);
            super.remove(p);
            this.vPanels.removeElementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.removeTab(index);
    }

    public synchronized void removeAllTabPanels() {
        this.vPanels = new Vector();
        this.curIndex = -1;
        this.removeAllTabs();
    }

    public void updatePanelLabels() {
        try {
            for (int i = 0; i < this.vPanels.size(); ++i) {
                String newlabel;
                if (this.labels != null) {
                    try {
                        newlabel = this.labels[i];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        newlabel = this.createDefaultLabel(i);
                    }
                } else {
                    newlabel = this.createDefaultLabel(i);
                }
                this.setLabel(newlabel, i);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setMargins(int l, int t, int r, int b) {
        this.marginl = l;
        this.margint = t;
        this.marginr = r;
        this.marginb = b;
    }

    public void doLayout() {
        Rectangle r = this.getBounds();
        int width = r.width - this.TF_LEFT + this.TF_RIGHT;
        if (width < 0) {
            return;
        }
        int height = r.height - this.TF_TOP + this.TF_BOTTOM;
        if (height < 0) {
            return;
        }
        int col = this.TF_LEFT;
        int row = 0;
        row = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        if (this.userPanel != null) {
            this.userPanel.setBounds(col + this.marginl, row + this.margint, width - this.marginr, height - this.marginb);
            this.userPanel.invalidate();
            this.userPanel.validate();
            if (this.userPanel instanceof Canvas || this.userPanel instanceof Panel) {
                this.userPanel.repaint();
            } else {
                this.triggerRepaint();
            }
        }
    }

    void drawUnderlined(Graphics g, String s, int x, int y) {
        if (s.charAt(0) == '+') {
            g.drawString("_", x, y);
            g.drawString(s.substring(1, s.length()), x, y);
        } else {
            g.drawString(s, x, y);
        }
    }

    void drawNoUnderlined(Graphics g, String s, int x, int y) {
        if (s.charAt(0) == '+') {
            g.drawString(s.substring(1, s.length()), x, y);
        } else {
            g.drawString(s, x, y);
        }
    }

    public synchronized void paint(Graphics g) {
        int w;
        int width;
        Rectangle r = this.getBounds();
        Color curForeground = this.getForeground();
        Color curBackground = this.getBackground();
        if (!TabPanel.objectsEqual(curForeground, this.cachedForeground)) {
            this.cachedForeground = curForeground;
            this.calculateDisabledTextColor(curForeground);
        }
        if (!TabPanel.objectsEqual(curBackground, this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.calculateBorderColors(curBackground);
        }
        if ((width = r.width - this.TF_LEFT + this.TF_RIGHT) < 0) {
            return;
        }
        int height = r.height - this.TF_TOP + this.TF_BOTTOM;
        if (height < 0) {
            return;
        }
        if (r.width > this.lastWidth) {
            this.firstVisibleTab = 0;
        }
        this.lastWidth = r.width;
        int col = this.TF_LEFT;
        Color c = g.getColor();
        g.setColor(curBackground);
        g.fillRect(0, 0, r.width, r.height);
        int row = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        int strOffset = 8;
        if (this.iTabsStyle == 2) {
            strOffset = 14;
        }
        g.setColor(this.borderLightColor);
        g.drawLine(col, row, col + width - 1, row);
        if (this.bevel == 1) {
            g.drawLine(col, row, col, row + height - 1);
            g.setColor(this.borderDarkColor);
            g.drawLine(col + 2, row + height - 2, col + width - 2, row + height - 2);
            g.drawLine(col + width - 2, row + 2, col + width - 2, row + height - 2);
            g.setColor(this.borderDarkerColor);
            g.drawLine(col + 1, row + height - 1, col + width - 1, row + height - 1);
            g.drawLine(col + width - 1, row + 1, col + width - 1, row + height - 1);
        }
        int x2 = this.TF_LEFT + 8;
        int x3 = 0;
        int x4 = this.TF_LEFT;
        int offset = 0;
        int sze = this.vLabels.size();
        this.vPolys.removeAllElements();
        Font f = g.getFont();
        FontMetrics fm = this.getFontMetrics(this.fReg);
        FontMetrics fms = this.getFontMetrics(this.fSel);
        int labelWidth = 0;
        for (w = 0; w < this.firstVisibleTab; ++w) {
            this.vPolys.addElement(this.nullPoly);
        }
        if (w > 0) {
            x4 += 2;
        }
        while (w < sze) {
            Polygon p = new Polygon();
            try {
                int x1;
                int y2;
                int y1;
                String sLabel = (String)this.vLabels.elementAt(w);
                String refLabel = sLabel.charAt(0) == '+' ? sLabel.substring(1, sLabel.length()) : sLabel;
                labelWidth = w == this.curIndex ? fms.stringWidth(refLabel) : fm.stringWidth(refLabel);
                if (this.iTabsPosition == 0) {
                    y1 = this.TF_TOP - this.TF_BTN_HEIGHT;
                    y2 = this.TF_TOP - 1;
                } else {
                    y1 = r.height + this.TF_BOTTOM + 1;
                    y2 = r.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT;
                }
                if (this.iTabsStyle == 0) {
                    x1 = x4 + 2;
                    x2 = x1 + labelWidth + 13;
                } else if (this.iTabsStyle == 1) {
                    x1 = x4 + 2;
                    x2 = x1 + labelWidth + 13;
                    offset = 4;
                } else {
                    x1 = x2 - 7;
                    x2 = x1 + labelWidth + 28;
                }
                if (x2 + 36 - this.TF_RIGHT > r.width) break;
                if (this.iTabsPosition == 0) {
                    if (this.iTabsStyle == 2) {
                        g.setColor(this.borderLightColor);
                        g.drawLine(x1 + 9, y1, x2 - 9, y1);
                        if (w == 0 || w == this.curIndex) {
                            g.drawLine(x1, y2, x1 + 9, y1);
                            p.addPoint(x1, y2);
                        } else {
                            g.drawLine(x1 + 4, y1 + 9, x1 + 9, y1);
                            p.addPoint(x1 + 9, y2);
                            p.addPoint(x1 + 4, y1 + 9);
                        }
                        p.addPoint(x1 + 9, y1);
                        p.addPoint(x2 - 9, y1);
                        g.setColor(this.borderDarkColor);
                        if (w + 1 == this.curIndex) {
                            g.drawLine(x2 - 9, y1, x2 - 5, y1 + 9);
                            p.addPoint(x2 - 9, y1);
                            p.addPoint(x2 - 5, y2);
                        } else {
                            g.drawLine(x2, y2, x2 - 9, y1);
                            p.addPoint(x2, y2);
                        }
                        if (w == 1 || w == this.curIndex) {
                            p.addPoint(x1, y2);
                        } else {
                            p.addPoint(x1 + 9, y2);
                        }
                        g.setColor(this.borderDarkerColor);
                        if (w + 1 == this.curIndex) {
                            g.drawLine(x2 - 8, y1 + 1, x2 - 4, y1 + 9);
                        } else {
                            g.drawLine(x2 + 1, y2, x2 - 8, y1 + 1);
                        }
                    } else {
                        if (w == this.curIndex) {
                            y1 -= 3;
                            x1 -= 2;
                        }
                        g.setColor(this.borderLightColor);
                        if (this.curIndex == w + 1) {
                            g.drawLine(x1 + 2 + offset, y1, x2 - 2, y1);
                        } else {
                            g.drawLine(x1 + 2 + offset, y1, x2, y1);
                        }
                        if (this.curIndex != w - 1) {
                            g.drawLine(x1, y1 + 2 + offset, x1, y2);
                            x3 = x1;
                        } else {
                            x3 = x1 + 1;
                        }
                        g.drawLine(x1 + 1, y1 + 1 + offset, x1 + 1 + offset, y1 + 1);
                        if (this.curIndex != w + 1) {
                            g.setColor(this.borderDarkColor);
                            g.drawLine(x2, y1, x2, y2);
                            g.setColor(this.borderDarkerColor);
                            g.drawLine(x2 + 1, y1 + 2, x2 + 1, y2);
                            x4 = x2;
                        } else {
                            x4 = x2 - 1;
                        }
                    }
                } else if (this.iTabsStyle == 2) {
                    g.setColor(this.borderDarkColor);
                    g.drawLine(x1 + 9, y1, x2 - 9, y1);
                    g.setColor(this.borderDarkerColor);
                    if (w == 0 || w == this.curIndex) {
                        g.drawLine(x1, y2, x1 + 9, y1);
                        p.addPoint(x1, y2);
                    } else {
                        g.drawLine(x1 + 4, y1 - 9, x1 + 9, y1);
                        p.addPoint(x1 + 9, y2);
                        p.addPoint(x1 + 4, y1 - 9);
                    }
                    p.addPoint(x1 + 9, y1);
                    p.addPoint(x2 - 9, y1);
                    if (w + 1 == this.curIndex) {
                        g.drawLine(x2 - 5, y1 - 9, x2 - 9, y1);
                        p.addPoint(x2 - 5, y1);
                        p.addPoint(x2 - 9, y2);
                    } else {
                        g.drawLine(x2, y2, x2 - 9, y1);
                        p.addPoint(x2, y2);
                    }
                    if (w == 1 || w == this.curIndex) {
                        p.addPoint(x1, y2);
                    } else {
                        p.addPoint(x1 + 9, y2);
                    }
                } else {
                    if (w == this.curIndex) {
                        y1 += 3;
                        x1 -= 2;
                    }
                    g.setColor(this.borderLightColor);
                    if (this.curIndex == w + 1) {
                        g.drawLine(x1 + 2, y1, x2 - 2, y1);
                    } else {
                        g.drawLine(x1 + 2, y1, x2, y1);
                    }
                    if (this.curIndex != w - 1) {
                        g.drawLine(x1, y1 - 2, x1, y2);
                        x3 = x1;
                    } else {
                        x3 = x1 + 1;
                    }
                    g.drawLine(x1 + 1, y1 - 1, x1 + 1, y1 - 1);
                    if (this.curIndex != w + 1) {
                        g.setColor(this.borderDarkColor);
                        g.drawLine(x2, y1, x2, y2);
                        g.setColor(this.borderDarkerColor);
                        g.drawLine(x2 + 1, y1 - 2, x2 + 1, y2);
                        x4 = x2;
                    } else {
                        x4 = x2 - 1;
                    }
                }
                boolean current = false;
                if (w == this.curIndex) {
                    current = true;
                    y2 = this.iTabsPosition == 0 ? ++y2 : --y2;
                    g.setColor(curBackground);
                    g.drawLine(x1 + 1, y2, x2, y2);
                    if (this.iTabsPosition == 1) {
                        g.drawLine(x1 + 1, y2 - 1, x2, y2 - 1);
                    }
                    g.setFont(this.fSel);
                } else {
                    g.setFont(this.fReg);
                }
                if (this.iTabsStyle == 0 || this.iTabsStyle == 1) {
                    p.addPoint(x3, y2);
                    p.addPoint(x4, y2);
                    p.addPoint(x4, y1);
                    p.addPoint(x3, y1);
                    p.addPoint(x3, y2);
                }
                this.vPolys.addElement(p);
                Boolean bool = (Boolean)this.vEnabled.elementAt(w);
                if (bool.booleanValue()) {
                    g.setColor(curForeground);
                } else {
                    g.setColor(this.disabledTextColor);
                }
                if (this.iTabsPosition == 0) {
                    if (current) {
                        this.drawNoUnderlined(g, sLabel, x1 + strOffset, y1 + 15 + this.osAdjustment);
                    } else {
                        this.drawUnderlined(g, sLabel, x1 + strOffset, y1 + 15 + this.osAdjustment);
                    }
                } else if (this.iTabsStyle == 0 || this.iTabsStyle == 1) {
                    g.drawString(sLabel, x1 + strOffset, y1 - 6 + this.osAdjustment);
                } else {
                    g.drawString(sLabel, x1 + strOffset, y1 - 4 + this.osAdjustment);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            ++w;
        }
        if (this.firstVisibleTab > 0 || w < sze) {
            this.dbLeft.setVisible(true);
            this.dbRight.setVisible(true);
            if (this.firstVisibleTab > 0) {
                this.dbLeft.setEnabled(true);
            } else {
                this.dbLeft.setEnabled(false);
            }
            if (w < sze) {
                this.dbRight.setEnabled(true);
            } else {
                this.dbRight.setEnabled(false);
            }
            if (this.iTabsPosition == 0) {
                this.dbLeft.setBounds(r.width - 33 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
                this.dbRight.setBounds(r.width - 16 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
            } else {
                this.dbLeft.setBounds(r.width - 33 + this.TF_RIGHT, r.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
                this.dbRight.setBounds(r.width - 16 + this.TF_RIGHT, r.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
            }
        } else {
            this.dbLeft.setVisible(false);
            this.dbRight.setVisible(false);
        }
        while (w < sze) {
            this.vPolys.addElement(this.nullPoly);
            ++w;
        }
        g.setFont(f);
        g.setColor(c);
    }

    public synchronized void removeAll() {
        super.removeAll();
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.userPanel = null;
    }

    public void setLayout(LayoutManager mgr) {
    }

    public Insets getInsets() {
        this.btpInsets = super.getInsets();
        this.btpInsets.left += this.TF_LEFT + 3;
        this.btpInsets.right += 6 - this.TF_RIGHT;
        if (this.iTabsPosition == 0) {
            this.btpInsets.top += this.TF_TOP + 3;
            this.btpInsets.bottom += 5 - this.TF_BOTTOM;
        } else {
            this.btpInsets.top += this.TF_TOP - this.TF_BTN_HEIGHT + 3;
            this.btpInsets.bottom += this.TF_BTN_HEIGHT + 5 - this.TF_BOTTOM;
        }
        return this.btpInsets;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.action == null) {
            this.action = new Action();
            this.dbLeft.addActionListener(this.action);
            this.dbRight.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.action != null) {
            this.dbLeft.removeActionListener(this.action);
            this.dbRight.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    protected void calculateBorderColors(Color c) {
        this.borderLightColor = ColorUtils.calculateHilightColor(c);
        this.borderDarkColor = ColorUtils.calculateShadowColor(c);
        this.borderDarkerColor = ColorUtils.darken(this.borderDarkColor, 0.2);
    }

    protected void calculateDisabledTextColor(Color c) {
        try {
            this.disabledTextColor = ColorUtils.fade(c, Color.lightGray, 0.5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static boolean objectsEqual(Object objectA, Object objectB) {
        if (objectA == null) {
            return objectB == null;
        }
        return objectA.equals(objectB);
    }

    public int countTabs() {
        return this.vPanels.size();
    }

    public Dimension getPreferredSize() {
        Dimension p = this.getSize();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(p.width, m.width), Math.max(p.height, m.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    private String createDefaultLabel(int i) {
        return "Tab " + String.valueOf(i);
    }

    class Action
    implements ActionListener,
    Serializable {
        Action() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TabPanel.this.dbLeft) {
                if (--TabPanel.this.firstVisibleTab < 0) {
                    TabPanel.this.firstVisibleTab = 0;
                } else {
                    TabPanel.this.triggerRepaint();
                }
            } else if (e.getSource() == TabPanel.this.dbRight) {
                int sze = TabPanel.this.vLabels.size();
                if (++TabPanel.this.firstVisibleTab == sze) {
                    --TabPanel.this.firstVisibleTab;
                } else {
                    TabPanel.this.triggerRepaint();
                }
            }
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        Mouse() {
        }

        public void mousePressed(MouseEvent e) {
            int sizeR = TabPanel.this.vPolys.size();
            for (int x = 0; x < sizeR; ++x) {
                try {
                    Polygon p = (Polygon)TabPanel.this.vPolys.elementAt(x);
                    if (p == TabPanel.this.nullPoly || !p.contains(e.getX(), e.getY())) continue;
                    TabPanel.this.select(x);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    // empty catch block
                }
            }
        }
    }
}

