/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Archiver;
import ae.Deleter;
import ae.Path;
import java.io.File;

public class Temporary {
    String createdPath;
    String createdDir;
    String createdFile;
    String tomakeFile;
    String tomakeDir;
    String tomakePath;
    String message = "ok";
    boolean result = true;
    static String defaultDir = System.getProperty("user.dir") + File.separator + "AE$$$.Temporary";
    String arcDir;
    String arcName;
    String fileRead;

    public Temporary(String basedir) {
        this.clear();
        this.tomakeDir = basedir + File.separator + "AE$$$.Temporary";
    }

    public Temporary() {
        this.clear();
        this.tomakeDir = defaultDir;
    }

    public void clear() {
        this.tomakeFile = null;
        this.tomakeDir = null;
        this.tomakePath = null;
        this.createdPath = null;
        this.createdDir = null;
        this.createdFile = null;
    }

    public boolean make(String file) {
        this.tomakeFile = Path.splitFile(file);
        this.tomakePath = Path.merge(this.tomakeDir, this.tomakeFile);
        File f = new File(this.tomakeDir);
        if (!f.exists() && !f.mkdirs()) {
            return false;
        }
        this.createdDir = this.tomakeDir;
        return true;
    }

    public boolean alreadyCopied() {
        return new File(this.tomakeDir, this.tomakeFile).exists();
    }

    public boolean isCreated() {
        if (new File(this.createdDir, this.tomakeFile).exists()) {
            this.createdFile = this.tomakeFile;
            this.createdPath = this.tomakePath;
            return true;
        }
        return false;
    }

    boolean isRunning() {
        File f = new File(this.createdPath);
        if (!f.exists()) {
            return false;
        }
        return !f.canWrite();
    }

    public boolean kill() {
        boolean result = true;
        if (this.createdPath != null && !Deleter.delete(this.createdPath)) {
            result = false;
        }
        if (this.createdDir == null) {
            return false;
        }
        if (Deleter.deleteDir(this.createdDir) < 1) {
            result = false;
        }
        this.message = !result ? "Temporary files not deleted" : this.createdFile + " successfully achieved";
        return result;
    }

    public static void clean() {
        Deleter.deleteDir(defaultDir);
    }

    public void setNames(String aDir, String aName, String fileToExtract) {
        this.arcName = aName;
        this.arcDir = aDir;
        this.fileRead = fileToExtract;
    }

    public boolean open() {
        if (!this.make(this.fileRead)) {
            this.message = "Enable to make the temporary directory...";
            this.result = false;
            return false;
        }
        String arc = Path.merge(this.arcDir, this.arcName);
        if (!Archiver.extractFile(arc, this.fileRead, this.createdDir, false)) {
            this.message = Archiver.getMessage();
            this.result = false;
            return false;
        }
        if (!this.isCreated()) {
            this.message = "Error when creating temporary file";
            this.result = false;
            return false;
        }
        return true;
    }

    public boolean open(String arcDir, String arcName, String fileToExtract) {
        this.setNames(arcDir, arcName, fileToExtract);
        return this.open();
    }
}

