/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DMessageBar;
import ae.DialogCYN;
import ae.Disk;
import ae.FindDialog;
import ae.FindReplace;
import ae.FindReplaceEngine;
import ae.History;
import ae.Path;
import ae.Preferences;
import ae.ReplaceDialog;
import ae.Style;
import ae.TextModel;
import ae.Tool;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class TextEditor
extends Panel
implements KeyListener,
ActionListener {
    final int CANCEL = 0;
    final int YES = 1;
    final int NO = 2;
    public String TextPath = null;
    public String TextName = null;
    public String TextDir = null;
    public String UpdateDir = null;
    public String m_dirName;
    public String m_fileName;
    public String m_pathName;
    FindReplace m_findReplace;
    TextArea area;
    TextModel textModel;
    public String TextMessage = "";
    public static final String NoName = "+Editor";
    public boolean Editable = true;
    public boolean Edited = false;
    boolean wraparound;
    Frame frame = null;
    ActionListener actionListener = null;
    KeyListener keyListener;
    DMessageBar messageBar = null;
    History history = null;

    public TextEditor(Frame f) {
        this.setLayout(new GridLayout());
        this.frame = f;
        this.wraparound = Preferences.wordWrap;
        if (this.wraparound) {
            boolean mode = true;
        } else {
            boolean mode = false;
        }
        this.area = new TextArea("", 80, 16384, 1);
        this.area.addKeyListener(this);
        this.add(this.area);
        this.textModel = new TextModel(this.area);
        this.m_findReplace = new FindReplace(this.area, this.textModel);
        this.TextName = NoName;
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.area.setFont(f);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.area.setBackground(c);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.area.setForeground(c);
    }

    public void setStyle(Style s) {
        this.setBackground(s.background);
        this.setForeground(s.foreground);
        this.setFont(s.font);
    }

    public void setEditable(boolean state) {
        this.Editable = !state;
        this.area.setEditable(this.Editable);
    }

    public String getDir() {
        return this.m_dirName;
    }

    public void setEdited(boolean e) {
        this.Edited = e;
        this.m_findReplace.setEdited(e);
    }

    public boolean isEdited() {
        if (this.Edited) {
            return true;
        }
        return this.m_findReplace.isEdited();
    }

    public void find() {
        this.m_findReplace.setSelection(this.textModel);
        FindDialog fd = new FindDialog(this.frame, "Find", false, this.m_findReplace);
        try {
            fd.setVisible(true);
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
        }
    }

    public void findSelection() {
        if (this.textModel.isSelected()) {
            this.m_findReplace.setFind(this.textModel.getSelectedText());
            this.m_findReplace.setIndex(this.textModel.getSelectionEnd());
            this.findString();
            return;
        }
        this.findAgain();
    }

    public void findAgain() {
        String str = this.m_findReplace.getFind();
        if (!(str != null && str.length() != 0 || this.m_findReplace.setSelection(this.textModel))) {
            this.find();
            return;
        }
        int index = this.textModel.isSelected() ? this.textModel.getSelectionEnd() : this.textModel.getCaretPosition();
        this.m_findReplace.setIndex(index);
        this.findString();
    }

    public void findString() {
        FindReplaceEngine fre = new FindReplaceEngine(this.m_findReplace);
        fre.FindIt();
        if (!this.m_findReplace.isFoundIt()) {
            Tool.beep();
        }
    }

    public void replace() {
        this.m_findReplace.setSelection(this.textModel);
        try {
            ReplaceDialog rd = new ReplaceDialog(this.frame, "Replace", false, this.m_findReplace);
            rd.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectAll() {
        this.message("Entire text is selected");
        this.area.select(0, this.area.getText().length());
    }

    public void undo() {
        this.textModel.undo();
    }

    public void setTextInfo() {
        int[] t = this.textModel.getLineCol();
        this.TextMessage = "Line " + t[0] + " Column " + t[1] + "    Pos " + this.textModel.getCaretPosition() + "  Size " + this.textModel.size();
    }

    public void setPath(String dir, String fic) {
        this.m_dirName = dir;
        this.m_fileName = fic;
        this.m_pathName = Path.merge(this.m_dirName, this.m_fileName);
    }

    public void changeName() {
        this.TextName = this.m_fileName;
        this.TextDir = this.m_dirName;
        this.TextPath = this.m_pathName;
        this.UpdateDir = this.m_dirName;
        this.setEdited(false);
    }

    public boolean newText() {
        return this.newText("");
    }

    public boolean newText(String info) {
        if (this.savePrevious()) {
            return false;
        }
        this.area.setText(info);
        return true;
    }

    public boolean open() {
        if (this.m_fileName == null) {
            return true;
        }
        if (this.m_pathName == null) {
            this.m_pathName = "";
            this.m_dirName = "";
        }
        this.area.setText("");
        String text = Disk.loadText(this.m_dirName, this.m_fileName);
        int size = text.length();
        if (size > 0) {
            System.gc();
            this.area.setText(text);
            this.area.select(0, 0);
            this.textModel.clearUndo();
            if (this.textModel.size() > 0) {
                this.message(this.m_fileName + " loaded, size " + size + " bytes");
                return true;
            }
            this.message("Enable to display " + this.m_pathName);
        } else {
            this.message("Enable to load " + this.m_pathName);
        }
        return false;
    }

    public boolean close() {
        if (this.isEdited()) {
            DialogCYN cd = new DialogCYN(this.frame, "Saving the text?");
            cd.setVisible(true);
            if (cd.answer == 1) {
                if (this.savePrevious()) {
                    return false;
                }
                if (cd.answer == 2) {
                    return false;
                }
            }
        }
        this.newText();
        return true;
    }

    public void insert() {
        FileDialog openDialog = new FileDialog(this.frame);
        openDialog.setMode(0);
        openDialog.setTitle("Open");
        openDialog.setDirectory(this.m_dirName);
        openDialog.setVisible(true);
        this.insert(openDialog.getDirectory(), openDialog.getFile());
    }

    public void insert(String m_dirName, String m_fileName) {
        if (m_fileName != null) {
            int size;
            if (m_dirName == null) {
                m_dirName = "";
            }
            if ((size = Disk.insert(m_dirName, m_fileName, this.textModel)) > 0) {
                this.message(m_fileName + " loaded and inserted (" + size + " bytes)");
                this.setEdited(true);
            } else {
                this.message("Enable to load " + m_fileName + " from " + m_dirName);
            }
        }
    }

    public boolean cancelled() {
        this.message("Cancelled...");
        return false;
    }

    public boolean saveAs() {
        if (this.TextName.compareTo(NoName) == 0) {
            this.TextName = "";
        }
        FileDialog saveDialog = new FileDialog(this.frame);
        saveDialog.setMode(1);
        saveDialog.setTitle("Save");
        saveDialog.setFile(this.TextName);
        saveDialog.setDirectory(this.m_dirName);
        saveDialog.setVisible(true);
        String dir = saveDialog.getDirectory();
        String name = saveDialog.getFile();
        if (dir == null) {
            return this.cancelled();
        }
        if (name == null) {
            return this.cancelled();
        }
        if (name.length() == 0) {
            return this.cancelled();
        }
        this.setPath(dir, name);
        int size = Disk.saveProtect(this.m_dirName, this.m_fileName, 1, this.area.getText());
        if (size > 0) {
            this.message(this.TextName + " saved as " + this.m_pathName + " " + size + " bytes");
        }
        this.changeName();
        this.sendSource("modified");
        return true;
    }

    public int saveBefore() {
        if (this.isEdited()) {
            DialogCYN QD = new DialogCYN(this.frame, "Text not saved. Save it?");
            QD.setVisible(true);
            if (QD.answer == 2) {
                return 0;
            }
            if (QD.answer == 1) {
                if (!this.save()) {
                    return 0;
                }
                return 1;
            }
        }
        return 2;
    }

    public boolean save() {
        boolean ret;
        if (this.TextName == null) {
            return this.saveAs();
        }
        if (this.TextName.length() == 0) {
            return this.saveAs();
        }
        if (this.TextName.compareTo(NoName) == 0) {
            return this.saveAs();
        }
        int size = Disk.saveProtect(this.TextDir, this.TextName, 1, this.area.getText());
        if (size > 0) {
            this.message(this.TextName + " saved, " + size + " bytes");
            this.setEdited(false);
            this.UpdateDir = this.TextDir;
            this.sendSource("modified");
            ret = true;
        } else {
            this.message("Error, not saved");
            ret = false;
        }
        return ret;
    }

    public boolean savePrevious() {
        if (!this.isEdited()) {
            return false;
        }
        String sname = this.m_fileName;
        String sdir = this.m_dirName;
        boolean res = this.saveBefore() == 0;
        this.setPath(sdir, sname);
        return res;
    }

    public boolean saveBlock() {
        String stext = this.textModel.getSelectedText();
        if (stext.length() == 0) {
            this.dispTip("Select a block of text to save");
            Tool.beep();
            return false;
        }
        FileDialog saveDialog = new FileDialog(this.frame);
        saveDialog.setMode(1);
        saveDialog.setTitle("Save");
        saveDialog.setFile("");
        saveDialog.setDirectory(this.TextDir);
        saveDialog.setVisible(true);
        String BName = saveDialog.getFile();
        String BDir = saveDialog.getDirectory();
        if (BName != null) {
            int size = Disk.saveBlock(BDir, BName, stext);
            if (size > 0) {
                this.UpdateDir = BDir;
                this.message(BName + " saved into " + BDir + " " + size + " bytes");
                this.sendSource("modified");
                return true;
            }
            this.message("Error, not saved");
        }
        return false;
    }

    public void requestFocus() {
        this.area.requestFocus();
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        int keypressed = event.getKeyCode();
        if (!this.isVisible()) {
            return;
        }
        if (event.isAltDown()) {
            switch (keypressed) {
                case 87: {
                    this.saveBlock();
                    event.consume();
                    return;
                }
                case 73: {
                    if (this.Editable) {
                        this.insert();
                    }
                    event.consume();
                    return;
                }
            }
            this.sendKey(event);
            return;
        }
        if (event.isControlDown()) {
            switch (keypressed) {
                case 70: {
                    this.find();
                    event.consume();
                    return;
                }
                case 68: {
                    this.setTextInfo();
                    this.dispTip(this.TextMessage);
                    event.consume();
                    return;
                }
            }
            if (this.Editable) {
                switch (keypressed) {
                    case 83: {
                        this.save();
                        event.consume();
                        return;
                    }
                    case 82: {
                        this.replace();
                        event.consume();
                        return;
                    }
                    case 69: {
                        this.textModel.clearEOL();
                        event.consume();
                        return;
                    }
                    case 89: {
                        this.textModel.clearLine();
                        event.consume();
                        return;
                    }
                    case 90: {
                        this.undo();
                        event.consume();
                        return;
                    }
                }
                return;
            }
        }
        if (keypressed == 114) {
            this.findSelection();
            event.consume();
            return;
        }
        if (event.isActionKey()) {
            this.dispTip("");
            return;
        }
        if (this.Editable) {
            char newc;
            char c;
            if (!this.isEdited()) {
                this.dispTip("");
                this.setEdited(true);
            }
            if ((c = event.getKeyChar()) != (newc = new Character(c).charValue())) {
                event.consume();
            }
            event.setKeyChar(newc);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void addKeyListener(KeyListener k) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, k);
    }

    public void sendKey(KeyEvent event) {
        if (this.keyListener != null) {
            this.keyListener.keyPressed(event);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.sendSource(e.getActionCommand());
    }

    public void sendSource(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }

    public void setMessage(DMessageBar mb) {
        this.messageBar = mb;
    }

    public void setHistory(History h) {
        this.history = h;
    }

    public void dispTip(String str) {
        if (this.messageBar != null) {
            this.messageBar.setText(" " + str);
        }
    }

    public void message(String mess) {
        this.dispTip(mess);
        if (this.history != null) {
            this.history.tell(mess);
        }
    }
}

