/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.TextArea;

public class TextModel {
    TextArea ta;
    String UndoText;
    int UndoPos;
    static String separator = System.getProperty("line.separator");

    public TextModel(TextArea ta) {
        this.ta = ta;
        this.clearUndo();
    }

    public int size() {
        return this.ta.getText().length();
    }

    public int EOLCount(int cursor) {
        int depl = 0;
        String text = this.ta.getText();
        for (int i = 0; i <= cursor; ++i) {
            if (text.charAt(i) != '\n') continue;
            ++depl;
        }
        return depl;
    }

    public void wrapIt(int cols) {
        int len = this.size();
        String text = this.ta.getText();
        int seplen = separator.length();
        int newsize = len + len / cols + 5;
        StringBuffer newtext = new StringBuffer(newsize);
        char sep1 = '\u0000';
        char sep2 = '\u0000';
        try {
            sep1 = separator.charAt(0);
            sep2 = separator.charAt(1);
        }
        catch (Exception se) {
            sep2 = '\u0000';
        }
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            try {
                char c = text.charAt(i);
                newtext.append(c);
                ++pos;
                if (c == sep1 && (text.charAt(i + 1) == sep2 || sep2 == '\u0000')) {
                    pos = 0;
                }
                if (pos < cols) continue;
                for (int j = i; j > 0 && pos > 0; --j, --pos) {
                    if (newtext.charAt(j) != ' ') continue;
                    newtext.insert(j + 1, separator);
                    break;
                }
                pos = 0;
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                e.printStackTrace();
                System.out.println(i + " > " + newsize);
            }
        }
        this.ta.setText(new String(newtext));
    }

    public int getRow() {
        int cursor = this.getCaretPosition();
        String text = this.ta.getText();
        int line = 0;
        for (int i = 0; i < cursor; ++i) {
            if (text.charAt(i) != '\n') continue;
            ++line;
        }
        return line + 1;
    }

    public int getStartOfLine() {
        int cursor = this.getCaretPosition();
        String text = this.ta.getText();
        int stt = 0;
        for (int i = 0; i < cursor; ++i) {
            if (text.charAt(i) != '\n') continue;
            stt = i;
        }
        return stt + 1;
    }

    public int[] getLineCol() {
        int cursor = this.getCaretPosition();
        String text = this.ta.getText();
        int stt = 0;
        int line = 0;
        int[] ret = new int[2];
        for (int i = 0; i < cursor; ++i) {
            if (text.charAt(i) != '\n') continue;
            stt = i;
            ++line;
        }
        ret[0] = line + 1;
        ret[1] = cursor - stt + 1;
        return ret;
    }

    public int countLines() {
        String text = this.ta.getText();
        int lines = 0;
        int i = 0;
        boolean again = true;
        while (again) {
            try {
                if (text.charAt(i++) != '\n') continue;
                ++lines;
            }
            catch (StringIndexOutOfBoundsException e) {
                again = false;
            }
        }
        return lines;
    }

    public int getPosition(int TApos) {
        String text = this.ta.getText();
        int i = 0;
        while (i < TApos) {
            if (text.charAt(i++) != '\n') continue;
            --TApos;
        }
        return TApos;
    }

    public int getCaretPosition() {
        return this.ta.getCaretPosition();
    }

    public int getSelectionStart() {
        return this.ta.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.ta.getSelectionEnd();
    }

    public boolean isSelected() {
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        return end > start;
    }

    public String getSelectedText() {
        int start = this.ta.getSelectionStart();
        int end = this.ta.getSelectionEnd();
        String text = this.ta.getText();
        int i = 0;
        while (i < start) {
            if (text.charAt(i++) != '\n') continue;
            --start;
            --end;
        }
        while (i < end) {
            if (text.charAt(i++) != '\n') continue;
            --end;
        }
        return text.substring(start, end);
    }

    public void setText(String text) {
        this.ta.setText(text);
    }

    public String getText() {
        return this.ta.getText();
    }

    public void insert(String text, int pos) {
        this.ta.insert(text, pos);
    }

    public void insert(String text) {
        this.ta.insert(text, this.getCaretPosition());
    }

    public void replace(String newstr, int start, int end) {
        String text = this.ta.getText();
        int tlen = text.length();
        StringBuffer n = new StringBuffer(tlen + newstr.length());
        n.append(text.substring(0, start));
        n.append(newstr);
        n.append(text.substring(end, tlen));
        this.ta.setText(new String(n));
    }

    public void replace(String newstr) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        this.replace(newstr, start, end);
    }

    public void replaceSelection(String newstr) {
        int start = this.getPosition(this.ta.getSelectionStart());
        int end = this.getPosition(this.ta.getSelectionEnd());
        this.ta.replaceRange(newstr, start, end);
    }

    public int getLastPosition() {
        return this.ta.getText().length() + this.countLines();
    }

    public void remove(int start, int end) {
        this.UndoText = this.getText().substring(start, end + 1);
        this.UndoPos = start;
        this.ta.replaceRange("", start, end);
    }

    public void clearEOL() {
        int j;
        int cursor = this.getCaretPosition();
        String text = this.ta.getText();
        for (j = cursor; j < text.length() && text.charAt(j) != '\n'; ++j) {
        }
        this.remove(cursor, j);
    }

    public void clearLine() {
        int i;
        int cursor = this.getCaretPosition();
        String text = this.ta.getText();
        int j = cursor;
        for (i = cursor; i > 0 && text.charAt(i) != '\n'; --i) {
        }
        while (j < text.length() && text.charAt(j) != '\n') {
            ++j;
        }
        this.remove(i, j);
    }

    public void undo() {
        if (this.UndoText.length() > 0) {
            this.ta.insert(this.UndoText, this.UndoPos);
            this.clearUndo();
        }
    }

    public void clearUndo() {
        this.UndoText = "";
        this.UndoPos = 0;
    }
}

