/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DirBox;
import ae.ListItem;
import ae.Path;
import ae.Preferences;
import ae.VectorLong;
import ae.VectorString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Thumbnail
extends Component {
    boolean bBorder;
    boolean bName;
    boolean bSize;
    boolean bType;
    int imageWidth = Preferences.ThumbWidth;
    int imageHeight;
    int cellWidth = Preferences.ThumbCell;
    int width;
    int height;
    int rowSize;
    int nRows;
    int count;
    String[] names;
    long[] sizes;
    FileWriter fw;
    BufferedWriter bw;
    static int iBorder = 2;
    static String g = "\"";
    public static String htmlFile = "";
    public static String htmlName = "";
    public static String htmlDir = "";

    public Thumbnail(Dimension screen) {
        this.bBorder = Preferences.ThumbBorder;
        this.bName = Preferences.ThumbName;
        this.bSize = Preferences.ThumbSize;
        this.bType = Preferences.ThumbType;
        this.width = screen.width;
        this.height = screen.height;
    }

    public Thumbnail(Dimension screen, String dir, String[] names, long[] sizes) {
        this(screen);
        this.setList(dir, names, sizes);
    }

    public void setList(String dir, String[] n, long[] s) {
        this.names = n;
        this.sizes = s;
        this.count = n.length;
    }

    public Thumbnail(Dimension screen, DirBox d, int start, String dir) {
        this(screen);
        if (d.isSelected() || d.isTagged()) {
            this.setList(dir, d.getSelectedItems(), d.getSelectedSizes());
            return;
        }
        int siz = d.items.size();
        int ctr = 0;
        VectorString vn = new VectorString();
        VectorLong vs = new VectorLong();
        for (int i = start; i < siz; ++i) {
            String ext;
            ListItem li = (ListItem)d.items.elementAt(i);
            String name = li.sText;
            if (new File(dir, name).isDirectory() || !(ext = Path.getExtension(name)).equalsIgnoreCase("gif") && !ext.equalsIgnoreCase("jpg") && !ext.equalsIgnoreCase("bmp") && !ext.equalsIgnoreCase("xbm") && !ext.equalsIgnoreCase("png")) continue;
            vn.addElement(name);
            vs.addElement(d.VSize.elementAt(i));
            ++ctr;
        }
        if (ctr > 0) {
            this.names = new String[ctr];
            vn.copyInto(this.names);
            this.sizes = new long[ctr];
            vs.copyInto(this.sizes);
            this.count = this.names.length;
        }
    }

    public static void setFile(String dir, String name) {
        htmlFile = Path.merge(dir, name);
        htmlDir = dir;
        htmlName = name;
    }

    public String getFile() {
        return htmlFile;
    }

    private void put(String s) {
        try {
            this.bw.write(s, 0, s.length());
            this.bw.newLine();
        }
        catch (IOException i) {
            System.out.println("Enable to write " + s);
        }
    }

    public void resize(Image img) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int originW = img.getWidth(null);
        int originH = img.getHeight(null);
        this.imageHeight = (int)((float)originH * (float)this.imageWidth / (float)originW);
    }

    public void resize(String name) {
        if (new File(name).isDirectory()) {
            return;
        }
        this.resize(this.getToolkit().getImage(name));
    }

    public void createTD(int no) {
        this.resize(this.names[no]);
        this.put("<TD width=" + g + this.cellWidth + g + "><br>");
        if (this.bBorder) {
            this.put("<TABLE border =" + g + iBorder + g + "> <TD>");
        }
        this.put("<A HREF=" + g + this.names[no] + g + "> <IMG SRC=" + g + this.names[no] + g + " WIDTH=" + g + this.imageWidth + g + " HEIGHT=" + g + this.imageHeight + g + " BORDER=" + g + "0" + g + "> </A>");
        if (this.bBorder) {
            this.put("</TD></TABLE>");
        }
        this.put("</TD>");
    }

    public void createTDLabel(int no) {
        try {
            int pos = this.names[no].lastIndexOf(".");
            String node = this.names[no].substring(0, pos);
            this.put("<TD width=" + g + this.cellWidth + g + ">");
            if (this.bName) {
                this.put("<FONT SIZE=" + g + "1" + g + ">");
                this.put("<b> " + node + " </b></FONT>");
            }
            if (this.bType || this.bSize) {
                this.put("<FONT SIZE=" + g + "-3" + g + ">");
                if (this.bType) {
                    this.put("<br>" + this.names[no].substring(pos + 1));
                }
                if (this.bSize) {
                    this.put("<br>" + this.sizes[no]);
                }
                this.put("</FONT>");
            }
            this.put("</TD>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createTR(int start) {
        int no;
        int r;
        this.put("<TR align=" + g + "center" + g + "> ");
        for (r = 0; r < this.rowSize; ++r) {
            no = start + r;
            if (no >= this.count) continue;
            this.createTD(no);
        }
        this.put("</TR>");
        this.put("<TR align=" + g + "center" + g + "> ");
        for (r = 0; r < this.rowSize; ++r) {
            no = start + r;
            if (no >= this.count) continue;
            this.createTDLabel(no);
        }
        this.put("</TR>");
    }

    public int createHtml() {
        int start = 0;
        if (this.count == 0) {
            return 0;
        }
        this.rowSize = Math.max(1, (this.width - 40) / this.cellWidth);
        this.nRows = Math.max(1, (this.count + this.rowSize) / this.rowSize);
        System.gc();
        try {
            this.fw = new FileWriter(htmlFile);
            this.bw = new BufferedWriter(this.fw);
        }
        catch (IOException i) {
            System.out.println("Enable to make " + htmlFile);
        }
        this.put("<HTML>");
        this.put("<HEAD>");
        this.put("<TITLE>Thumbnail</TITLE>");
        this.put("<STYLE TYPE=" + g + "text/css" + g + " MEDIA=screen >");
        this.put("<!--");
        this.put(" BODY { font-family: " + g + "Courrier New" + g + ", Courrier, mono, Monospaced, Arial  }");
        this.put("-->");
        this.put("</STYLE>");
        this.put("</HEAD>");
        if (Preferences.pageColor.equalsIgnoreCase("None")) {
            this.put("<BODY>");
        } else {
            this.put("<BODY bgcolor=" + Preferences.pageColor + ">");
        }
        this.put("<TABLE CELLSPACING=" + g + "4" + g + " CELLPADDING=" + g + "0" + g + " BORDER=" + g + "0" + g + " >");
        for (int r = 0; r < this.nRows; ++r) {
            this.createTR(start);
            start += this.rowSize;
        }
        this.put("</TABLE>");
        this.put("</BODY>");
        this.put("</HTML>");
        try {
            this.bw.close();
        }
        catch (IOException ic) {
            ic.printStackTrace();
        }
        return this.count;
    }
}

