/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Timer
implements Runnable {
    protected int eventType;
    protected boolean repeat;
    protected boolean repeating;
    protected boolean execute;
    protected boolean live;
    protected int delay;
    protected String actionCommand;
    protected ActionListener actionListener = null;
    protected transient Thread thread;

    public Timer() {
        this(1000, false);
    }

    public Timer(int d) {
        this(d, false);
    }

    public Timer(boolean r) {
        this(1000, r);
    }

    public Timer(int d, boolean r) {
        this.delay = d;
        this.repeat = r;
        this.execute = false;
        this.thread = new Thread(this);
    }

    public void setDelay(int d) {
        this.delay = d;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setRepeat(boolean f) {
        this.repeat = f;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void pause() {
        this.execute = false;
    }

    public void start() {
        this.execute = true;
        this.live = true;
        if (this.thread.isAlive()) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void start(int d) {
        this.setDelay(d);
        this.start();
    }

    public void start(boolean r) {
        this.setRepeat(r);
        this.start();
    }

    public void start(int d, boolean r) {
        this.setDelay(d);
        this.setRepeat(r);
        this.start();
    }

    public void stop() {
        this.execute = false;
        this.repeating = false;
        this.live = false;
        this.thread.interrupt();
    }

    public void run() {
        if (!this.execute) {
            this.thread.interrupt();
        }
        try {
            while (this.live) {
                do {
                    this.repeating = this.repeat;
                    Thread.sleep(this.delay);
                    if (!this.execute) continue;
                    this.sourceActionEvent();
                } while (this.repeating && this.live);
                if ((this.execute || !this.live) && this.repeating) continue;
                this.thread.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public static void Delay(int millis) {
        Thread thread = new Thread();
        thread.start();
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        thread.destroy();
    }
}

