/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DTreeNode;
import ae.DTreeView;
import ae.DirIcons;
import ae.OS;
import ae.Path;
import ae.Preferences;
import ae.VectorString;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;

public class TreeDir
extends DTreeView {
    static String letters = "abcdefghijklmnopqrstuvwxyz";
    static VectorString Disks = new VectorString();
    static int maxUnits = 0;

    public TreeDir() {
    }

    public TreeDir(VectorString listOfDrives) {
        this();
        Disks = listOfDrives;
    }

    static void setDisks(String[] dlist) {
        for (int i = 0; i < dlist.length; ++i) {
            Disks.addElement(dlist[i]);
        }
    }

    void driveIdent() {
        if (OS.isWindows()) {
            int i = 0;
            int l = letters.length();
            maxUnits = 0;
            Disks.clear();
            if (!Preferences.FLOPPIES) {
                i = 2;
                l -= i;
            }
            while (i < l) {
                char c = letters.charAt(i);
                String drive = c + ":";
                File test = new File(drive + File.separatorChar);
                if (test.exists()) {
                    Disks.addElement(drive);
                    ++maxUnits;
                }
                ++i;
            }
        }
    }

    void setSub(DTreeNode node, String curDir) {
        String[] l = new File(curDir, File.separator).list();
        int m = l.length;
        for (int i = 0; i < m; ++i) {
            if (!new File(curDir, l[i]).isDirectory()) continue;
            node.isDirectory = true;
            node.isExpandable = true;
            return;
        }
    }

    public void init() {
        if (OS.isWindows()) {
            this.driveIdent();
            for (int i = 0; i < maxUnits; ++i) {
                String disk = Disks.elementAt(i);
                DTreeNode node = new DTreeNode(disk, DirIcons.IconDrive, DirIcons.IconDrive, this);
                this.append(node);
                this.setSub(node, disk);
            }
        } else {
            DTreeNode node = new DTreeNode("/", this);
            this.append(node);
            this.setSub(node, "/");
        }
    }

    protected void complete(DTreeNode node, int x, int y) {
        if (!node.isIncomplete()) {
            return;
        }
        String path = "";
        Dimension s = this.getSize();
        if (x == 0 && y == 0) {
            x = s.width / 3 - 64;
            y = s.height / 2 - 8;
        }
        if (y + 32 > s.height) {
            y -= 48;
        }
        this.setCursor(new Cursor(3));
        for (DTreeNode tNode = node; tNode != null; tNode = tNode.getParent()) {
            path = Path.merge(tNode.getText(), path);
        }
        this.makeBranch(node, path);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void makeBranch(DTreeNode oldNode, String branch) {
        int mode = 0;
        boolean first = true;
        branch = Path.makeJavaRoot(branch);
        for (String fic : new File(branch, File.separator).list()) {
            try {
                if (!new File(branch, fic).isDirectory()) continue;
                DTreeNode newNode = new DTreeNode(fic, DirIcons.IconDir, DirIcons.Expanded, this);
                if (first) {
                    mode = 0;
                    first = false;
                } else {
                    mode = 2;
                }
                this.insert(newNode, oldNode, mode);
                this.setSub(newNode, branch + File.separator + fic);
                oldNode = newNode;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    public String getSelectedPath() {
        String path = "";
        for (DTreeNode node = this.getSelectedNode(); node != null; node = node.getParent()) {
            path = Path.merge(node.getText(), path);
        }
        return path;
    }
}

