/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DButton;
import ae.DMessageBar;
import ae.DToolBar;
import ae.Icons;
import ae.Preferences;
import ae.Style;
import ae.TreeDir;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class TreeManager
extends Panel
implements ActionListener,
ComponentListener,
MouseListener {
    DMessageBar statusbar;
    Frame frame;
    DToolBar toolbar;
    TreeDir treeDir;
    DButton buttonMakeSrc;
    DButton buttonMakeDst;
    DButton buttonBuild;
    boolean started = false;
    transient ActionListener actionListener;

    public TreeManager(Frame f, DMessageBar dmb) {
        this.frame = f;
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this.toolbar = new DToolBar();
        this.add((Component)this.toolbar, "North");
        this.treeDir = new TreeDir();
        this.treeDir.addActionListener(this);
        this.treeDir.addMouseListener(this);
        this.add((Component)this.treeDir, "Center");
        this.buttonMakeSrc = new DButton(Icons.Open, "Source");
        this.buttonMakeSrc.setSize(84, 24);
        this.buttonMakeSrc.setTip("Display selected dir in source window");
        this.buttonMakeSrc.addActionListener(this);
        this.toolbar.add(this.buttonMakeSrc);
        this.buttonMakeDst = new DButton(Icons.Open, "Target");
        this.buttonMakeDst.setSize(84, 24);
        this.buttonMakeDst.setTip("Use the selected dir as target");
        this.buttonMakeDst.addActionListener(this);
        this.toolbar.add(this.buttonMakeDst);
        this.buttonBuild = new DButton(Icons.Cancel, "Rebuild");
        this.buttonBuild.setSize(84, 24);
        this.buttonBuild.setTip("Reload the tree of dirs");
        this.buttonBuild.addActionListener(this);
        this.toolbar.add(this.buttonBuild);
        this.treeDir.setStyle(Preferences.TreeStyle);
    }

    public void init() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.treeDir.init();
    }

    public void setStyle(Style s) {
        this.treeDir.setStyle(s);
    }

    public void message(String message) {
        this.dispTip(message);
    }

    public void dispTip(String message) {
        if (this.statusbar != null) {
            this.statusbar.setText(" " + message);
        }
    }

    public String getSelected() {
        return this.treeDir.getSelectedPath();
    }

    public void rebuild() {
        this.dispTip("Rebuilding the tree");
        this.treeDir.clear();
        this.treeDir.init();
        this.treeDir.repaint();
        this.treeDir.requestFocus();
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        Object object = event.getSource();
        int click = event.getClickCount();
        if (click == 2) {
            this.sendAction("src");
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command;
        Object object = event.getSource();
        if (object == this.buttonMakeSrc) {
            this.sendAction("src");
        } else if (object == this.buttonMakeDst) {
            this.sendAction("dst");
        } else if (object == this.buttonBuild) {
            this.rebuild();
        } else if (object == this.treeDir && (command = event.getActionCommand()).equalsIgnoreCase("enter")) {
            this.sendAction("src");
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void sendAction(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }

    public void componentShown(ComponentEvent e) {
        if (this.treeDir.getViewCount() < 1) {
            this.treeDir.init();
        }
        this.requestFocus();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }
}

