/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DTreeNode;
import ae.DTreeView;
import java.util.Vector;

public class TreeStructure
extends DTreeView {
    public void setTreeStructure(String[] s) {
        if (s == null || s.length == 0) {
            this.clear();
            return;
        }
        this.selectedNode = null;
        this.rootNode = null;
        try {
            this.parseTreeStructure(s);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.triggerRedraw();
        this.invalidate();
    }

    public String[] getTreeStructure() {
        if (this.rootNode == null) {
            return null;
        }
        Vector nodesVector = new Vector(this.count);
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, false, nodesVector);
        int numNodes = nodesVector.size();
        String[] treeStructure = new String[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            DTreeNode thisNode = (DTreeNode)nodesVector.elementAt(i);
            String treeString = "";
            for (int numBlanks = 0; numBlanks < thisNode.depth; ++numBlanks) {
                treeString = treeString + ' ';
            }
            treeStructure[i] = treeString = treeString + thisNode.text;
        }
        return treeStructure;
    }

    protected void parseTreeStructure(String[] tempStructure) throws Exception {
        for (int i = 0; i < tempStructure.length; ++i) {
            int diff;
            String entry = tempStructure[i];
            int indentLevel = this.findLastPreSpace(entry);
            if (indentLevel == -1) {
                throw new Exception("parseTreeStructure: Empty strings in structure.");
            }
            DTreeNode node = this.newTreeNode(entry.trim(), this);
            node.setDepth(indentLevel);
            if (this.rootNode == null) {
                if (indentLevel != 0) {
                    throw new Exception("parseTreeStructure: Indented nodes with no root level node.");
                }
                this.append(node);
                continue;
            }
            DTreeNode currentNode = this.rootNode;
            while (currentNode.sibling != null) {
                currentNode = currentNode.sibling;
            }
            for (int j = 1; j < indentLevel; ++j) {
                int numberOfChildren = currentNode.numberOfChildren;
                DTreeNode tempNode = null;
                if (numberOfChildren > 0) {
                    tempNode = currentNode.child;
                    while (tempNode.sibling != null) {
                        tempNode = tempNode.sibling;
                    }
                }
                if (tempNode == null) break;
                currentNode = tempNode;
            }
            if ((diff = indentLevel - currentNode.getDepth()) > 1) {
                throw new Exception("parseTreeStructure: Generation gap. Node with no immediate parent.");
            }
            if (diff == 1) {
                this.insert(node, currentNode, 0);
                continue;
            }
            this.insert(node, currentNode, 1);
        }
    }

    public void printTree(DTreeNode node) {
        this.printTree(node, false);
    }

    public void printTree(DTreeNode node, boolean isIndented) {
        if (node == null) {
            return;
        }
        String padding = new String();
        if (isIndented) {
            for (int i = 0; i < node.depth; ++i) {
                padding = "  " + padding;
            }
        }
        System.out.println(padding + node.text);
        this.printTree(node.child, isIndented);
        this.printTree(node.sibling, isIndented);
    }

    protected int findLastPreSpace(String s) {
        if (s != null && s.length() > 0) {
            int length = s.length();
            if (s.charAt(0) != ' ' && s.charAt(0) != '\t') {
                return 0;
            }
            for (int i = 1; i < length; ++i) {
                if (s.charAt(i) == ' ' || s.charAt(i) == '\t') continue;
                return i;
            }
        }
        return -1;
    }
}

