/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.util.NoSuchElementException;

public class VectorBoolean {
    public boolean[] elementData;
    public int elementCount;
    protected int capacityIncrement;
    protected int initialCapacity;
    public int index = 0;

    public VectorBoolean(int initialCapacity, int capacityIncrement) {
        this.elementData = new boolean[initialCapacity];
        this.capacityIncrement = capacityIncrement;
        this.initialCapacity = initialCapacity;
    }

    public VectorBoolean(int initialCapacity) {
        this(initialCapacity, 1);
    }

    public VectorBoolean() {
        this(16);
    }

    public void clear() {
        this.elementData = new boolean[this.initialCapacity];
        this.elementCount = 0;
    }

    public final synchronized void copyInto(boolean[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            boolean[] oldData = this.elementData;
            this.elementData = new boolean[this.elementCount];
            VectorBoolean.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            boolean[] oldData = this.elementData;
            int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new boolean[newCapacity];
            VectorBoolean.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final synchronized void setSize(int newSize) {
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = false;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized boolean elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    public final synchronized void setElementAt(boolean obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public final synchronized void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            VectorBoolean.copy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = false;
    }

    public final synchronized void insertElementAt(boolean obj, int index) {
        if (index >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        VectorBoolean.copy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final synchronized void addElement(boolean b) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = b;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = false;
        }
        this.elementCount = 0;
    }

    public static void copy(boolean[] src, boolean[] dst, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i] = src[i];
        }
    }

    public static void copy(boolean[] src, int sdeb, boolean[] dst, int ddeb, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i + ddeb] = src[i + sdeb];
        }
    }

    public void restart() {
        this.index = 0;
    }

    public boolean hasMoreElements() {
        return this.index < this.elementCount;
    }

    public boolean nextElement() {
        if (this.index < this.elementCount) {
            return this.elementData[this.index++];
        }
        throw new NoSuchElementException("BooleanEnumerator");
    }
}

