/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.util.NoSuchElementException;

public class VectorInt {
    public int[] elementData;
    public int elementCount;
    protected int capacityIncrement;
    public int index = 0;

    public VectorInt(int initialCapacity, int capacityIncrement) {
        this.elementData = new int[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public VectorInt(int initialCapacity) {
        this(initialCapacity, 1);
    }

    public VectorInt() {
        this(16);
    }

    public final synchronized void copyInto(int[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            int[] oldData = this.elementData;
            this.elementData = new int[this.elementCount];
            VectorInt.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            int[] oldData = this.elementData;
            int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            VectorInt.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final synchronized void setSize(int newSize) {
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = 0;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(int elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(int elem) {
        return this.indexOf(elem, 0);
    }

    public final synchronized int indexOf(int elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(int elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(int elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized int elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    public final synchronized int firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized int lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(int val, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = val;
    }

    public final synchronized void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            VectorInt.copy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = 0;
    }

    public final synchronized void insertElementAt(int obj, int index) {
        if (index >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        VectorInt.copy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final synchronized void addElement(int val) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = val;
    }

    public final synchronized boolean removeElement(int obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = 0;
        }
        this.elementCount = 0;
    }

    public final synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            buf.append(new Integer(this.elementData[i]).toString());
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public static void copy(int[] src, int[] dst, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i] = src[i];
        }
    }

    public static void copy(int[] src, int sdeb, int[] dst, int ddeb, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i + ddeb] = src[i + sdeb];
        }
    }

    public void restart() {
        this.index = 0;
    }

    public boolean hasMoreElements() {
        return this.index < this.elementCount;
    }

    public int nextElement() {
        if (this.index < this.elementCount) {
            return this.elementData[this.index++];
        }
        throw new NoSuchElementException("IntEnumerator");
    }
}

