/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.util.NoSuchElementException;

public class VectorLong {
    public long[] elementData;
    public int elementCount;
    public int capacityIncrement;
    public int index = 0;

    public VectorLong(int initialCapacity, int capacityIncrement) {
        this.elementData = new long[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public VectorLong(int initialCapacity) {
        this(initialCapacity, 1);
    }

    public VectorLong() {
        this(16);
    }

    public final synchronized void copyInto(long[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final synchronized void trimToSize() {
        long oldCapacity = this.elementData.length;
        if ((long)this.elementCount < oldCapacity) {
            long[] oldData = this.elementData;
            this.elementData = new long[this.elementCount];
            VectorLong.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            long[] oldData = this.elementData;
            int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new long[newCapacity];
            VectorLong.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final synchronized void setSize(int newSize) {
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = 0L;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(long elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(long elem) {
        return this.indexOf(elem, 0);
    }

    public final synchronized int indexOf(long elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(long elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(long elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final synchronized long elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    public final synchronized long firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized long lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(long obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public final synchronized void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            VectorLong.copy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = 0L;
    }

    public final synchronized void insertElementAt(long obj, int index) {
        if (index >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        VectorLong.copy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final synchronized void addElement(long obj) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = obj;
    }

    public final synchronized boolean removeElement(long obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = 0L;
        }
        this.elementCount = 0;
    }

    public final synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            buf.append(new Long(this.elementData[i]).toString());
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void copyFrom(long[] src) {
        for (long this.elementData[i] : src) {
        }
    }

    public void copyFrom(VectorLong src) {
        int l = src.size();
        for (int i = 0; i < l; ++i) {
            this.elementData[i] = src.elementAt(i);
        }
    }

    public static void copy(long[] src, long[] dst, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i] = src[i];
        }
    }

    public static void copy(long[] src, int sdeb, long[] dst, int ddeb, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i + ddeb] = src[i + sdeb];
        }
    }

    public void restart() {
        this.index = 0;
    }

    public boolean hasMoreElements() {
        return this.index < this.elementCount;
    }

    public long nextElement() {
        if (this.index < this.elementCount) {
            return this.elementData[this.index++];
        }
        throw new NoSuchElementException("LongEnumerator");
    }
}

