/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Sort;
import ae.SortDir;
import java.util.NoSuchElementException;

public class VectorString {
    public String[] elementData;
    public int elementCount;
    public int capacityIncrement;
    public int initialCapacity;
    boolean separeDrives = false;
    public int index = 0;

    public VectorString(int initialCapacity, int cI) {
        this.elementData = new String[initialCapacity];
        this.capacityIncrement = cI;
        this.initialCapacity = initialCapacity;
    }

    public VectorString(int initialCapacity) {
        this(initialCapacity, 1);
    }

    public VectorString() {
        this(16);
    }

    public void clear() {
        this.elementData = new String[this.initialCapacity];
        this.elementCount = 0;
    }

    public final synchronized void copyInto(String[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final synchronized void copyInto(VectorString vs) {
        int i = this.elementCount;
        vs.setSize(i);
        for (int j = 0; j < i; ++j) {
            vs.addElement(this.elementData[j]);
        }
    }

    public final synchronized String[] toArray() {
        String[] dst = new String[this.elementCount];
        System.arraycopy(this.elementData, 0, dst, 0, this.elementCount);
        return dst;
    }

    public final synchronized String[] getArray() {
        return this.elementData;
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            String[] oldData = this.elementData;
            this.elementData = new String[this.elementCount];
            VectorString.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            String[] oldData = this.elementData;
            int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new String[newCapacity];
            VectorString.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final synchronized void setSize(int newSize) {
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final boolean contains(String elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(String elem) {
        return this.indexOf(elem, 0);
    }

    public final synchronized int indexOf(String elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(String elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(String elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (!elem.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public final synchronized String elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    public final synchronized String firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized String lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(String s, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = s;
    }

    public final synchronized void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            VectorString.copy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final synchronized void insertElementAt(String obj, int index) {
        if (index >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        VectorString.copy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public final synchronized void addElement(String s) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = s;
    }

    public final synchronized void addElement(StringBuffer sb) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = new String(sb);
    }

    public final synchronized boolean addUnicElement(String s) {
        int i = 0;
        while (i < this.elementCount) {
            if (!s.equalsIgnoreCase(this.elementData[i++])) continue;
            return false;
        }
        this.addElement(s);
        return true;
    }

    public final synchronized boolean removeElement(String obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public final synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            buf.append(this.elementAt(i));
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public int compare(int ia, int ib) {
        return this.elementData[ia].compareTo(this.elementData[ib]);
    }

    void swap(int a, int b) {
        String s = this.elementData[a];
        this.elementData[a] = this.elementData[b];
        this.elementData[b] = s;
    }

    int sortCompare(int a, int b) {
        String sa = this.elementData[a];
        String sb = this.elementData[b];
        if (this.separeDrives) {
            boolean bunit;
            boolean aunit = sa.charAt(1) == ':' && sa.length() == 2;
            boolean bl = bunit = sb.charAt(1) == ':' && sb.length() == 2;
            if (aunit != bunit) {
                if (aunit) {
                    return -1;
                }
                return 1;
            }
        }
        return Sort.superCompare(sa, sb);
    }

    public int separeDrives() {
        return SortDir.separeDrives(this.elementData, 0, this.elementCount);
    }

    public void sort(boolean separe) {
        this.sort(0, this.size(), separe);
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public void sort(int s, int l, boolean separe) {
        this.separeDrives = true;
        this.sort(s, l);
        this.separeDrives = false;
    }

    public void sort(int start, int limit) {
        if (limit <= start) {
            return;
        }
        int j = start;
        int i = j + 1;
        while (i < limit) {
            while (j >= start && this.sortCompare(j, j + 1) > 0) {
                this.swap(j, j + 1);
                --j;
            }
            j = i++;
        }
    }

    public static void copy(String[] src, String[] dst, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i] = src[i];
        }
    }

    public static void copy(String[] src, int sdeb, String[] dst, int ddeb, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i + ddeb] = src[i + sdeb];
        }
    }

    public void restart() {
        this.index = 0;
    }

    public boolean hasMoreElements() {
        return this.index < this.elementCount;
    }

    public String nextElement() {
        if (this.index < this.elementCount) {
            return this.elementData[this.index++];
        }
        throw new NoSuchElementException("StringEnumerator");
    }
}

