/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Orient;

public class Vertex {
    double x;
    double y;
    double z;
    double u;
    double v;

    public Vertex() {
        this(0.0, 0.0, 0.0);
    }

    public Vertex(double x, double y, double z) {
        this(x, y, z, (int)x, (int)y);
    }

    public Vertex(double x, double y, double z, double u, double v) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
    }

    public Vertex(Vertex v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.u = v.u;
        this.v = v.v;
    }

    public void rotate(Orient o1) {
        double nx = this.x * o1.yaw.cosine - this.z * o1.yaw.sine;
        double ny = this.y;
        double nz = this.x * o1.yaw.sine + this.z * o1.yaw.cosine;
        double x = nx;
        double y = o1.pitch.cosine * ny + -o1.pitch.sine * nz;
        double z = o1.pitch.sine * ny + o1.pitch.cosine * nz;
        this.x = x * o1.roll.cosine + y * o1.roll.sine;
        this.y = -x * o1.roll.sine + y * o1.roll.cosine;
        this.z = z;
    }

    public void translate(Vertex v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public Vertex negative() {
        return new Vertex(-this.x, -this.y, -this.z);
    }

    public double dotproduct(Vertex b) {
        return this.x * b.x + this.y * b.y + this.z * b.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public String toString() {
        return "Vertex [" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

