/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Light;
import ae.Texture;
import ae.Vertex;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Virtual3d
extends Component {
    static Component parent;
    protected int width = 0;
    protected int height = 0;
    protected int midwidth;
    protected int midheight;
    protected Light light;
    protected MemoryImageSource screenMem;
    protected int[] screenPixel;
    private int prec = 4;
    protected int tWidth;
    protected int tHeight;

    public Virtual3d(Component parent, int width, int height) {
        Virtual3d.parent = parent;
        this.width = width;
        this.height = height;
        this.midwidth = width / 2;
        this.midheight = height / 2;
        this.screenPixel = new int[width * height];
        this.screenMem = new MemoryImageSource(width, height, this.screenPixel, 0, width);
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public Image getImage() {
        return parent.createImage(this.screenMem);
    }

    public void clear() {
        for (int i = 0; i < this.screenPixel.length; ++i) {
            this.screenPixel[i] = -1;
        }
    }

    public void fillPoly(Vertex[] p, int plength, Vertex normal, Texture texture) {
        int high = 0;
        double highLevel = p[0].y / p[0].z;
        for (int i = 1; i < plength; ++i) {
            if (!(p[i].y / p[i].z > highLevel)) continue;
            highLevel = p[i].y / p[i].z;
            high = i;
        }
        boolean newOnLeft = false;
        Vertex topLeft = p[high];
        Vertex topRight = p[high];
        int leftCount = high - 1;
        int rightCount = high + 1;
        if (leftCount < 0) {
            leftCount = plength - 1;
        }
        if (rightCount > plength - 1) {
            rightCount = 0;
        }
        while (leftCount != rightCount) {
            Vertex bottom;
            Vertex middle;
            Vertex top;
            if (p[leftCount].y / p[leftCount].z > p[rightCount].y / p[rightCount].z) {
                newOnLeft = false;
                top = topRight;
                middle = p[leftCount];
                bottom = p[rightCount];
            } else {
                newOnLeft = true;
                top = topLeft;
                middle = p[rightCount];
                bottom = p[leftCount];
            }
            double num = bottom.y * middle.z - middle.y * bottom.z;
            double den = middle.y * (top.z - bottom.z) + middle.z * (bottom.y - top.y);
            Vertex newVert = new Vertex(bottom.x + (top.x - bottom.x) * num / den, bottom.y + (top.y - bottom.y) * num / den, bottom.z + (top.z - bottom.z) * num / den, bottom.u + (double)((int)((top.u - bottom.u) * num / den)), bottom.v + (double)((int)((top.v - bottom.v) * num / den)));
            if (newOnLeft) {
                this.renderTrap(p[rightCount], newVert, topRight, topLeft, texture);
                topRight = p[rightCount];
                topLeft = newVert;
                if (++rightCount <= plength - 1) continue;
                rightCount = 0;
                continue;
            }
            this.renderTrap(newVert, p[leftCount], topRight, topLeft, texture);
            topRight = newVert;
            topLeft = p[leftCount];
            if (--leftCount >= 0) continue;
            leftCount = plength - 1;
        }
        this.renderTrap(p[rightCount], p[rightCount], topRight, topLeft, texture);
    }

    public void renderTrap(Vertex p0, Vertex p1, Vertex p2, Vertex p3, Texture texture) {
        int mw = this.midwidth;
        int mh = this.midheight;
        double maxz = p0.z;
        if (p2.z > maxz) {
            maxz = p2.z;
        }
        int w = this.width;
        int h = (int)((double)mw * p2.y / p2.z);
        int h1 = (int)((double)mw * p1.y / p1.z);
        int prec = 8;
        int[] texel = texture.texels;
        int iw = texture.iWidth;
        int ih = texture.iHeight;
        int iwl = iw << prec;
        int ihl = ih << prec;
        int p0x = (int)(p0.x * (double)(1 << prec)) + 1;
        int p0y = (int)(p0.y * (double)(1 << prec));
        int p0z = (int)(p0.z * (double)(1 << prec));
        int p0u = (int)(p0.u * (double)(1 << prec));
        int p0v = (int)(p0.v * (double)(1 << prec));
        int p1x = (int)(p1.x * (double)(1 << prec)) - 1;
        int p1y = (int)(p1.y * (double)(1 << prec));
        int p1z = (int)(p1.z * (double)(1 << prec));
        if (p1z == 0) {
            p1z = 1;
        }
        int p1u = (int)(p1.u * (double)(1 << prec));
        int p1v = (int)(p1.v * (double)(1 << prec));
        int p2x = (int)(p2.x * (double)(1 << prec)) + 1;
        int p2y = (int)(p2.y * (double)(1 << prec));
        int p2z = (int)(p2.z * (double)(1 << prec));
        if (p2z == 0) {
            p2z = 1;
        }
        int p2u = (int)(p2.u * (double)(1 << prec));
        int p2v = (int)(p2.v * (double)(1 << prec));
        int p3x = (int)(p3.x * (double)(1 << prec)) - 1;
        int p3y = (int)(p3.y * (double)(1 << prec));
        int p3z = (int)(p3.z * (double)(1 << prec));
        if (p3z == 0) {
            p3z = 1;
        }
        int p3u = (int)(p3.u * (double)(1 << prec));
        int p3v = (int)(p3.v * (double)(1 << prec));
        int[] sp = this.screenPixel;
        int A0 = p0z;
        int B0 = mw * p0y;
        int C0 = p0z - p2z;
        int D0 = mw * (p2y - p0y);
        int num0 = mw * p0y - B0;
        int den0 = C0 * (mw * p0y / A0) + D0;
        int A1 = p1z;
        int B1 = mw * p1y;
        int C1 = p1z - p3z;
        int D1 = mw * (p3y - p1y);
        int num1 = mw * p1y - B1;
        int den1 = C1 * (mw * p1y / A1) + D1;
        int p31x = p3x - p1x;
        int p31y = p3y - p1y;
        int p31z = p3z - p1z;
        int p31u = p3u - p1u;
        int p31v = p3v - p1v;
        int p20x = p2x - p0x;
        int p20y = p2y - p0y;
        int p20z = p2z - p0z;
        int p20u = p2u - p0u;
        int p20v = p2v - p0v;
        while (h1++ < h) {
            int vs;
            int us;
            int psz;
            int psx;
            int ve;
            int ue;
            int pez;
            int pex;
            if (den0 != 0) {
                pex = p0x + (int)((long)p20x * (long)num0 / (long)den0);
                pez = p0z + (int)((long)p20z * (long)num0 / (long)den0);
                ue = p0u + (int)((long)p20u * (long)num0 / (long)den0);
                ve = p0v + (int)((long)p20v * (long)num0 / (long)den0);
            } else {
                pex = p2x;
                int pey = p2y;
                pez = p2z;
                ue = p2u;
                ve = p2v;
            }
            if (den1 != 0) {
                psx = p1x + (int)((long)p31x * (long)num1 / (long)den1);
                psz = p1z + (int)((long)p31z * (long)num1 / (long)den1);
                us = p1u + (int)((long)p31u * (long)num1 / (long)den1);
                vs = p1v + (int)((long)p31v * (long)num1 / (long)den1);
            } else {
                psx = p3x;
                int psy = p3y;
                psz = p3z;
                us = p3u;
                vs = p3v;
            }
            int sx0 = mw * psx / psz - 1;
            int sy0 = h1;
            int sx1 = mw * pex / pez + 1;
            if (sy0 > -mh && sy0 < mh && psz > 0 && pez > 0) {
                if (sx0 <= -mw) {
                    sx0 = -mw + 1;
                } else if (sx0 >= mw) {
                    sx0 = mw - 1;
                }
                if (sx1 <= -mw) {
                    sx1 = -mw + 1;
                } else if (sx1 >= mw) {
                    sx1 = mw - 1;
                }
                int zdiff = psz - pez;
                int num = -psz;
                int den = mw * (zdiff * psx / psz + pex - psx) - zdiff;
                int u = 0;
                int v = 0;
                int uLength = ue - us;
                int vLength = ve - vs;
                int p = (mh - sy0) * w + sx0 + mw;
                if (den != 0) {
                    int abrashVInc;
                    int abrashUInc;
                    int innerLimit2;
                    int abrashShift = 4;
                    if (zdiff == 0 && sx1 - sx0 > (mw << 1) - 10 && mw > 128) {
                        abrashShift = prec;
                    }
                    int abrashU = us;
                    int abrashV = vs;
                    int innerLimit1 = sx1 - sx0 >> abrashShift;
                    int pszl = psz << abrashShift;
                    int zdiffl = zdiff << abrashShift;
                    if (zdiff == 0) {
                        innerLimit2 = 1 << abrashShift - 4;
                        int fastU = (int)((long)uLength * (long)pszl / (long)den);
                        int fastV = (int)((long)vLength * (long)pszl / (long)den);
                        for (int sxi = 0; sxi < innerLimit1; ++sxi) {
                            u = abrashU;
                            v = abrashV;
                            abrashUInc = (abrashU += fastU) - u >> abrashShift;
                            abrashVInc = (abrashV += fastV) - v >> abrashShift;
                            for (int sxj = 0; sxj < innerLimit2; ++sxj) {
                                for (int roll = 0; roll < 16; ++roll) {
                                    if ((u = (u + abrashUInc) % iwl) < 0) {
                                        u += iwl;
                                    }
                                    if ((v = (v + abrashVInc) % ihl) < 0) {
                                        v += ihl;
                                    }
                                    sp[p++] = texel[(v >> prec) * iw + (u >> prec)];
                                }
                            }
                        }
                        num += pszl * innerLimit1;
                        int innerLimit3 = sx1 - sx0 - (innerLimit1 << abrashShift);
                        fastU >>= abrashShift;
                        fastV >>= abrashShift;
                        for (int sxi = 0; sxi < innerLimit3; ++sxi) {
                            if ((u = (u + fastU) % iwl) < 0) {
                                u += iwl;
                            }
                            if ((v = (v + fastV) % ihl) < 0) {
                                v += ihl;
                            }
                            sp[p++] = texel[(v >> prec) * iw + (u >> prec)];
                        }
                    } else {
                        innerLimit2 = 1 << abrashShift - 4;
                        for (int sxi = 0; sxi < innerLimit1; ++sxi) {
                            u = abrashU;
                            v = abrashV;
                            abrashU = us + (int)((long)uLength * (long)(num += pszl) / (long)(den += zdiffl));
                            abrashV = vs + (int)((long)vLength * (long)num / (long)den);
                            abrashUInc = (abrashU - u >> abrashShift) + iwl;
                            abrashVInc = (abrashV - v >> abrashShift) + ihl;
                            for (int sxj = 0; sxj < innerLimit2; ++sxj) {
                                for (int roll = 0; roll < 16; ++roll) {
                                    int n = p++;
                                    v = (v + abrashVInc) % ihl;
                                    u = (u + abrashUInc) % iwl;
                                    sp[n] = texel[(v >> prec) * iw + (u >> prec)];
                                }
                            }
                        }
                        int innerLimit3 = sx1 - sx0 - (innerLimit1 << abrashShift);
                        for (int sxi = 0; sxi < innerLimit3; ++sxi) {
                            if ((den += zdiff) != 0) {
                                u = (us + (int)((long)uLength * (long)(num += psz) / (long)den)) % iwl;
                                if (u < 0) {
                                    u += iwl;
                                }
                                if ((v = (vs + (int)((long)vLength * (long)num / (long)den)) % ihl) < 0) {
                                    v += ihl;
                                }
                            }
                            sp[p++] = texel[(v >> prec) * iw + (u >> prec)];
                        }
                    }
                }
            }
            num0 += A0;
            den0 += C0;
            num1 += A1;
            den1 += C1;
        }
    }
}

