/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.VirtualDirect;

public class VirtualBig
extends VirtualDirect {
    int SQUARE = 3;
    VirtualDirect real;

    public VirtualBig(VirtualDirect vd) {
        this.real = vd;
    }

    public VirtualBig(VirtualDirect vd, int w, int h) {
        this(vd);
        this.setSize(w, h);
    }

    public VirtualBig(VirtualDirect vd, int[] iArray, int w, int h) {
        super(iArray, w, h);
        this.real = vd;
    }

    public VirtualBig(int w, int h) {
        this.real = null;
        super.setSize(w, h);
    }

    public void setSize(VirtualDirect vd, int w, int h) {
        super.setSize(w, h);
        this.real = vd;
    }

    public void setBase(VirtualDirect vd) {
        this.setSize(vd, vd.width * this.SQUARE, vd.height * this.SQUARE);
    }

    public void setSquare(int square) {
        switch (square) {
            case 5: {
                this.SQUARE = 5;
                break;
            }
            case 7: {
                this.SQUARE = 7;
                break;
            }
            default: {
                this.SQUARE = 3;
            }
        }
    }

    public void pixel(int x, int y, int color) {
        this.COLOR = color;
        this.pixel(x, y);
    }

    public void pixel(int x, int y) {
        y = this.real.height - y - 1;
        if (x < 0) {
            return;
        }
        if (x >= this.width) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.height) {
            return;
        }
        switch (this.SQUARE) {
            case 5: {
                this.set5(x, y);
                break;
            }
            case 7: {
                this.set7(x, y);
                break;
            }
            default: {
                this.set3(x, y);
            }
        }
    }

    public void set3(int x, int y) {
        int yo = y;
        y = y * this.width * 3;
        x *= 3;
        try {
            this.screen[y + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int index = y + x;
            this.error("Error Pixelx3 - x:" + x + "/" + this.width + " y:" + yo * 3 + "/" + this.height + " Index: " + index + "/" + this.screen.length);
        }
    }

    public void set5(int x, int y) {
        y = y * this.width * 5;
        x *= 5;
        try {
            this.screen[y + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int index = y + x;
            this.error("Error Pixelx5 - x:" + x + "/" + this.width + " y:" + y / this.width + "/" + this.height + " Index: " + index + "/" + this.screen.length);
        }
    }

    public void set7(int x, int y) {
        y = y * this.width * 7;
        x *= 7;
        try {
            this.screen[y + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[y + x + 5] = this.COLOR;
            this.screen[y + x + 6] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[y + x + 5] = this.COLOR;
            this.screen[y + x + 6] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[y + x + 5] = this.COLOR;
            this.screen[y + x + 6] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[y + x + 5] = this.COLOR;
            this.screen[y + x + 6] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[y + x + 5] = this.COLOR;
            this.screen[y + x + 6] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[y + x + 5] = this.COLOR;
            this.screen[y + x + 6] = this.COLOR;
            this.screen[(y += this.width) + x] = this.COLOR;
            this.screen[y + x + 1] = this.COLOR;
            this.screen[y + x + 2] = this.COLOR;
            this.screen[y + x + 3] = this.COLOR;
            this.screen[y + x + 4] = this.COLOR;
            this.screen[y + x + 5] = this.COLOR;
            this.screen[y + x + 6] = this.COLOR;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int index = y + x;
            this.error("Error Pixelx7 - x:" + x + "/" + this.width + " y:" + y / this.width + "/" + this.height + " Index: " + index + "/" + this.screen.length);
        }
    }

    public void update(int x, int y) {
        this.pixel(x, y, this.real.getPixel(x, y));
    }

    public void update() {
        if (this.screen == null) {
            this.error("VirtualBig update - screen null");
            return;
        }
        if (this.real == null) {
            this.error("VirtualBig update - real null " + this.real.width + "x" + this.real.height);
            return;
        }
        int w = this.real.width;
        int h = this.real.height;
        if (this.SQUARE == 3) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    this.COLOR = this.real.screen[y * w + x];
                    this.set3(x, y);
                }
            }
        } else if (this.SQUARE == 5) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    this.COLOR = this.real.screen[y * w + x];
                    this.set5(x, y);
                }
            }
        } else {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    this.COLOR = this.real.screen[y * w + x];
                    this.set7(x, y);
                }
            }
        }
    }

    public void copy(VirtualBig clone) {
        int size = this.width * this.height;
        for (int i = 0; i < size; ++i) {
            clone.screen[i] = this.screen[i];
        }
    }
}

