/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class VirtualImage
extends Component {
    static Toolkit toolkit = Toolkit.getDefaultToolkit();
    Image image = null;
    int width;
    int height;

    public boolean load(Image img) {
        this.image = img;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 0);
        try {
            tracker.waitForAll();
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public int[] getPixels() {
        return VirtualImage.getPixels(this.image, this.width, this.height);
    }

    public static int[] getPixels(Image image) {
        return VirtualImage.getPixels(image, image.getWidth(null), image.getHeight(null));
    }

    public static int[] getPixels(Image image, int w, int h) {
        if (image == null) {
            System.out.println("VirtualImage - Image null");
            return null;
        }
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.out.println("Error, image fetch stopped");
            return null;
        }
        return pixels;
    }

    public static Image getImage(int[] pixels, int width, int height) {
        MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
        return toolkit.createImage(mis);
    }
}

