/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.PalettePanel;
import ae.PaletteShaded;
import ae.VirtualDirect;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageConsumer;
import java.awt.image.MemoryImageSource;

public class VirtualScreen {
    int[] screen;
    MemoryImageSource mis;
    int width = 0;
    int height = 0;
    int size = 0;
    int COLOR = 0;
    int SCREEN_WIDTH = 640;
    int SCREEN_HEIGHT = 400;
    static PaletteShaded palette;
    static Toolkit toolkit;
    int OLDFILL;
    int fillcounter;

    public VirtualScreen() {
        toolkit = Toolkit.getDefaultToolkit();
        Dimension d = toolkit.getScreenSize();
        this.SCREEN_WIDTH = d.width;
        this.SCREEN_HEIGHT = d.height;
        palette = new PaletteShaded();
    }

    public VirtualScreen(int w, int h) {
        this();
        this.setSize(w, h);
    }

    public VirtualScreen(int[] iArray, int w, int h) {
        this();
        this.setScreen(iArray, w, h);
    }

    public boolean error(String s) {
        System.out.println(s);
        return false;
    }

    public void setSize(int w, int h) {
        this.screen = new int[w * h];
        this.width = w;
        this.height = h;
        this.size = w * h;
    }

    public void setScreen(int[] newscreen, int w, int h) {
        this.screen = newscreen;
        this.width = w;
        this.height = h;
        this.size = w * h;
    }

    public int getSize() {
        return this.width * this.height;
    }

    Dimension getDimensions() {
        return new Dimension(this.width, this.height);
    }

    public void setTexels(int[] t, int ow, int oh) {
        int i = 0;
        int j = 0;
        int idx = 0;
        try {
            for (j = 0; j < oh; ++j) {
                for (i = 0; i < ow; ++i) {
                    this.screen[j * this.width + i] = t[idx++];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            System.out.println("Virtual setTextels " + i + "x" + j);
        }
    }

    public void copy(VirtualScreen dst) {
        int dw = Math.min(dst.width, this.width);
        int dh = Math.min(dst.height, this.height);
        int i = 0;
        int j = 0;
        try {
            for (j = 0; j < dh; ++j) {
                for (i = 0; i < dw; ++i) {
                    dst.screen[j * dst.width + i] = this.screen[j * this.width + i];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            System.out.println("Virtual copy " + i + "x" + j);
        }
    }

    public void copyArea(VirtualDirect dst, int x, int y, int w, int h, int dx, int dy) {
        int i = 0;
        int j = 0;
        try {
            for (j = 0; j < h; ++j) {
                int ny = y + dy + j;
                if (ny >= this.height) continue;
                for (i = 0; i < w; ++i) {
                    int nx = x + dx + i;
                    int noff = ny * this.width + nx;
                    if (nx >= this.width || noff >= this.size) continue;
                    dst.screen[noff] = this.screen[(y + j) * this.width + x + i];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException a) {
            System.out.println("Virtual copy " + i + "x" + j);
        }
    }

    void clear(int color) {
        int i = this.getSize() - 1;
        while (i >= 0) {
        }
        this.screen[i--] = color;
    }

    void setColor(int c) {
        this.COLOR = c;
    }

    public void pixel(int x, int y) {
        if (x < 0) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (x >= this.width) {
            return;
        }
        if (y >= this.height) {
            return;
        }
        try {
            this.screen[(this.height - 1 - y) * this.width + x] = this.COLOR;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.error("Pixel x:" + x + "/" + this.width + " y:" + y + "/" + this.height);
        }
    }

    public void pixel(int x, int y, int color) {
        this.COLOR = color;
        this.pixel(x, y);
    }

    int getPixel(int x, int y) {
        if (x < 0) {
            return 0;
        }
        if (y < 0) {
            return 0;
        }
        if (x >= this.width) {
            return 0;
        }
        if (y >= this.height) {
            return 0;
        }
        try {
            return this.screen[(this.height - 1 - y) * this.width + x];
        }
        catch (ArrayIndexOutOfBoundsException a) {
            this.error("getPixel error - x:" + x + "/" + this.width + " y:" + y + "/" + this.height);
            return 0;
        }
    }

    void tbLine(int x, int y, int x2, int y2) {
        this.line(x, this.height - y, x2, this.height - y2);
    }

    void line(int x, int y, int x2, int y2, int c) {
        this.COLOR = c;
        this.line(x, y, x2, y2);
    }

    void line(int x, int y, int x2, int y2) {
        int sy;
        boolean steep = false;
        int dx = Math.abs(x2 - x);
        int sx = x2 - x > 0 ? 1 : -1;
        int dy = Math.abs(y2 - y);
        int n = sy = y2 - y > 0 ? 1 : -1;
        if (dy > dx) {
            steep = true;
            x ^= y;
            y ^= x;
            x ^= y;
            dx ^= dy;
            dy ^= dx;
            dx ^= dy;
            sx ^= sy;
            sy ^= sx;
            sx ^= sy;
        }
        int e = 2 * dy - dx;
        for (int i = 0; i < dx; ++i) {
            if (steep) {
                this.pixel(y, x);
            } else {
                this.pixel(x, y);
            }
            while (e >= 0) {
                y += sy;
                e -= 2 * dx;
            }
            x += sx;
            e += 2 * dy;
        }
        this.pixel(x2, y2);
    }

    void circle(int xc, int yc, int r, int c) {
        this.COLOR = c;
        this.circle(xc, yc, r);
    }

    void circle(int xc, int yc, int r) {
        int x = 0;
        int y = r;
        int d = 2 * (1 - r);
        while (y > 0) {
            this.pixel(xc + x, yc + y);
            this.pixel(xc + x, yc - y);
            this.pixel(xc - x, yc + y);
            this.pixel(xc - x, yc - y);
            if (d + y > 0) {
                d -= 2 * --y * this.SCREEN_WIDTH / this.SCREEN_HEIGHT - 1;
            }
            if (x <= d) continue;
            d += 2 * ++x + 1;
        }
    }

    void ellipse(int xc, int yc, int r, int r2, int c) {
        this.COLOR = c;
        this.ellipse(xc, yc, r, r2);
    }

    void ellipse(int xc, int yc, int r2, int r) {
        int x = 0;
        int y = r;
        int d = 2 * (1 - r);
        while (y > 0) {
            this.pixel(xc + x, yc + y);
            this.pixel(xc + x, yc - y);
            this.pixel(xc - x, yc + y);
            this.pixel(xc - x, yc - y);
            try {
                if (d + y > 0) {
                    d -= 2 * --y * r2 - 1;
                }
                if (x <= d) continue;
                d += 2 * ++x + 1;
            }
            catch (Exception e) {}
        }
    }

    void hLine(int x, int y, int xr, int c) {
        this.COLOR = c;
        this.hLine(x, y, xr);
    }

    void hLine(int x, int y, int r) {
        if (x > r) {
            int t = x;
            x = r;
            r = t;
        }
        while (x <= r) {
            this.pixel(x++, y);
        }
    }

    void vLine(int x, int y, int y2, int c) {
        this.COLOR = c;
        this.vLine(x, y, y2);
    }

    void vLine(int x, int y, int y2) {
        if (y2 < y) {
            int temp = y;
            y = y2;
            y2 = temp;
        }
        while (y <= y2) {
            this.pixel(x, y++);
        }
    }

    void rectangle(int x, int y, int x2, int y2, int col) {
        this.COLOR = col;
        this.rectangle(x, y, x2, y2);
    }

    void rectangle(int x, int y, int x2, int y2) {
        this.hLine(x, y, x2);
        this.hLine(x, y2, x2);
        this.vLine(x, y, y2);
        this.vLine(x2, y, y2);
    }

    void fillRect(int x, int b, int r, int t, int col) {
        this.COLOR = col;
        this.fillRect(x, b, r, t);
    }

    void fillRect(int x, int b, int r, int t) {
        if (t < b) {
            int temp = b;
            b = t;
            t = temp;
        }
        for (int y = b; y <= t; ++y) {
            this.hLine(x, y, r);
        }
    }

    int invert(int col) {
        return col;
    }

    void invert(int x, int y) {
        this.pixel(x, y, this.invert(this.getPixel(x, y)));
    }

    void outline(int x, int y, int w, int h) {
        int i = x;
        int ww = w;
        while (ww-- > 0) {
            this.invert(i, y);
            this.invert(i, y + h - 1);
            i += 2;
        }
        while (h-- > 0) {
            this.invert(x, y);
            this.invert(x + w - 1, y);
            y += 2;
        }
    }

    void hlinecol(int l, int h, int r) {
        while (l <= r) {
            this.pixel(l++, h);
        }
    }

    private int getScan(int x, int y) {
        if (x < 0) {
            return 0;
        }
        if (x >= this.width) {
            return 0;
        }
        if (y < 0) {
            return 0;
        }
        if (y >= this.height) {
            return 0;
        }
        return this.getPixel(x, y);
    }

    int scanleft(int x, int y) {
        int c;
        while ((c = this.getScan(--x, y)) == this.OLDFILL && x >= 0) {
        }
        return ++x;
    }

    int scanright(int x, int y) {
        int c;
        while ((c = this.getScan(++x, y)) == this.OLDFILL && x < this.width) {
        }
        return --x;
    }

    void linefill(int x, int y, int d) {
        if (--this.fillcounter < 1) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        int xlf = this.scanleft(x, y);
        int xrg = this.scanright(x, y);
        this.hlinecol(xlf, y, xrg);
        for (x = xlf; x <= xrg; ++x) {
            if (this.getScan(x, y - d) != this.OLDFILL) continue;
            this.linefill(x, y - d, -d);
        }
        for (x = xlf; x <= xrg; ++x) {
            if (this.getScan(x, y + d) != this.OLDFILL) continue;
            this.linefill(x, y + d, d);
        }
    }

    void fill(int x, int y) {
        this.OLDFILL = this.getPixel(x, y);
        if (this.OLDFILL == this.COLOR) {
            return;
        }
        this.fillcounter = 220;
        this.linefill(x, y, -1);
    }

    int rnd(int size) {
        return (int)(Math.random() * (double)size);
    }

    void spray(int x, int y) {
        for (int i = 1; i < 10; ++i) {
            this.pixel(x + this.rnd(i) - 1, y + this.rnd(i) - 1);
            this.pixel(x - this.rnd(i) + 1, y - this.rnd(i) + 1);
            this.pixel(x + this.rnd(i) - 1, y - this.rnd(i) + 1);
            this.pixel(x - this.rnd(i) + 1, y + this.rnd(i) - 1);
        }
    }

    void shade(int oldcolor, int sens, PalettePanel palette) {
        int rownum = PalettePanel.paveloc.y;
        int basenum = rownum * 16;
        int stt = sens > 0 ? 0 : 15;
        for (int j = 0; j < this.height; ++j) {
            int colornum = stt + sens;
            colornum = sens > 0 ? Math.min(colornum, 15) : Math.max(colornum, 0);
            for (int i = 0; i < this.width; ++i) {
                if (this.getPixel(i, j) == oldcolor) {
                    this.COLOR = palette.getRGB(colornum + basenum);
                    this.pixel(i, j);
                    colornum += sens;
                    if (sens > 0) {
                        colornum = Math.min(colornum, 15);
                        continue;
                    }
                    colornum = Math.max(colornum, 0);
                    continue;
                }
                colornum = stt;
            }
        }
    }

    void mirrorH() {
        int middle = this.width / 2;
        for (int j = 0; j < this.height; ++j) {
            int lineptr = j * this.width;
            int rig = lineptr + this.width - 1;
            for (int i = middle - 1; i >= 0; --i) {
                this.screen[rig - i] = this.screen[lineptr + i];
            }
        }
    }

    void mirrorV() {
        int middle = this.height / 2;
        for (int j = 0; j < middle; ++j) {
            int srcptr = j * this.width;
            int dstptr = (this.height - 1 - j) * this.width;
            for (int i = 0; i < this.width; ++i) {
                this.screen[dstptr + i] = this.screen[srcptr + i];
            }
        }
    }

    void flipV() {
        int middle = this.height / 2;
        for (int j = 0; j < middle; ++j) {
            int srcptr = j * this.width;
            int dstptr = (this.height - 1 - j) * this.width;
            for (int i = 0; i < this.width; ++i) {
                int temp = this.screen[dstptr + i];
                this.screen[dstptr + i] = this.screen[srcptr + i];
                this.screen[srcptr + i] = temp;
            }
        }
    }

    void flipH() {
        int middle = this.width / 2;
        for (int j = 0; j < this.height; ++j) {
            int lineptr = j * this.width;
            int rig = lineptr + this.width - 1;
            for (int i = middle - 1; i >= 0; --i) {
                int temp = this.screen[lineptr + i];
                this.screen[lineptr + i] = this.screen[rig - i];
                this.screen[rig - i] = temp;
            }
        }
    }

    void deleteH(int x) {
        int k = this.width - 1;
        int black = -16777216;
        for (int j = 0; j < this.height; ++j) {
            int i;
            for (i = x; i < k; ++i) {
                this.pixel(i, j, this.getPixel(i + 1, j));
            }
            this.pixel(i, j, black);
        }
    }

    void insertH(int x) {
        int k = this.width - 1;
        for (int j = 0; j < this.height; ++j) {
            for (int i = k; i > x; --i) {
                this.pixel(i, j, this.getPixel(i - 1, j));
            }
        }
    }

    void deleteV(int y) {
        int i;
        int j;
        int black = -16777216;
        for (j = y; j < this.height - 1; ++j) {
            for (i = 0; i < this.width; ++i) {
                this.pixel(i, j, this.getPixel(i, j + 1));
            }
        }
        for (i = 0; i < this.width; ++i) {
            this.pixel(i, j, black);
        }
    }

    void insertV(int y) {
        for (int j = this.height - 1; j > y; --j) {
            for (int i = 0; i < this.width; ++i) {
                this.pixel(i, j, this.getPixel(i, j - 1));
            }
        }
    }

    void colorToColor(int prev, int next) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.screen[i] != prev) continue;
            this.screen[i] = next;
        }
    }

    void scrollLeft() {
        int xsr = this.width - 1;
        for (int j = 0; j < this.height; ++j) {
            int ptr = j * this.width;
            int s = this.screen[ptr];
            for (int i = 0; i < xsr; ++i) {
                this.screen[ptr + i] = this.screen[ptr + i + 1];
            }
            this.screen[ptr + xsr] = s;
        }
    }

    void scrollDown() {
        int yst = this.height - 1;
        for (int i = 0; i < this.width; ++i) {
            int s = this.screen[yst * this.width + i];
            for (int j = yst; j > 0; --j) {
                this.screen[j * this.width + i] = this.screen[(j - 1) * this.width + i];
            }
            this.screen[i] = s;
        }
    }

    void scrollRight() {
        int xsr = this.width - 1;
        for (int j = 0; j < this.height; ++j) {
            int ptr = j * this.width;
            int s = this.screen[ptr + xsr];
            for (int i = xsr; i > 0; --i) {
                this.screen[ptr + i] = this.screen[ptr + i - 1];
            }
            this.screen[ptr] = s;
        }
    }

    void scrollUp() {
        int yst = this.height - 1;
        for (int i = 0; i < this.width; ++i) {
            int s = this.screen[i];
            for (int j = 0; j < yst; ++j) {
                this.screen[j * this.width + i] = this.screen[(j + 1) * this.width + i];
            }
            this.screen[yst * this.width + i] = s;
        }
    }

    Image getImage() {
        this.mis = new MemoryImageSource(this.width, this.height, palette.getColorModel(), this.screen, 0, this.width);
        return toolkit.createImage(this.mis);
    }

    public void addConsumer(ImageConsumer consumer) {
        this.mis.addConsumer(consumer);
    }

    static {
        toolkit = null;
    }
}

