``
`` Web Page Auto Menu
`` (c) 2011 Denis Sureau - Licence GPL 3
`` Web: www.scriptol.com  
`` Work on a single Web page. Build a menu with anchors and links to headings
`` 
`` Processing
`` - Retrieve a previous generated menu with anchors. 
`` - Extract heading tags, h2 etc.
`` - Build an unique id for each, add it to all heading tags.
`` - Build/update a hierarchical indented menu with links to these tags.
`` - Insert the menu after the <h1> tag or replace the previous menu in place.
`` - You can move the menu manually.
`` 
`` Makes use of the Simple HTML parser by Jose Solorzano (https://sourceforge.net/projects/php-html/)
`` 



extern
  class simple_html_dom_node
    text innertext
    text outertext
    text tag
    text id
    array find(text, text idx=null)
    simple_html_dom_node next_sibling()
    simple_html_dom_node first_child()
  /class
  class simple_html_dom
     text id   
     text plaintext
     text outertext
     array nodes
     array children
     simple_html_dom_node root
     boolean load(text, boolean lowercase=true)
     array find(text, text idx=null)  
     simple_html_dom_node firstChild()  
  /class 

  void dump_html_tree(text node, boolean show_attr=true, int deep=0) 
  simple_html_dom file_get_html(text)

/extern

require("simple_html_dom.php")

// CHANGE THE TEXT BELOW IF NEEDED

text legend = "Summary"    // change the legend if you want

// END OF USER CONFIG
 
array idlist = {}

// get starting counters for each level 

int getMax(text tag, simple_html_dom doc)
    int maximum = 0
    int ctr = 0    
    simple_html_dom_node x = null
    text temp

    array tags = doc.find(tag)
    if tags.size() > 0  
        for x in tags
            temp = trim(x.id)
            if temp <> ""
                ctr = intval(temp[2 ..])
                maximum = max(maximum, ctr)
            /if    
        /for      
    /if
return maximum

// adding IDs to heading tags 

void getTags(simple_html_dom doc, text tag, int counter)
  simple_html_dom_node x = null  
  
  array tags = doc.find(tag)
  if tags.size() > 0  
    for x in tags
        if trim(x.id) = ""
            if x.id <> ""
                idlist.push(x.id)
            else    
                counter + 1
                text newid = tag + text(counter)
                x.id = newid
                idlist.push(newid)
            /if    
        /if
    /for  
  /if

return

// extracting all the anchors to build an array

simple_html_dom doc
array headings
int depthlevel

void buildMenu(simple_html_dom_node element)
  while true
    if element = null break
    if element = false break
    if element.tag in { "h2", "h3", "h4", "h5", "h6"}
       text id = element.id
       text anchor = element.innertext
       int level = intval(element.tag[1])
       if level <= depthlevel
         headings[id] = anchor
       /if 
    /if

    simple_html_dom_node n = element.first_child()
    if n <> false
        buildMenu(n)
    /if
    
    element = element.next_sibling()

  /while     
    
return  


// building the indented menu to insert into the page

text menu
int licounter = 0

void addMenu(text currentLevel)
    menu + "<ul>\n"
    text id = headings.key()
    text anchor = headings[id]
    headings.shift()
    menu + "<li><a href='#$id'>$anchor</a></li>\n"
    licounter + 1    
    while headings.size() > 0
        id = headings.key()
        text level = id[1]
        if level < currentLevel break
        if level > currentLevel
            addMenu(level)
        else
            anchor = headings[id]
            headings.shift()
            menu + "<li><a href='#$id'>$anchor</a></li>\n"
            licounter + 1            
        /if                    
    /while
    menu + "</ul>\n"        
return   


void syntax()
  print "Web Page Auto Menu - (c) 2011 Scriptol.com - Freeware"
  print "Syntax:"
  print "    php [-hn] automenu.php [path]filename.html"
  print "Option:"
  print "    -h2 .. -hn depth level to take into account"
  print "Builds a menu from headings in a HTML page with links."
  exit(0)
return

int main(int argnum, array argv)
  
  global legend
  global licounter
    
  if argnum < 2 let syntax()

  depthlevel = 3   // default depth is h3
  int pathindex = 1 // default path first argument

  for text param in argv
    if param.length() <> 3 continue
    if param[0 .. 1] <> "-h" continue
    depthlevel = intval(param[2])
    pathindex = 2
  /for
  
  if(depthlevel < 2) let syntax()
  
  text path = argv[pathindex]
  
  doc = file_get_html(path)
  text content = doc.plaintext  
  
  echo "Starting counters to"
      
  for int i in 2 .. depthlevel
    text htag = "h$i"
    int counter = getMax(htag, doc)
    echo " $htag=$counter"
    getTags(doc, htag, counter) 
  /for
  print ""
  
  // localising the h1 tag 
  array h1 = doc.find("h1")
  if h1.size() = 0 let die("Add an H1 tag to the page.")
  simple_html_dom_node root = h1[0].toObject()
  simple_html_dom_node x = root.next_sibling()

  // creating the menu
  buildMenu(x)

  menu = "\n<fieldset id=\"automenu\">\n<legend>$legend</legend>\n" 
  addMenu("2")    
  menu + "</fieldset>\n"

  // replacing or adding the menu
  array already = doc.find("fieldset[id=automenu]")
  text update = null
  if already.size() > 0
    root = already[0].toObject()
    root.outertext = str_get_html(menu) 
    update = "updated"
  else
    root.outertext + str_get_html(menu) 
    update = "generated"   
  /if  
  
  file_put_contents(path, doc)
  
  print "Menu $update in $path with $licounter links."


return 0


main($argc, $argv)

