<?php
// Composite
// (c) 2026 Scriptol.com/ Scriptol.fr. By Denis Sureau
// Free under the GNU GPL 2 License.
// Requires the PHP 8 interpreter.
// Compiling the sources requires the Scriptol 2 to PHP compiler.
//
// The composter updates a website from a local directory.
// Links in the pages are checked for broken or redirected urls.

include_once("path.php");
include_once("ftp.php");
include_once("linkcheck.php");
$CHECKMODE=false;
$BACKUP=true;
$ANYFILES=false;
$ANYWEXT=false;
$TOUCHFLAG=true;
$CONTFLAG=false;
$SKIPPED=false;
$NOLOCAL=false;
$MAPFLAG=false;
$HTACCESS=true;
$REMOTEEXT="";
$TOPROCESS=array("html");
$CHANGEEXT=false;
$days=0;
$server="";
$user="";
$pass="";
$params=array();
$backdir="";
$temporary="temporary-file.000.tmp";
$remlength=0;
$extToUpdate=array();
$connection=0;
$counter=0;
$falsecounter=0;
$problem=0;
function usage()
{
   echo "\n";
   echo "Composite 1.0 - (c) 2026 Scriptol.com/Scriptol.fr", "\n";
   echo "-------------------------------------------------", "\n";
   echo "Syntax:", "\n";
   echo "  php composite.php [options] parameters", "\n";
   echo "Options:", "\n";
   echo "  -t test, display only, send nothing to the server.", "\n";
   echo "  -v verbose, display more infos.", "\n";
   echo "  -q quiet, display nothing.", "\n";
   echo "  -a[ext] update all files. Or file with the given extension.", "\n";
   echo "  -oext replace default html extension of files to process or add one.", "\n";
   echo "  -rext extension for generated file (default unchanged).", "\n";
   echo "  -u send all files unchanged, do not execute locally.", "\n";
   echo "  -s speed, do not check links.", "\n";
   echo "Parameters:", "\n";
   echo "  -ppassword.", "\n";
   echo "  -llogin.", "\n";
   echo "  directory: local directory where pages are stored.", "\n";
   echo "  -fftpadr remote site adr in the form ftp.example.com or IP.", "\n";
   echo "  -bbackup, defining a backup directory for comparison.", "\n";
   echo "  -ddirectory remote directory.", "\n";
   echo "  -w website url.", "\n";
   exit(0);
   return;
}

function syncConnect()
{
   global $connection;
   global $server;
   $connection=ftp_connect($server);
   global $user;
   global $pass;
   if(ftp_login($connection,$user,$pass)===true)
   {
      echo "Connected on $server as $user", "\n";
      if(ftp_pasv($connection,true)===true)
      {
         echo "Passive mode turned on", "\n";
      }
      else
      {
         echo "Enable to set passive mode", "\n";
      }
      return true;
   }
   else
   {
      echo "Enable to log as $user on $server", "\n";
   }
   return false;
}

function syncDisconnect()
{
   global $connection;
   ftp_close($connection);
   return;
}

function syncSize($fname)
{
   global $connection;
   return ftp_size($connection,$fname);
}

function syncTime($fname)
{
   global $connection;
   return ftp_mdtm($connection,$fname);
}

function filecompare($a,$b)
{
   $x=array();
   $y=array();
   $x=file($a);
   $y=file($b);
   return $x ==$y;
}

function backError($b)
{
   echo "Can't write on backup $b, check device or path and try again...", "\n";
   exit(0);
   return;
}

function checkBackup($bpath)
{
   $tempfile=Path::merge($bpath,"ftpsynxyz.$$$");
   $f=0;
   $error=($f=fopen($tempfile,"w"));
   if($error===false)
   {
      backError($bpath);
   }
   $saved=fwrite($f,"ftp synchro");
   fclose($f);
   if($saved===0)
   {
      backError($bpath);
   }
   else
   {
      global $CONTFLAG;
      if($CONTFLAG)
      {
         echo "Files compared by content", "\n";
         global $TOUCHFLAG;
         $TOUCHFLAG=false;
         return;
      }
      global $TOUCHFLAG;
      $TOUCHFLAG=touch(convertUnix($tempfile),time());
      unlink($tempfile);
      global $QUIET;
      if(!$QUIET)
      {
         if($TOUCHFLAG)
         {
            echo "Files compared by time", "\n";
         }
         else
         {
            echo "Touch failed, files compared by contents", "\n";
         }
      }
   }
   return;
}

function checkRemote($rpath)
{
   global $TOUCHFLAG;
   $TOUCHFLAG=touch($rpath,time());
   return;
}

function buildURL($rempath)
{
   global $rdlength;
   $rd=$rdlength;
   $url=substr($rempath,$rd);
   global $website;
   $url=Path::merge($website,$url);
   return $url;
}

function filecopy($src,$rmt,$loc,$composeflag,$locdir)
{
   global $CHECKMODE;
   if($CHECKMODE===true)
   {
      echo "Will upload $src on the host in ".$rmt, "\n";
      global $remlength;
      $rmtpath=substr($rmt,$remlength);
      global $website;
      $url=Path::merge($website,$rmtpath);
      echo "And will update ", " ", $url, "\n";
      global $falsecounter;
      $falsecounter+=1;
      return;
   }
   global $QUIET;
   if($QUIET===false)
   {
      echo "Uploading $src ";
      echo "to $rmt", "\n";
   }
   global $CHECKLINKS;
   if($CHECKLINKS)
   {
      linkCheckerDiffered($src);
   }
   $root="";
   $occur=intVal(substr_count($locdir,"/"));
   $occur+=intVal(substr_count($locdir,"\\"));

   if($occur>1)
   {
      $root=dirname($locdir);
   }
   else
   {
      $root=$locdir;
   }
   $putres=0;
   if($composeflag===true)
   {
      $content="";
      $reterr=0;
      
		exec("php $src $root $locdir", $content, $reterr);
		
      $tempfile=fopen('php://temp','r+');
      fwrite($tempfile,implode("\n",$content));
      rewind($tempfile);
      global $connection;
      $putres=ftp_fput($connection,$rmt,$tempfile,FTP_BINARY);
   }
   else
   {
      global $connection;
      $putres=ftp_put($connection,$rmt,$src,FTP_BINARY);
   }
   if($putres===true)
   {
      global $counter;
      $counter+=1;
      global $BACKUP;
      if($BACKUP===true)
      {
         copy($src,$loc);
         if($loc==="")
         {
            return;
         }
         $b=@touch(@convertUnix($loc),intVal(filemtime($src)));
         if(!$b)
         {
            echo "Failed to set date and time for ", " ", convertUnix($loc), "\n";
         }
      }
      global $VERBOSE;
      if($VERBOSE)
      {
         global $remlength;
         $rmtpath=substr($rmt,$remlength);
         global $website;
         $url=Path::merge($website,$rmtpath);
         echo "Updated url :", " ", $url, "\n";
      }
   }
   else
   {
      echo "Error, $src not uploaded", "\n";
   }
   return;
}

function remoteIdentical($lfile,$rfile)
{
   global $DEBUG;
   if($DEBUG===true)
   {
      echo "Comparing $lfile and remote $rfile", "\n";
   }
   global $connection;
   global $temporary;
   if(@ftp_get($connection,$temporary,$rfile,FTP_BINARY)!=true)
   {
      return false;
   }
   $x=array();
   $y=array();
   $x=file($lfile);
   $y=file($temporary);
   return $x ==$y;
}

function backupIdentical($locfile,$bakfile)
{
   $x=array();
   $y=array();
   global $DEBUG;
   if($DEBUG===true)
   {
      echo "Comparing $locfile and local $bakfile", "\n";
   }
   if(!file_exists($bakfile))
   {
      return false;
   }
   if(filesize($locfile)!=filesize($bakfile))
   {
      return false;
   }
   global $TOUCHFLAG;
   if($TOUCHFLAG)
   {
      $a=intVal(filemtime($locfile));
      $b=intVal(filemtime($bakfile));
      if($a===$b)
      {
         return true;
      }
   }
   $x=file($locfile);
   $y=file($bakfile);
   return $x ==$y;
}

function dateCompare($loctime,$numdays)
{
   $numdays+=1;
   $nt=time()-(86400*$numdays);
   return $loctime>=$nt;
}

function synchro($locdir,$bdir,$hostdir)
{
   $content=scandir($locdir);
   $bckname="";
   $rmtname="";
   $returned=0;
   if($hostdir!="")
   {
      global $VERBOSE;
      if($VERBOSE)
      {
         echo "Creating $hostdir if needed";
         global $BACKUP;
         if($BACKUP)
         {
            echo ", and $bdir";
         }
         echo "\n";
      }
      global $CHECKMODE;
      if(!$CHECKMODE)
      {
                  global $connection;
         @ftp_mkdir($connection,$hostdir);
         global $BACKUP;
         if($BACKUP===true)
         {
            if(!file_exists($bdir))
            {
                              @mkdir($bdir);
            }
         }
      }
   }
   if(empty($content))
   {
      return;
   }
   foreach($content as $basename)
   {
      $srcname="";
      if($basename[0]==="/")
      {
         global $website;
         $srcname=Path::merge($website,$basename);
      }
      else
      {
         $srcname=Path::merge($locdir,$basename);
      }
      if(filetype($srcname)==="file")
      {
         $composeflag=0;
         $rmtname=Path::merge($hostdir,$basename);
         $ext=pathinfo($basename,PATHINFO_EXTENSION);
         $composeflag=false;

         global $TOPROCESS;
         if(in_array($ext,$TOPROCESS))
         {
            $composeflag=true;
         }
         global $NOLOCAL;
         if($NOLOCAL)
         {
            $composeflag=false;
         }
         global $CHANGEEXT;
         if($CHANGEEXT&&$composeflag)
         {
            $pos=intVal(strrpos($rmtname,".",0));
            if($pos>0)
            {
               global $REMOTEEXT;
               $rmtname=substr_replace($rmtname,$REMOTEEXT,$pos);
            }
         }
         global $HTACCESS;
         if($basename[0]==="."&&!$HTACCESS)
         {
            global $QUIET;
            if(!$QUIET)
            {
               echo $basename, " ", "skipped", "\n";
            }
            global $problem;
            $problem+=1;
            continue;
         }
         global $BACKUP;
         if($BACKUP===true)
         {
            $bckname=Path::merge($bdir,$basename);
            $returned=false;
            global $ANYFILES;
            global $ANYWEXT;
            if(!$ANYFILES&&!$ANYWEXT)
            {
               $returned=backupIdentical($srcname,$bckname);
            }
            if($ANYWEXT)
            {
               global $extToUpdate;
               if(in_array($ext,$extToUpdate)===false)
               {
                  $returned=true;
               }
            }
            if(!$returned)
            {
               filecopy($srcname,$rmtname,$bckname,$composeflag,$locdir);
            }
            else
            {
               global $SKIPPED;
               if($SKIPPED)
               {
                  echo "  Skipped ", " ", $srcname, "\n";
               }
            }
            continue;
         }
         else
         {
            $returned=remoteIdentical($srcname,$rmtname);
            if(!$returned)
            {
               filecopy($srcname,$rmtname,"",$composeflag,$locdir);
            }
            else
            {
               global $SKIPPED;
               if($SKIPPED)
               {
                  echo "  Skipped ", " ", $srcname, "\n";
               }
            }
         }
      }
   }
   foreach($content as $basename)
   {
      if($basename[0]==='.')
      {
         continue;
      }
      $srcname=Path::merge($locdir,$basename);
      if(filetype($srcname)==="dir")
      {
         synchro($srcname,Path::merge($bdir,$basename),Path::merge($hostdir,$basename));
      }
   }
   return;
}

function readLogin()
{
   $loglist=array();
   $loglist=file("ftpsync.login");
   foreach($loglist as $line)
   {
      global $server;
      if(strstr($line,$server))
      {
         $data=explode(" ",$line);
         global $user;
         $user=$data[1];
         global $pass;
         $pass=$data[2];
         return true;
      }
   }
   return false;
}

function processCommand($argnum,$arguments)
{
   if($argnum<2)
   {
      usage();
   }
   foreach($arguments as $param)
   {
      $value="";
      $opt="";
      if(strlen($param)>1)
      {
         $opt=substr($param,0,2);
         if($opt[0]==="-"&&strlen($param)>2)
         {
            $value=substr($param,2);
         }
      }
      else
      {
         usage();
      }
      if($opt==="-t")
      {
         global $CHECKMODE;
         $CHECKMODE=true;
         continue;
      }
      if($opt==="-a")
      {
         if(strlen($value)===0)
         {
            global $ANYFILES;
            $ANYFILES=true;
         }
         else
         {
            global $ANYWEXT;
            $ANYWEXT=true;
            global $extToUpdate;
            array_push($extToUpdate,$value);
         }
         continue;
      }
      if($opt==="-r")
      {
         if(strlen($value)>0)
         {
            global $REMOTEEXT;
            $REMOTEEXT=$value;
            global $CHANGEEXT;
            $CHANGEEXT=true;
            if($value[0]!=".")
            {
               $REMOTEEXT=".".$value;
            }
         }
         else
         {
            die("-e must be followed by an extension name");
         }
         continue;
      }
      if($opt==="-o")
      {
         if(strlen($value)===0)
         {
            die("-o must be followed by an extension name");
         }
         global $TOPROCESS;
         if(count($TOPROCESS)===1)
         {
            $TOPROCESS[0]=$value;
         }
         else
         {
            array_push($TOPROCESS,$value);
         }
         continue;
      }
      if($opt==="-v")
      {
         global $VERBOSE;
         $VERBOSE=true;
         continue;
      }
      if($opt==="-k")
      {
         global $SKIPPED;
         $SKIPPED=true;
         continue;
      }
      if($opt==="-q")
      {
         global $QUIET;
         $QUIET=true;
         continue;
      }
      if($opt==="-~")
      {
         global $DEBUG;
         $DEBUG=true;
         continue;
      }
      if($opt==="-s")
      {
         global $CHECKLINKS;
         $CHECKLINKS=false;
         continue;
      }
      if($opt==="-c")
      {
         global $CONTFLAG;
         $CONTFLAG=true;
         continue;
      }
      if($opt==="-u")
      {
         global $NOLOCAL;
         $NOLOCAL=true;
         continue;
      }
      if($opt==="-p")
      {
         global $pass;
         $pass=$value;
         if($pass==="")
         {
            die("-p must be followed by the password.");
         }
         continue;
      }
      if($opt==="-l")
      {
         global $user;
         $user=$value;
         if($user==="")
         {
            die("-l must be followed by the login.");
         }
         continue;
      }
      if($opt==="-f")
      {
         global $server;
         $server=$value;
         if($server==="")
         {
            die("-f must be followed by the ftp address.");
         }
         continue;
      }
      if($opt==="-w")
      {
         global $website;
         $website=$value;
         if($website==="")
         {
            die("-w must be followed by the site url.");
         }
         continue;
      }
      if($opt==="-d")
      {
         global $remotedir;
         $remotedir=$value;
         if($remotedir==="")
         {
            die("-d requires a sub-directory.");
         }
         global $remlength;
         $remlength=strlen($remotedir);
         continue;
      }
      if($opt==="-b")
      {
         global $backdir;
         $backdir=$value;
         if($backdir==="")
         {
            die("-b requires a directory.");
         }
         global $BACKUP;
         $BACKUP=true;
         continue;
      }
      if(substr($param,0,4)==="ftp.")
      {
         global $server;
         $server=$param;
         continue;
      }
      if($opt==="-h")
      {
         global $HTACCESS;
         $HTACCESS=true;
         continue;
      }
      if($param[0]==="-")
      {
         echo "Unknown command $param", "\n";
         usage();
      }
      global $source;
      if($source==="")
      {
         $source=$param;
         continue;
      }
      echo "Unknown command $param", "\n";
      usage();
   }
   global $BACKUP;
   if($BACKUP===true)
   {
      global $backdir;
      checkBackup($backdir);
   }
   global $server;
   if($server==="")
   {
            echo "FTP location: ";
      $fp=fopen("php://stdin","r");
      $server=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($server==="")
   {
      exit(0);
   }
   global $source;
   if($source==="")
   {
            echo "Directory to send: ";
      $fp=fopen("php://stdin","r");
      $source=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($source==="")
   {
      exit(0);
   }
   global $user;
   if($user==="")
   {
            echo "Login: ";
      $fp=fopen("php://stdin","r");
      $user=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($user==="")
   {
      exit(0);
   }
   global $pass;
   if($pass==="")
   {
            echo "Password: ";
      $fp=fopen("php://stdin","r");
      $pass=rtrim(fgets($fp,65536));
      fclose($fp);
   }
   if($pass==="")
   {
      exit(0);
   }
   return;
}

function main($argc,$argv)
{
   $x=array_slice($argv,1);
   global $server;
   $server="";
   processCommand($argc,$x);
   global $problem;
   $problem=0;

   global $website;
   if($website==="")
   {
      die("This program requires the url of the website to work.");
   }
   else
   {
      if(!hasProtocol($website))
      {
         $website="https://".$website;
      }
   }
   global $QUIET;
   if(!$QUIET)
   {
      global $VERBOSE;
      if($VERBOSE===true)
      {
         echo "Verbose mode enabled", "\n";
      }
      global $DEBUG;
      if($DEBUG===true)
      {
         echo "Debug mode enabled", "\n";
      }
      global $source;
      echo "Source directory: ", " ", $source, "\n";
      echo "Website: ", " ", $website, "\n";
      global $remotedir;
      echo "Remote directory: ", " ", $remotedir, "\n";
      global $BACKUP;
      if($BACKUP===true)
      {
         global $backdir;
         echo "Backup location: ", " ", $backdir, "\n";
      }
      global $ANYFILES;
      if($ANYFILES===true)
      {
         echo "All fille will be uploaded regardless of changes.", "\n";
      }
      global $ANYWEXT;
      if($ANYWEXT===true)
      {
         echo "All files with selected extension will be updated.", "\n";
      }
      global $TOPROCESS;
      echo "Extensions of files to process: ", " ", var_export(implode(" ",$TOPROCESS),true), "\n";
      $extstr="unchanged";
      global $REMOTEEXT;
      if($REMOTEEXT!="")
      {
         $extstr=$REMOTEEXT;
      }
      global $CHANGEEXT;
      if($CHANGEEXT===true)
      {
         echo "Remote extension : $extstr", "\n";
      }
      global $CHECKLINKS;
      if($CHECKLINKS)
      {
         echo "Link checker active.", "\n";
         if(function_exists("curl_init"))
         {
            echo "Curl active.", "\n";
         }
         else
         {
            echo "Curl not supported, enable it in php.ini.", "\n";
         }
      }
   }
   syncConnect();
   echo "Synchronizing $source on $server", "\n";
   global $source;
   global $backdir;
   global $remotedir;
   synchro($source,$backdir,$remotedir);
   syncDisconnect();
   if($QUIET)
   {
      return 0;
   }
   global $counter;
   echo $counter," file",($counter>1?"s":"")," copied";
   global $CHECKMODE;
   if($CHECKMODE)
   {
      global $falsecounter;
      if($falsecounter>0)
      {
         echo ", ",$falsecounter," file",($falsecounter>1?"s":"")," to update";
      }
      else
      {
         echo ", nothing to update";
      }
   }
   echo ".", "\n";
   if($problem>0)
   {
      echo "$problem file".($problem>1?"s":""), " ", "skipped.", "\n";
   }
   global $MAPFLAG;
   if($MAPFLAG&&$counter>0)
   {
      updateMap();
   }
   global $CHECKLINKS;
   if($CHECKLINKS&&$counter>0)
   {
      differedCheck();
      dispBroken();
   }
   global $temporary;
   if(file_exists($temporary))
   {
      unlink($temporary);
   }
   echo "Done.", "\n";
   return 0;
}

main(intVal($argc),$argv);

?>
