/* Generated by Scriptol */

//  Path Class
//  Scriptol - (c) 2001-2025  D.G Sureau
//  www.scriptol.com
//  Licence: OSS
//  This is a set of static functions related to files in directory
//  The path separator is "/" under Unix and Windows
var Path=(function()
{
// EXISTS - Test if a file exists
   Path.exists=function(dname)
   {
      return fs.existsSync(dname);
   }

// SIZE - Return the size of a file
   Path.size=function(fname)
   {
      return scriptol.filesize(fname);
   }

// TYPE - Return the type of an entry: file, dir, etc...
   Path.type=function(fname)
   {
      return scriptol.filetype(fname);
   }

// DATE - Returns the date of a file
   Path.created=function(fname)
   {
      var t=parseInt(filemtime(fname));
      return date("",t);
   }

// ISFILE
   Path.isFile=function(fname) {
      return scriptol.filetype(fname)==="file";
   }

// ISDIR
   Path.isDir=function(fname)
   {
      var t=scriptol.filetype(fname);
      if(t==="link") {
         return false;
      }
      if(t!="dir") {
         return false;
      }
      return true;
   }

// REN
   Path.ren=function(oldname,newname)
   {
      var b=true;
      fs.renameSync(oldname,newname);
      return b;
   }

// DELETE
   Path.erase=function(fname) {
      return fs.unlinkSync(fname);
   }

// MERGE - Merge elements of path
   Path.merge=function(path,filename)
   {
      if(path==="") {
         return filename;
      }
      if(filename==="") {
         return path;
      }
      var plc=path.charAt(path.length-1);
      var ffc=filename.charAt(0);
      if((plc==="/")&&(ffc==="/")) {
         return path+filename.slice(1);
      }
      if((plc!="/")&&(ffc!="/")) {
         path+="/";
      }
      return path+filename;
   }

// MAKE DIR - Create a sub-directory
   Path.make=function(name) {
      return fs.mkdirSync(name);
   }

// SPLIT EXT - Split the node and the extension of a filename or path
   Path.splitExt=function(path)
   {
      var l=path.length;
      if(l===0) {
         return ["",""];
      }
      for(x=l-1;x>=0;x+=-1) {
         if(path.charAt(x)===".") {
            return [path.slice(0,x),path.slice(x+1)];
         }
      }
      return [path,""];
   }

// HAS EXTENSION - Test if the file has an extension or it is inside a list
// the list is an array of extensions separated by a space (with or without dot)
   Path.hasExtension=function(path,extlist)
   {
      extlist=typeof extlist !== 'undefined' ? extlist : [];
      var pos=path.lastIndexOf(".");
      if(pos===-1) {
         return false;
      }
      var longext=path.slice(pos);
      var shortext=longext.slice(1);
      if(shortext==="") {
         return false;
      }
      if(scriptol.aCompare(extlist,[],"=")) {
         return true;
      }
      if((extlist.indexOf(shortext)!=-1)) {
         return true;
      }
      if((extlist.indexOf(longext)!=-1)) {
         return true;
      }
      return false;
   }

// GET EXTENSION - Get extension of a filename or path
   Path.getExtension=function(path)
   {
      var pos=path.lastIndexOf(".");
      if(pos!=-1) {
         return path.slice(pos);
      }
      return "";
   }

// CHANGE EXTENSION - Replace current extension by given on
// on filename or full path
   Path.changeExt=function(path,newext)
   {
      newext=typeof newext !== 'undefined' ? newext : "";
      var l=path.length;
      if(l===0) {
         return newext;
      }
      var pos=path.lastIndexOf(".");
      if(pos!=-1) {
         if(newext.charAt(0)===".") {
            path=path.slice(0,pos);
         }         
         else {
            path=path.slice(0,pos+1);
         }
      }
      return path+newext;
   }

// HAS DIR  - Return true if the path has a directory or dir
   Path.hasDir=function(path)
   {
      var l=path.length;
      if(l===0) {
         return false;
      }
      if(l>1) {
         if(path.charAt(1)===":") {
            return true;
         }
      }
      if(path.indexOf("/")!=-1) {
         return true;
      }
      if(path.indexOf("\\")!=-1) {
         return true;
      }
      return false;
   }

// SPLIT  - Split path to directory and file
   Path.splitFile=function(path)
   {
      var l=path.length;
      if(l===0) {
         return ["",""];
      }
      for(x=l-1;x>=0;x+=-1) {
         if((path.charAt(x)==="/")||(path.charAt(x)==="\\")) {
            return [path.slice(0,x+1),path.slice(x+1)];
         }
      }
      return ["",path];
   }

// GET DIR Get current directory
   Path.prototype.getDir=function() {
      return process.cwd();
   }

// COMPARE PATHS
   Path.compare=function(a,b)
   {
      var l=a.length;
      if(l!=b.length) {
         return false;
      }
      for(i=0;i<l;i++) {
         if((a.charAt(i)==="\\")||(a.charAt(i)==="/")) {
            if(b.charAt(i)==="/") {
               continue;
            }
            if(b.charAt(i)==="\\") {
               continue;
            }
            return false;
         }
         if(a.charAt(i)!=b.charAt(i)) {
            return false;
         }
      }
      return true;
   }

   function Path() {
      this.nullarr=[];
   }
   return Path;
})();



/* End */
