<?php
// Update redirected links in your website
// (c) 2017-2025 Scriptol.com
// Free under the MIT License.
// Requires the PHP 7 interpreter.

// Works on a local copy of your site.
// Searches for all 301 redirected links
// and replaces them by the target URL.
// Check broken links too.
//
// You can update the online content of the site
// with PHP FTP Synchronizer.
//
// Scriptol-PHP Implementation of DOM official
// Fully compatible with PHP, requires Scriptol PHP
// The DOM interface is (c) 2007 Denis Sureau - Mozilla 1.1 Licence.
//
//  Path Class
//  Scriptol - (c) 2001-2025  D.G Sureau
//  www.scriptol.com
//  Licence: OSS
//  This is a set of static functions related to files in directory
//  The path separator is "/" under Unix and Windows

class Path
{
// EXISTS - Test if a file exists
static    function exists($dname)
   {
      return file_exists($dname);
   }

// SIZE - Return the size of a file
static    function size($fname)
   {
      return filesize($fname);
   }

// TYPE - Return the type of an entry: file, dir, etc...
static    function type($fname)
   {
      return filetype($fname);
   }

// DATE - Returns the date of a file
static    function created($fname)
   {
      $t=intVal(filemtime($fname));
      return date("",$t);
   }

// ISFILE
static    function isFile($fname)
   {
      return filetype($fname)==="file";
   }

// ISDIR
static    function isDir($fname)
   {
      $t=filetype($fname);
      if($t==="link")
      {
         return false;
      }
      if($t!="dir")
      {
         return false;
      }
      return true;
   }

// REN
static    function ren($oldname,$newname)
   {
      $b=true;
      rename($oldname,$newname);
      return $b;
   }

// DELETE
static    function erase($fname)
   {
      return unlink($fname);
   }

// MERGE - Merge elements of path
static    function merge($path,$filename)
   {
      if($path==="")
      {
         return $filename;
      }
      if($filename==="")
      {
         return $path;
      }
      $plc=$path[strlen($path)-1];
      $ffc=$filename[0];
      if(($plc==="/")&&($ffc==="/"))
      {
         return $path.substr($filename,1);
      }
      if(($plc!="/")&&($ffc!="/"))
      {
         $path.="/";
      }
      return $path.$filename;
   }

// MAKE DIR - Create a sub-directory
static    function make($name)
   {
      return mkdir($name);
   }

// SPLIT EXT - Split the node and the extension of a filename or path
static    function splitExt($path)
   {
      $l=strlen($path);
      if($l===0)
      {
         return array("","");
      }
      for($x=$l-1;$x>=0;$x+=-1)
      {
         if($path[$x]===".")
         {
            return array(substr($path,0,$x),substr($path,$x+1));
         }
      }
      return array($path,"");
   }

// HAS EXTENSION - Test if the file has an extension or it is inside a list
// the list is an array of extensions separated by a space (with or without dot)
   var $nullarr=array();
static    function hasExtension($path,$extlist=array())
   {
      $pos=strrpos($path,".");
      if($pos===false)
      {
         return false;
      }
      $longext=substr($path,$pos);
      $shortext=substr($longext,1);
      if($shortext==="")
      {
         return false;
      }
      if($extlist===array())
      {
         return true;
      }
      if(in_array($shortext,$extlist))
      {
         return true;
      }
      if(in_array($longext,$extlist))
      {
         return true;
      }
      return false;
   }

// GET EXTENSION - Get extension of a filename or path
static    function getExtension($path)
   {
      $pos=strrpos($path,".");
      if($pos!=false)
      {
         return substr($path,$pos);
      }
      return "";
   }

// CHANGE EXTENSION - Replace current extension by given on
// on filename or full path
static    function changeExt($path,$newext="")
   {
      $l=strlen($path);
      if($l===0)
      {
         return $newext;
      }
      $pos=strrpos($path,".");
      if($pos!=false)
      {
         if($newext[0]===".")
         {
            $path=substr($path,0,$pos);
         }
         else
         {
            $path=substr($path,0,$pos+1);
         }
      }
      return $path.$newext;
   }

// HAS DIR  - Return true if the path has a directory or dir
static    function hasDir($path)
   {
      $l=strlen($path);
      if($l===0)
      {
         return false;
      }
      if($l>1)
      {
         if($path[1]===":")
         {
            return true;
         }
      }
      if(strpos($path,"/")!=false)
      {
         return true;
      }
      if(strpos($path,"\\")!=false)
      {
         return true;
      }
      return false;
   }

// SPLIT  - Split path to directory and file
static    function splitFile($path)
   {
      $l=strlen($path);
      if($l===0)
      {
         return array("","");
      }
      for($x=$l-1;$x>=0;$x+=-1)
      {
         if(($path[$x]==="/")||($path[$x]==="\\"))
         {
            return array(substr($path,0,$x+1),substr($path,$x+1));
         }
      }
      return array("",$path);
   }

// GET DIR Get current directory
   function getDir()
   {
      return getcwd();
   }

// COMPARE PATHS
static    function compare($a,$b)
   {
      $l=strlen($a);
      if($l!=strlen($b))
      {
         return false;
      }
      for($i=0;$i<$l;$i++)
      {
         if(($a[$i]==="\\")||($a[$i]==="/"))
         {
            if($b[$i]==="/")
            {
               continue;
            }
            if($b[$i]==="\\")
            {
               continue;
            }
            return false;
         }
         if($a[$i]!=$b[$i])
         {
            return false;
         }
      }
      return true;
   }
}

$pcounter=0;
$dcounter=0;
$lcounter=0;
$mcounter=0;
$bcounter=0;
$content="";
$website="";
$root="";
$rootlen=0;
$DISPONLY=false;
$VERBOSE=false;
$RECONSTRUCT=false;
// Add your extension if not in list
$extensions=array(".html",".htm",".asp",".php",".https");
function usage()
{
   echo "\n";
   echo "UnRedir - (c) 2017-2025 Scriptol.com", "\n";
   echo "Usage:", "\n";
   echo "Go to the root of the local copy of the website and type:", "\n";
   echo "  php unredir.php [option][domain-name]", "\n";
   echo "Options:", "\n";
   echo "  domain  To build a full URL from a relative path. Replaced only if redirected.", "\n";
   echo "  -t      Display changes to be done, does not modify the files.", "\n";
   echo "  -v      Verbose, display each link checked.", "\n";
   exit(0);
   return;
}

// Utilities
function hasProtocol($url)
{
   if(strpos($url,"://")===false)
   {
      return false;
   }
   return true;
}

function rebuildURL($url,$locdir)
{
   if($url==="")
   {
      return "";
   }
   if(substr($url,0,3)==="../")
   {
      return $url;
   }
   if($url[0]==="/")
   {
      global $website;
      return "//".$website.substr($url,1);
   }
   global $rootlen;
   if(strlen($locdir)>=$rootlen)
   {
      $locdir=substr($locdir,$rootlen);
   }
   global $website;
   $locdir="http://".$website.$locdir;
   return Path::merge($locdir,$url);
}

function dispBroken($url)
{
   echo " *** Broken:", " ", $url, "\n";
   global $bcounter;
   $bcounter+=1;
   return "";
}

// Check for redirect
function redirected($url)
{
   global $VERBOSE;
   if($VERBOSE)
   {
      echo "Check", " ", $url, "\n";
   }
   if(strlen($url)<8)
   {
      return "";
   }
   $code=0;
   $newurl="";
   $hcurl=curl_init();
   
    curl_setopt($hcurl, CURLOPT_CONNECTTIMEOUT, 300);
    curl_setopt($hcurl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($hcurl, CURLOPT_VERBOSE, false);
    curl_setopt($hcurl, CURLOPT_URL, $url);
    curl_setopt($hcurl, CURLOPT_HEADER, true);
    curl_setopt($hcurl, CURLOPT_NOBODY, true);
    curl_setopt($hcurl, CURLOPT_FOLLOWLOCATION, false);
    curl_setopt($hcurl, CURLOPT_SSL_VERIFYPEER, false);
    $headers = curl_exec($hcurl);
    $code = curl_getinfo($hcurl, CURLINFO_HTTP_CODE);

   if($code===404)
   {
      curl_close($hcurl);
      return "404";
   }
   if($code!=301)
   {
      curl_close($hcurl);
      return "";
   }
   
    curl_setopt($hcurl, CURLOPT_FOLLOWLOCATION, true);
    $headers = curl_exec($hcurl);
    $newurl = curl_getinfo($hcurl, CURLINFO_EFFECTIVE_URL);
    $code = curl_getinfo($hcurl, CURLINFO_HTTP_CODE);

   curl_close($hcurl);
   if($code===404)
   {
      return "404";
   }
   if($code!=200)
   {
      return "";
   }
   return $newurl;
}

// Display page path
$dflag=true;
function dispPage($fpath)
{
   global $dflag;
   if($dflag===false)
   {
      return;
   }
   global $VERBOSE;
   if(!$VERBOSE)
   {
      echo ".", "\n";
   }
   echo $fpath, "\n";
   echo str_repeat("-",strlen($fpath)), "\n";
   $dflag=false;
   return;
}

// Search and replace a relative path (reg exp to be avoided)
function relativeReplace($link,$nlink,$attribute)
{
   $ctr=0;
   $ll=strlen($link);
   global $content;
   $ptr=intVal(strpos($content,$link));
   if($ptr===false)
   {
      return 0;
   }
   if($ptr===0)
   {
      return 0;
   }
   if(($ptr+$ll)>=strlen($content))
   {
      return 0;
   }
   $c=$content[$ptr-1];
   if(($c!='"')&&($c!="'"))
   {
      return 0;
   }
   $c2=$content[$ptr+$ll];
   if($c2!=$c)
   {
      return 0;
   }
   $oldstr=$c.$link.$c;
   $newstr=$c.$nlink.$c;
   $content=str_replace($oldstr,$newstr,$content,$ctr);
   return $ctr;
}

// Scan page for URLs
function linkProcess($link,$locdir,$fpath,$attribute)
{
   $rcount=0;
   $nlink="";
   if($link==="")
   {
      return 0;
   }
   if($link[0]==="#")
   {
      return 0;
   }
   if($link[0]===".")
   {
      return 0;
   }
   $chklink=$link;
   if(!hasProtocol($link))
   {
      global $RECONSTRUCT;
      if(!$RECONSTRUCT)
      {
         return 0;
      }
      $chklink=rebuildURL($link,$locdir);
   }
   $nlink=redirected($chklink);
   if($nlink==="")
   {
      return 0;
   }
   dispPage($fpath);
   if($nlink==="404")
   {
      dispBroken($link);
      return 0;
   }
   if($link===$chklink)
   {
      global $content;
      $content=str_replace($link,$nlink,$content,$rcount);
   }
   else
   {
      $rcount=relativeReplace($link,$nlink,$attribute);
   }
   if($rcount===0)
   {
      return 0;
   }
   global $VERBOSE;
   if(!$VERBOSE)
   {
      echo $link, "\n";
   }
   echo " Redirected to:", " ", $nlink, "\n";
   return $rcount;
}

function scanPage($fpath,$locdir)
{
   $dom=new DOMDocument("UTF-8");
   $node=null;
   $count=0;
   $link="";
   global $dflag;
   $dflag=true;

   global $VERBOSE;
   if($VERBOSE)
   {
      echo "Page :", " ", $fpath, "\n";
   }
   global $content;
   $content=file_get_contents($fpath);
   @
   $dom->loadHTML($content);
   global $pcounter;
   $pcounter+=1;
   foreach($dom->getElementsByTagName('a') as $node)
   {
      $link=$node->getAttribute("href");
      $count+=linkProcess($link,$locdir,$fpath,"href");
   }
   foreach($dom->getElementsByTagName('img') as $node)
   {
      $link=$node->getAttribute("src");
      $count+=linkProcess($link,$locdir,$fpath,"src");
   }
   if($count>0)
   {
      $putctr=false;
      global $DISPONLY;
      if(!$DISPONLY)
      {
         $putctr=file_put_contents($fpath,$content);
      }
      if($putctr!=false)
      {
         echo "Saved with ",$count," change",($count>1?"s":"");
         echo "\n";
      }
      else
      {
         echo "Not saved", "\n";
      }
      global $lcounter;
      $lcounter+=$count;
      global $mcounter;
      $mcounter+=1;
   }
   else
   {
      if(!$VERBOSE)
      {
         echo ".";
      }
   }
   return;
}

// Scan directory and subdirectories
function scanDirectory($locdir)
{
   echo "\n";
   echo $locdir, "\n";
   echo str_repeat("-",strlen($locdir)), "\n";
   $dirlist=scandir($locdir);
   if(empty($dirlist))
   {
      return;
   }
   // Processing files

   foreach($dirlist as $name)
   {
      if($name[0]===".")
      {
         continue;
      }
      $e=Path::getExtension($name);
      global $extensions;
      if(!(in_array($e,$extensions)))
      {
         continue;
      }
      $name=Path::merge($locdir,$name);
      if(filetype($name)==="file")
      {
         scanPage($name,$locdir);
         global $pcounter;
         $pcounter+=1;
      }
   }
   // Processing subdirs

   foreach($dirlist as $name)
   {
      if($name[0]==='.')
      {
         continue;
      }
      $name=Path::merge($locdir,$name);
      if(filetype($name)==="dir")
      {
         scanDirectory($name);
         global $dcounter;
         $dcounter+=1;
      }
   }
   return;
}

// Main program
function main($argc,$argv)
{
   $x=array_slice($argv,1);
   foreach($x as $param)
   {
      if($param==="-v")
      {
         global $VERBOSE;
         $VERBOSE=true;
         continue;
      }
      if($param==="-t")
      {
         global $DISPONLY;
         $DISPONLY=true;
         continue;
      }
      if($param[0]==="-")
      {
         echo "Unknown command $param", "\n";
         usage();
      }
      global $website;
      $website=$param;
      if($website[-1]!="/")
      {
         $website.="/";
      }
      global $RECONSTRUCT;
      $RECONSTRUCT=true;
   }
   if(!function_exists("curl_init"))
   {
      die("Curl extension must be enabled.");
   }
   global $root;
   $root=getcwd();
   global $rootlen;
   $rootlen=strlen($root);
   scanDirectory($root);
   global $pcounter;
   global $dcounter;
   echo $pcounter," page",($pcounter>1?"s":"")," scanned in ",$dcounter," dir",($dcounter>1?"s":""),", ";
   global $lcounter;
   echo $lcounter," link",($lcounter>1?"s":"")," redirected.";
   global $bcounter;
   if($bcounter>0)
   {
      echo "\n";
      echo $bcounter," broken link",($bcounter>1?"s":""),".";
   }
   echo "\n";
   global $mcounter;
   echo $mcounter," page",($mcounter>1?"s":"")," updated.";
   echo "\n";
   return 0;
}

main(intVal($argc),$argv);

?>
