/*
    (c) 2026 Scriptol.com
    License: MIT
    Free use.
*/
const http = require('http');
const fs = require('fs');
const path = require('path');
const WebSocket = require('ws');
const { exec } = require('child_process');

const server = http.createServer((req, res) => {
    let filePath = req.url === '/' ? './index.html' : `.${req.url}`;
    const extname = path.extname(filePath);
    const mimeTypes = {
        '.html': 'text/html',
        '.css': 'text/css',
        '.png': 'image/png',
        '.jpg': 'image/jpeg',
        '.jpeg': 'image/jpeg',
    };

    const contentType = mimeTypes[extname] || 'application/octet-stream';

    fs.readFile(filePath, (error, content) => {
        if (error) {
            res.writeHead(404);
            res.end("Fichier non trouvé");
        } else {
            res.writeHead(200, { 'Content-Type': contentType });
            res.end(content, 'utf-8');
        }
    });
});


const wss = new WebSocket.Server({ server });

wss.on('connection', (ws) => {

    ws.on('message', (message) => {
        const data = JSON.parse(message);
        if (data.type === 'LIST_DIR') {
            const dirPath = data.path || '.';
            fs.readdir(dirPath, 
                { withFileTypes: true }, 
                (err, files) => {
                    if (err) return ws.send(
                        JSON.stringify({ type: 'ERROR', message: err.message })
                    );
                
                    const fileList = files.map(f => ({ name: f.name, isDir: f.isDirectory() }));
                    //broadcast({ type: 'DIR_CONTENT', , currentPath:  });
                    ws.send( 
                        JSON.stringify({
                            type: 'DIR', 
                            files: fileList, 
                            currentPath: path.resolve(dirPath)
                        })
                    );                    
            });
        }

        if (data.type === 'READ_FILE') {
            fs.readFile(data.path, 'utf8', (err, content) => {
                if (err) return ws.send(JSON.stringify({ 
                    type: 'ERROR', message: err.message 
                }));
                ws.send( 
                    JSON.stringify({
                    type: 'FILE', 
                    filecontent:content, 
                    fileName: path.basename(data.path) 
                    })
                );
            });
        };
    }); // message
}); // connection

server.listen(3000, () => {
    console.log("Start...");
    switch(process.platform) {
        case "win32":
            exec('start chrome --app=http://localhost:3000');
            //exec('start chrome http://localhost:3000');
            break
        case "darwin":
            exec('open -a "Google Chrome" http://localhost:3000')
            break
        case "linux":
            exec('google-chrome http://localhost:3000')
            break;
    }        
});