<!DOCTYPE html>
<html>
<head>
<meta charset=utf-8>
<script src="scriptolbrowser.js"></script>
<script>
function setShape(element)
{
    var idx=element.selectedIndex;
    var val=element.options[idx].value;
    shape=element.options[idx].innerHTML;
    update()
}

</script>
</head>

<body>
<h1>Canvas Demo in Scriptol</h1>
<canvas id="mycanvas" width="640" height="240"></canvas>
<scriptol>
include "canvas.sol"

text shape = "line"
int shapesize = 100;

canvas cv = document.getElementById("mycanvas")
context ctx = cv.getContext("2d")

void line(int size)
  ctx.beginPath()
  ctx.lineWidth="2"
  ctx.moveTo(100,50)
  ctx.lineTo(200 + size,100 + size)
  ctx.stroke()
return

void circle(int radius)
  ctx.beginPath()
  ctx.lineWidth="2"
  ctx.arc(300, 120, radius, 0, 2 * Math.PI)
  ctx.stroke();
return

void rectangle(int size)
  ctx.beginPath()
  ctx.strokeStyle="blue"   
  ctx.lineWidth="2"
  ctx.rect(200,50,size * 2, size)
  ctx.stroke();
return

void update()
  if shape 
  = "Line": line(shapesize)
  = "Circle": circle(shapesize)
  = "Rectangle": rectangle(shapesize)
  = "None": clear()
  /if
return  

void clearArea()
  ctx.beginPath()
  ctx.rect(0,0, cv.width, cv.height)
  ctx.fillStyle="white"
  ctx.fill()
  var s = document.getElementById("sel1")
  s['value']="None"
return
</scriptol>

<p>Shape : 
<select id="sel1" onChange="setShape(this)">
  <option>Line</option>
  <option>Circle</option>
  <option>Rectangle</option>
  <option>None</option>       
</select>
</p>
<p>Size  : <input type="text" name="in2" value="100" onKeyUp="shapesize = this.value"> </p>
<p>Clear : <button onclick="clearArea()">Clear</button></p>
<hr>
<p><small>Copyright 2014 Scriptol.com -  MIT license.</small></p>
</body>
</html>
