/**
	PHP Implementation of DOM official
	Fully compatible with PHP, requires Scriptol PHP
	This interface (c) 2007-2009 Denis Sureau - Mozilla 1.1 Licence.

    Compatibility: Scriptol PHP.	
*/

extern


class DOMNode
	DOMNode appendChild(DOMNode)
	DOMNode removeChild(DOMNode)
	DOMNode insertBefore(DOMNode, DOMNode = null)
	DOMNode replaceChild(DOMNode, DOMNode)
	text nodeName          // the tag
	text nodeValue         // the content
	text textContent       // the textual content
	int nodeType
	DOMNode parentNode
	DOMNode firstChild
	DOMNode lastChild
	DOMNode previousSibling
	DOMNode nextSibling
/class

class DOMCharacterData is DOMNode
    void appendData(cstring)
    void deleteData(int, int)
    void insertData(int, int)
    void replaceData(int, int, cstring)
    cstring substringData(int, int)
/class

define DOMElement

class DOMAttr is DOMNode
    cstring name                    // read only
    cstring value                   // read write
    DOMElement ownerElement         // read only
/class

class DOMElement is DOMCharacterData
	cstring tagName
    
    void DOMElement(cstring, cstring="")
	boolean hasAttribute(cstring)
	cstring getAttribute(cstring)
	boolean setAttribute(cstring, cstring)
	boolean removeAttribute(cstring)
/class

class DOMComment is DOMCharacterData
/class

class DOMText is DOMCharacterData
	DOMText splitText()
/class

class DOMNodeList
	DOMNode item(integer)
	int length             // the number of elements
/class

class DOMDocument is DOMNode

    boolean validateOnParse
    boolean preserveWhiteSpace

	boolean loadHTMLFile(cstring)	// Load a HTML file
	boolean loadHTML(cstring)		// Create HTML from the raw content of a string
	boolean load(cstring)	     	// Load an XML file
	boolean loadXML(cstring)		// Convert a string into XML. 
	dyn save(cstring)			    // Save HTML or XML into a file.
	cstring saveHTML(cstring = null)	// Return a HTML document (save to string)
	int saveHTMLFile(cstring)          // Save HTML into a file, return size
	cstring saveXML(cstring = null)	// Return an XML document (save to string)
	
	DOMElement getElementById(cstring)
	DOMNodeList getElementsByTagName(cstring)
	
	boolean validate()		// Check using the DTD of the document
	
	DOMElement createElement(cstring)	// Create an orphan DOMElement, use appendChild
	DOMComment createComment(cstring)	// Create an orphan DOMComment
	DOMText createTextNode (cstring)    // Create a content
    DOMAttr createAttribute(cstring)    // Create an orphan attribut   
    DOMNode importNode(DOMNode, boolean = false)         // Create a node from a node in another document

/class

/extern


