
` Propagator 1.1 - Freeware (c) 2009  by Denis Sureau
` www.scriptol.com
` Licence GPL 3.0

` Requires PHP 5

// This program insert, update or delete a tag with a given ID in files.
// The tag is taken from a file and copied into all other files valid in the directory.
// Exemple of use: copy Analytics code at end of static pages in a website.


include "path.sol"
include "dirlist.sol"
include "strtools.sol"
//include "filer.sol"
include "dom.sol"

enum UPDMODE, DELMODE


` Global declarations

text VERSION = "Propagator 1.1 - Scriptol.com"

array extensions = {"htm", "html", "php", "php3", "php4", "php5", "php6", "xhtml", "dhtml", "asp"}

DirList dirtools
StrTools stringtools

constant int FACTOR = 1024

boolean QUIET = false
boolean VERBOSE = false
boolean DEBUG = false
boolean RECURSE = false
boolean DELTAG = false
boolean INSTAG = false
boolean ATSTART = false
boolean HEADTAG = false
boolean SEEONLY = false
boolean WITHPHP = false

int MINSIZE = 1024

constant int PADLEFT = $(STR_PAD_LEFT)

DOMNode SOURCE = null
text IDENTIFIER
text TAGNAME
text CURRPAGE
text SOURCEFILE
text SOURCEDIR 

int MODE = UPDMODE
int TOTAL = 0           ` Total files
int DIRCOUNT = 0        ` Total directories
number COUNTER = 0      ` Occurences of tags

text pattern
text searching = ""
text replacing = ""

void syntax()
    print
	print VERSION
	print "Copy a tag with an ID from a file into the whole website."	
	print "Syntax:   solp propag [options] ID sourcefile"
	print "    or:   php propag.php etc..."
	print "Options:"
	print "  -h       inside head (default inside body)."
	print "  -b       at start of the container tag (default at end)."
	print "  -d       delete (default add or update)."	
	print "  -i       iterate only, do not recurse subdirectories."
	print "  -p       include pages with PHP inside, at your own risks."
	print "  -q       quiet, don't display actions and results."
	print "  -v       verbose, display all parsed files."
    print "  -0..9    digit from 1 to 9, min size for a page to process in kb."
    print "  -t       test, see what will be done and stop before any change." 
	print "Multiple options in a string, -hiq8 for example"
	exit()
return


text dirplural(int count)
    if count > 1 return "ies"
return "y"    

text heading(text name)
    if RECURSE return getcwd() + "/" +  name 
return name 


boolean isHTML(text fname)
	int size = filesize(fname)
	if size = 0
	    print "Error, $currpath is empty."
	    return false 
	/if
	
	if size < MINSIZE
        if not QUIET print "Skipped short file $fname"
        return false 
	/if	
    
    // File without a <body> tag is ignored
    
    text content = file_get_contents(fname)
    text mask = "/<body/i"	
    if preg_match(mask, content) = 0 return false

    // File with PHP code inside is ignored because ?> replaced by ?&gt;

    if WITHPHP return true // Process page with PHP code inside: you know what you do
    mask = "/<.php/i"	
    if preg_match(mask, content) > 0  
        if not QUIET print "Skipped PHP inside $fname"
        return false
    /if    


return true

`---------------------------------------------------
`           Search source and extract content
`---------------------------------------------------

// The method getElementById would be simpler
// but it does not work in most cases

int getSource(text filename)

    DOMDocument page = DOMDocument()
    page.loadHTMLFile(filename)

    text id = nil
    DOMElement element = null
    boolean found = false
    
    if VERBOSE echo "Searching \"", IDENTIFIER, "\" in ", filename, "\n"
    if not file_exists(filename) let die("$filename not found")    
 
    SOURCE = page.getElementById(IDENTIFIER)
    if SOURCE = null       
       die("Identifier \"$IDENTIFIER\" not found in source")
    /if

    if VERBOSE echo "Found \"", IDENTIFIER,"\" in a ", SOURCE.nodeName, " tag.\n"
    
    if SOURCE.textContent = ""
        die("Source empty.")
    /if
     
    if DEBUG
        print "Propagating"
        print SOURCE.textContent
    /if    
   
return COUNTER


`---------------------------------------------------
`               Processing tags
`---------------------------------------------------


boolean deleting(text currpath)

	if DEBUG print "Cleaning" , currpath

    DOMDocument page = DOMDocument()
    if not page.loadHTMLFile(CURRPAGE) 
        if not QUIET print "Skipped", currpath
        return false
    /if    
    
    DOMNode dn = page.getElementById(IDENTIFIER)
    if dn = null
        if not QUIET print "Skipped", currpath
        return false
    /if       
    
    DOMNode parent = dn.parentNode
    if dn = false return false
    parent.removeChild(dn)   

    if not QUIET print "Deleted $IDENTIFIER in $currpath"    
    if SEEONLY return true    
    page.saveHTMLFile(CURRPAGE)

return true


`---------------------------------------------------
`               Add new tag
`---------------------------------------------------

boolean adding(DOMDocument page, text currpath)
    global CURRPAGE
    global SOURCE
	if DEBUG print "Adding to" , currpath
    
    DOMNodeList dnl = page.getElementsByTagName(TAGNAME)
    if dnl.length = 0 
        if not QUIET print "Skipped no $TAGNAME in $currpath."
        return false
    /if        

    DOMNode dn = dnl.item(0)
    DOMNode newnode = page.importNode(SOURCE, true)
    
    if ATSTART
        dn.insertBefore(newnode, dn.firstChild)        
    else
        dn.appendChild(newnode)
    /if  

    if not QUIET print "Added to $currpath"
    if SEEONLY return true
    page.saveHTMLFile($CURRPAGE)
   
return true


`---------------------------------------------------
`               Update the page
`---------------------------------------------------


boolean updating(text currpath)

    global CURRPAGE
	
    DOMDocument page = DOMDocument()
    if not page.loadHTMLFile(CURRPAGE) 
        if not QUIET print "Enable to load", currpath
        return false
    /if     
    

    DOMNode dn = page.getElementById(IDENTIFIER)
    if dn = null 
        return adding(page, currpath)  // processing the DOMDocument
    /if    

	if DEBUG print "Updating" , currpath

    DOMNode newnode = page.importNode(SOURCE, true)
    DOMNode parent = dn.parentNode
    parent.replaceChild(newnode, dn)

    if not QUIET print "Updated $currpath"   
    if SEEONLY return true
    page.saveHTMLFile(CURRPAGE)
        
return true


`---------------------------------------------------
` Parsing the directory and optionally subdirectories
`---------------------------------------------------

void scanning(text thedir)

	array dirarray
	text filename
	text dirname
    text node, ext
        
    text here = getcwd()
    if VERBOSE print '-'.dup(4), here, '-'.dup(56 - here.length())
 
    dyn handle = opendir(".")
    if handle.toBoolean() = false let print "Error, enable to read $here"	
    rewinddir(handle)

    do
        filename = readdir(handle)

        if filename = nil ? break
        if filename in (".", "..") ? continue
        
		if Path.isFile(filename)
		    if thedir = SOURCEDIR
                if filename = SOURCEFILE continue     // this is the source file
            /if      
		    node, ext = Path.splitExt(filename)
            if ext not in extensions continue  
            CURRPAGE = filename
            text currpath = Path.merge(thedir, filename)
            if not isHTML(CURRPAGE) continue           
			TOTAL + 1        ` Total files found
			if MODE
			= DELMODE
              if deleting(currpath) let COUNTER + 1
            else
              if updating(currpath) let COUNTER + 1
            /if      
		/if
   /do forever

    if RECURSE = false
        closedir(handle)
        return
    /if

   rewinddir(handle)

   do
        dirname = readdir(handle)
        if dirname = nil ? break
        if dirname in (".", "..") ? continue
 	
		if Path.isDir(dirname)
		     DIRCOUNT + 1
		     chdir(dirname)
             scanning(Path.merge(thedir, dirname))
		     chdir("..")
		/if
   /do forever
   
   closedir(handle)
   
return

`---------------------------------------------------
`                   Main program
`---------------------------------------------------


int main(int argnum, array arglist)

	` The program requires 1 parameter plus options

	if arglist.size() < 2 let syntax()
	
	text thisdir = getcwd()

	` Defaults

	QUIET = false
	RECURSE = true
	VERBOSE = false
	MINSIZE = 1024
	MODE = UPDMODE
	TAGNAME = "body"

	` Processing options

	text optstr = arglist[1]
    text optchr = optstr[0]
    
    arglist.shift() // removing program name
    
	while (optchr = '-') or (optchr = '/'):
	   text opt = optstr[1..]
	   for text i in opt:
			if i
			= 'h': HEADTAG = true        // Update inside head tag
			       TAGNAME = "head"  
			= 'b': ATSTART = true        // Beginning of container
			= 'd': MODE = DELMODE        // Delete a tag
			= 'i': RECURSE = false       // Do not scan subdirectories
			= 'q': QUIET = true          // Quiet, don't display changes
			       VERBOSE = false
			= 'v': VERBOSE = true        // Verbose, display parsed file
			        QUIET = false
			= 't': SEEONLY = true        // Test, see only options
			= 'p': WITHPHP = true        // Debugging only, do not use
            = 'g': DEBUG = true
                   VERBOSE = true       
            in 0..9: MINSIZE = int(i) * FACTOR  
			else:
				print i , "bad option"
				syntax()
			/if
        /for
	   arglist.shift()              // removing the script's name
	   optstr = arglist[0]
	   optchr = optstr[0]
    /while	

	print
	print VERSION

    if arglist.size() < 2
        die("Argument missing, identifier and source filename required. Stopped.")
    /if
    
    //arglist.display()
    
	IDENTIFIER = arglist[0]
	SOURCEFILE = arglist[1]
	text TARGETFILE = "" 
    if arglist.size() = 3
        TARGETFILE = arglist[2]
    /if    

    if VERBOSE or SEEONLY
        print "Processing from $SOURCEFILE"
        if RECURSE print "recursively subdirectories."; else print "only the source directory."
        echo "When page size is $MINSIZE or more, "
        if MODE = DELMODE echo "delete "; else echo "update or add "
        echo "\"$IDENTIFIER\" tag "
        if ATSTART echo "at start"; else echo "at end";
        print " of $TAGNAME."
        echo "Parsing "
        if SEEONLY print "Test mode, changes are not saved as of -t option."
        if VERBOSE print "Verbose mode."
        if QUIET print "Quiet mode."   
    /if
    
    getSource(SOURCEFILE)
    
    ` Moving to the directory
    
    text location, filename
    location, filename = Path.splitFile(SOURCEFILE)
    print "location=", location, "in", SOURCEFILE

    if TARGETFILE <> nil
        location = TARGETFILE
        filename = ""           // useless in this case
    /if
    
    chdir(location)
    if VERBOSE print "Moving to directory", getcwd()

	` Starting the propagation

    SOURCEFILE = filename
    SOURCEDIR = TARGETFILE
    scanning(TARGETFILE)
    chdir(thisdir)

	if VERBOSE print '-'.dup(60)
	text x = plural(TOTAL)
	text y = dirplural(DIRCOUNT)
	text z = plural(COUNTER)
	print TOTAL, "file$x updated in $DIRCOUNT director$y, $COUNTER tag$z updated."
return 0

main($argc, $argv)

